/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery;

import com.mna.api.config.GeneralConfigValues;
import com.mna.api.items.IPhylacteryItem;
import com.mna.api.items.TieredItem;
import com.mna.tools.math.MathUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemCrystalPhylactery
extends TieredItem
implements IPhylacteryItem {
    private static final String NBT_ENTITYTYPE = "mna:summon_entity_type";
    private static final String NBT_AMOUNT = "mna:summon_fill_pct";

    public ItemCrystalPhylactery() {
        super(new Item.Properties());
    }

    public static int getSoulCap() {
        return Math.max(GeneralConfigValues.PhylacteryKillCount, 1);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IPhylacteryItem.super.appendTooltip(stack, worldIn, tooltip, flagIn);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public int m_142159_(ItemStack stack) {
        float amount = ItemCrystalPhylactery.getFillAmount(stack);
        if (amount < (float)ItemCrystalPhylactery.getSoulCap()) {
            return 0xFFAA00;
        }
        return ChatFormatting.LIGHT_PURPLE.m_126665_();
    }

    public int m_142158_(ItemStack stack) {
        float amount = ItemCrystalPhylactery.getFillAmount(stack);
        if (amount > 0.0f && amount < 8.0f) {
            amount = 8.0f;
        }
        return (int)(13.0f * (amount / (float)ItemCrystalPhylactery.getSoulCap()));
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public static boolean isFilled(ItemStack stack) {
        return ItemCrystalPhylactery.getFillAmount(stack) == (float)ItemCrystalPhylactery.getSoulCap();
    }

    public static boolean addToPhylactery(Container inventory, EntityType<? extends Mob> type, float amount, Level world, boolean allowAddNew) {
        InvWrapper wrapper = new InvWrapper(inventory);
        return ItemCrystalPhylactery.addToPhylactery((IItemHandler)wrapper, type, amount, world, allowAddNew);
    }

    public static boolean addToPhylactery(IItemHandler inventory, EntityType<? extends Mob> type, float amount, Level world, boolean allowAddNew) {
        if (GeneralConfigValues.SummonBlacklist.contains(ForgeRegistries.ENTITY_TYPES.getKey(type).toString())) {
            return false;
        }
        int matching_slot = -1;
        int empty_slot = -1;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!(stack.m_41720_() instanceof IPhylacteryItem)) continue;
            EntityType<? extends Mob> containedType = ((IPhylacteryItem)stack.m_41720_()).getContainedEntity(stack);
            if (containedType == type) {
                float containedAmount = ((IPhylacteryItem)stack.m_41720_()).getContainedSouls(stack);
                if (!(containedAmount < (float)((IPhylacteryItem)stack.m_41720_()).getMaximumFill())) continue;
                matching_slot = i;
                continue;
            }
            if (containedType != null) continue;
            empty_slot = i;
        }
        if (matching_slot > -1) {
            ItemStack matching = inventory.getStackInSlot(matching_slot);
            if (matching.m_41720_() instanceof IPhylacteryItem) {
                float existing = ((IPhylacteryItem)matching.m_41720_()).getContainedSouls(matching);
                amount = MathUtils.clamp(existing + amount, 0.0f, (float)ItemCrystalPhylactery.getSoulCap());
                ((IPhylacteryItem)matching.m_41720_()).setContainedSouls(matching, amount);
                return true;
            }
        } else if (allowAddNew && empty_slot > -1) {
            ItemStack empty = inventory.getStackInSlot(empty_slot);
            if (inventory instanceof Inventory) {
                EntityType<? extends Mob> containedType;
                empty = ItemStack.f_41583_;
                Inventory inv = (Inventory)inventory;
                ItemStack mainHand = inv.f_35978_.m_21205_();
                ItemStack offHand = inv.f_35978_.m_21206_();
                if (offHand.m_41720_() instanceof IPhylacteryItem) {
                    EntityType<? extends Mob> containedType2 = ((IPhylacteryItem)offHand.m_41720_()).getContainedEntity(offHand);
                    if (containedType2 == null) {
                        empty = offHand;
                    }
                } else if (mainHand.m_41720_() instanceof IPhylacteryItem && (containedType = ((IPhylacteryItem)mainHand.m_41720_()).getContainedEntity(mainHand)) == null) {
                    empty = mainHand;
                }
            }
            if (!empty.m_41619_()) {
                ItemCrystalPhylactery.setEntityType(empty, type, world);
                ItemCrystalPhylactery.setFillAmount(empty, amount);
                return true;
            }
        }
        return false;
    }

    public static boolean setFillAmount(ItemStack stack, float amount) {
        if (!(stack.m_41720_() instanceof IPhylacteryItem) || ItemCrystalPhylactery.getEntityType(stack) == null) {
            return false;
        }
        stack.m_41783_().m_128350_(NBT_AMOUNT, amount);
        return true;
    }

    public static float getFillAmount(ItemStack stack) {
        if (!(stack.m_41720_() instanceof IPhylacteryItem) || ItemCrystalPhylactery.getEntityType(stack) == null) {
            return 0.0f;
        }
        return MathUtils.clamp(stack.m_41783_().m_128457_(NBT_AMOUNT), 0.0f, (float)ItemCrystalPhylactery.getSoulCap());
    }

    @Nullable
    public static EntityType<? extends Mob> getEntityType(ItemStack stack) {
        if (!(stack.m_41720_() instanceof IPhylacteryItem && stack.m_41773_() <= 0 && stack.m_41782_() && stack.m_41783_().m_128441_(NBT_ENTITYTYPE))) {
            return null;
        }
        String type = stack.m_41783_().m_128461_(NBT_ENTITYTYPE);
        ResourceLocation rLoc = new ResourceLocation(type);
        try {
            EntityType resolvedType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rLoc);
            return resolvedType;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static boolean setEntityType(ItemStack stack, EntityType<? extends Mob> type, Level world) {
        if (!(stack.m_41720_() instanceof IPhylacteryItem) || ItemCrystalPhylactery.getEntityType(stack) != null) {
            return false;
        }
        Mob inst = (Mob)type.m_20615_(world);
        if (!GeneralConfigValues.BossesAllowedInPhylacteries && !inst.m_6072_()) {
            return false;
        }
        stack.m_41784_().m_128359_(NBT_ENTITYTYPE, ForgeRegistries.ENTITY_TYPES.getKey(type).toString());
        return true;
    }

    @Override
    public boolean fill(IItemHandler inventory, EntityType<? extends Mob> type, float amount, Level world, boolean allowAddNew) {
        return ItemCrystalPhylactery.addToPhylactery(inventory, type, amount, world, allowAddNew);
    }

    @Override
    public boolean fill(Container inventory, EntityType<? extends Mob> type, float amount, Level world, boolean allowAddNew) {
        return ItemCrystalPhylactery.addToPhylactery(inventory, type, amount, world, allowAddNew);
    }

    @Override
    public boolean fill(ItemStack stack, EntityType<? extends Mob> type, float amount, Level world) {
        if (!(stack.m_41720_() instanceof IPhylacteryItem)) {
            return false;
        }
        EntityType<? extends Mob> containedType = ItemCrystalPhylactery.getEntityType(stack);
        if (containedType != null && containedType != type) {
            return false;
        }
        if (containedType == null && !ItemCrystalPhylactery.setEntityType(stack, type, world)) {
            return false;
        }
        float existing = ((IPhylacteryItem)stack.m_41720_()).getContainedSouls(stack);
        return ItemCrystalPhylactery.setFillAmount(stack, existing + amount);
    }

    @Override
    public EntityType<? extends Mob> getContainedEntity(ItemStack stack) {
        return ItemCrystalPhylactery.getEntityType(stack);
    }

    @Override
    public float getFillPct(ItemStack stack) {
        return MathUtils.clamp01(ItemCrystalPhylactery.getFillAmount(stack) / (float)ItemCrystalPhylactery.getSoulCap());
    }

    @Override
    public boolean isFull(ItemStack stack) {
        return ItemCrystalPhylactery.isFilled(stack);
    }

    @Override
    public int getMaximumFill() {
        return ItemCrystalPhylactery.getSoulCap();
    }

    @Override
    public float getContainedSouls(ItemStack stack) {
        return ItemCrystalPhylactery.getFillAmount(stack);
    }

    @Override
    public boolean setContainedSouls(ItemStack stack, float amount) {
        return ItemCrystalPhylactery.setFillAmount(stack, amount);
    }
}

