/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery;

import com.mna.Registries;
import com.mna.api.items.TieredItem;
import com.mna.api.spells.parts.Modifier;
import com.mna.items.base.IRadialMenuItem;
import com.mna.items.renderers.books.AlterationBookRenderer;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.spells.ModifierRecipe;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;

public class ItemModifierBook
extends TieredItem
implements IRadialMenuItem {
    public static final String NBT_MODIFIER_ID = "key_modifier";

    public ItemModifierBook() {
        super(new Item.Properties());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new AlterationBookRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ItemModifierBook.getModifier(stack).ifPresent(m -> tooltip.add((Component)Component.m_237115_((String)m.getRegistryName().toString()).m_130940_(ChatFormatting.AQUA)));
        IRadialMenuItem.super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    public static final Optional<Modifier> getModifier(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(NBT_MODIFIER_ID)) {
            return Optional.empty();
        }
        ResourceLocation rLoc = new ResourceLocation(stack.m_41783_().m_128461_(NBT_MODIFIER_ID));
        return Optional.ofNullable((Modifier)Registries.Modifier.get().getValue(rLoc));
    }

    public static final Optional<ModifierRecipe> getRecipe(Modifier modifier, Level world) {
        return world.m_7465_().m_44013_((RecipeType)RecipeInit.MODIFIER_TYPE.get()).stream().filter(m -> m.getComponent() == modifier).findFirst();
    }

    public static final void setModifier(ItemStack stack, ResourceLocation modifierRloc) {
        stack.m_41784_().m_128359_(NBT_MODIFIER_ID, modifierRloc.toString());
    }
}

