/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.items.ITieredItem;
import com.mna.api.items.inventory.ISpellBookInventory;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.gui.containers.providers.NamedSpellBook;
import com.mna.inventory.InventorySpellBook;
import com.mna.items.ItemInit;
import com.mna.items.base.IRadialMenuItem;
import com.mna.items.renderers.books.SpellBookRenderer;
import com.mna.items.sorcery.ItemBookOfRote;
import com.mna.items.sorcery.ItemSpell;
import com.mna.network.ClientMessageDispatcher;
import com.mna.network.messages.to_server.SpellBookSlotChangeMessage;
import com.mna.spells.crafting.SpellRecipe;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.items.IItemHandler;

public class ItemSpellBook
extends ItemSpell
implements IRadialMenuItem,
ITieredItem<ItemSpellBook>,
DyeableLeatherItem {
    public static final String KEY_ACTIVE_SLOT = "active_slot";
    protected static final String KEY_USE_DURATION = "cur_spell_use_duration";
    public static String NBT_ID = "mna:spell_book_data";
    public static final int MAX_ACTIVE_SLOT = 8;
    protected int tier = -1;
    public final boolean renderBookModel;
    public final boolean useMnABookModel;
    private final boolean renderInFirstPerson;
    private final ResourceLocation open_model;
    private final ResourceLocation closed_model;

    public ItemSpellBook(boolean renderBookModel) {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
        this.renderBookModel = renderBookModel;
        this.useMnABookModel = true;
        this.open_model = null;
        this.closed_model = null;
        this.renderInFirstPerson = false;
    }

    public ItemSpellBook(Item.Properties properties, @Nullable ResourceLocation openModel, @Nullable ResourceLocation closedModel, boolean renderInFirstPerson) {
        super(properties);
        this.useMnABookModel = openModel != null && closedModel != null;
        this.renderBookModel = this.useMnABookModel;
        this.open_model = openModel;
        this.closed_model = closedModel;
        this.renderInFirstPerson = renderInFirstPerson;
    }

    @Override
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> {
                if (ItemSpellBook.this.useMnABookModel) {
                    return new SpellBookRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
                }
                return new SpellBookRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_(), ItemSpellBook.this.open_model, ItemSpellBook.this.closed_model, ItemSpellBook.this.renderInFirstPerson);
            });

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    @Override
    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @Override
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack book = player.m_21120_(hand);
        player.m_6674_(hand);
        if (!(world.f_46443_ || hand != InteractionHand.OFF_HAND && this.openGuiIfModifierPressed(book, player, world) || !(book.m_41720_() instanceof ItemSpellBook))) {
            return this.castCurrentSpell(book, player, world, hand);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43723_().m_6144_()) {
            return this.castCurrentSpell(stack, context.m_43723_(), context.m_43725_(), context.m_43724_()).m_19089_();
        }
        return InteractionResult.PASS;
    }

    private InteractionResultHolder<ItemStack> castCurrentSpell(ItemStack book, Player player, Level world, InteractionHand hand) {
        ItemStack selectedStack;
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19100_((Object)book);
        }
        ISpellBookInventory bookInv = this.getInventory(book, (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null));
        ItemStack itemStack = selectedStack = book.m_41720_() == ItemInit.GRIMOIRE.get() || book.m_41720_() instanceof ItemBookOfRote ? bookInv.getActiveSpells()[ItemSpellBook.getActiveSpellSlot(book)] : bookInv.getActiveSpells()[ItemSpellBook.getActiveSpellSlot(book)];
        if (!selectedStack.m_41619_()) {
            InteractionResultHolder<ItemStack> result = ItemSpell.castSpellOnUse(selectedStack, world, player, hand, s -> true);
            switch (result.m_19089_()) {
                case CONSUME: 
                case CONSUME_PARTIAL: {
                    return InteractionResultHolder.m_19096_((Object)book);
                }
                case FAIL: {
                    return InteractionResultHolder.m_19100_((Object)book);
                }
                case PASS: {
                    return InteractionResultHolder.m_19098_((Object)book);
                }
                case SUCCESS: {
                    return InteractionResultHolder.m_19090_((Object)book);
                }
            }
        }
        return InteractionResultHolder.m_19100_((Object)book);
    }

    @Override
    public int m_8105_(ItemStack stack) {
        InventorySpellBook bookInv = new InventorySpellBook(stack);
        ItemStack selectedStack = bookInv.getStackInSlot(ItemSpellBook.getActiveSpellSlot(stack) * 5);
        return super.m_8105_(selectedStack);
    }

    @Override
    public void m_5929_(Level pLevel, LivingEntity player, ItemStack stack, int count) {
        if (player instanceof Player) {
            ItemStack selectedStack = this.getSelectedStack(stack, (Player)player);
            super.m_5929_(pLevel, player, selectedStack, count);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_(NBT_ID)) {
            stack.m_41751_(nbt);
        }
        return null;
    }

    public static int getActiveSpellSlot(ItemStack item) {
        if (item.m_41782_()) {
            return item.m_41783_().m_128451_(KEY_ACTIVE_SLOT);
        }
        return 0;
    }

    @Nullable
    public ISpellBookInventory getInventory(ItemStack item, @Nullable IPlayerMagic magic) {
        return new InventorySpellBook(item);
    }

    public static void setSlot(Player player, ItemStack stack, int slot, boolean offhand, boolean packet) {
        if (stack.m_41720_() instanceof ItemSpellBook) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_(KEY_ACTIVE_SLOT, slot);
            CompoundTag spellCompound = ((ItemSpellBook)stack.m_41720_()).getSpellCompound(stack, player);
            tag.m_128405_(KEY_USE_DURATION, SpellRecipe.fromNBT(spellCompound).getMaxChannelTime());
            if (packet) {
                ClientMessageDispatcher.sendSpellBookSlotChange(slot, offhand);
            } else {
                ISpellBookInventory inv = ((ItemSpellBook)stack.m_41720_()).getInventory(stack, (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null));
                if (inv != null) {
                    ItemStack spell = inv.getActiveSpells()[slot % inv.getActiveSpells().length];
                    if (!spell.m_41619_()) {
                        stack.m_41714_(spell.m_41786_());
                    } else {
                        stack.m_41787_();
                    }
                }
            }
        }
    }

    public static void handleSlotChangeMessage(SpellBookSlotChangeMessage msg, ServerPlayer player) {
        ItemStack stack;
        ItemStack itemStack = stack = msg.isOffhand() ? player.m_21206_() : player.m_21205_();
        if (stack.m_41720_() instanceof ItemSpellBook) {
            ItemSpellBook.setSlot((Player)player, stack, msg.getSlot(), msg.isOffhand(), false);
        }
    }

    @Override
    public CompoundTag getSpellCompound(ItemStack stack, @Nullable Player player) {
        if (stack.m_41720_() instanceof ItemSpellBook) {
            IItemHandler bookInv = (IItemHandler)this.getInventory(stack, null);
            ItemStack selectedStack = bookInv.getStackInSlot(ItemSpellBook.getActiveSpellSlot(stack) * 5);
            return selectedStack.m_41783_();
        }
        return new CompoundTag();
    }

    protected ItemStack getSelectedStack(ItemStack bookStack, @Nullable Player player) {
        if (bookStack.m_41720_() instanceof ItemSpellBook) {
            IItemHandler bookInv = (IItemHandler)this.getInventory(bookStack, null);
            ItemStack selectedStack = bookInv.getStackInSlot(ItemSpellBook.getActiveSpellSlot(bookStack) * 5);
            return selectedStack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedSpellBook(stack);
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        IRadialMenuItem.super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public boolean canAcceptSpell(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canAcceptSpell(ItemStack stack, ISpellDefinition spell) {
        return false;
    }

    @Override
    public int getCachedTier() {
        return this.tier;
    }

    @Override
    public void setCachedTier(int tier) {
        this.tier = tier;
    }
}

