/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mna.Registries;
import com.mna.api.items.ITieredItem;
import com.mna.api.items.ItemUtils;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.SpellReagent;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.collections.Shapes;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.tools.CollectionUtils;
import com.mna.api.tools.MATags;
import com.mna.enchantments.framework.EnchantmentInit;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.ItemSpell;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class ItemStaff
extends ItemSpell
implements ITieredItem<ItemStaff> {
    private static final String KEY_CHARGES = "charges";
    protected float attackDamage = 4.5f;
    private final int enchantability = 25;
    private static int charge_modifier = 40;
    private int tier = -1;
    private final ArrayList<Enchantment> allowedEnchantments = new ArrayList();
    private final Multimap<net.minecraft.world.entity.ai.attributes.Attribute, AttributeModifier> attributeModifiers;

    public ItemStaff(float attackDamage) {
        this(attackDamage, -3.0f);
    }

    public ItemStaff(Item.Properties properties, float attackDamage, float attackSpeed) {
        super(properties);
        this.attackDamage = attackDamage;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public ItemStaff(float attackDamage, float attackSpeed) {
        super(new Item.Properties().m_41499_(100).m_41503_(100).setNoRepair());
        this.attackDamage = attackDamage;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    @Override
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public boolean addItemWithGuiTooltip(ItemStack stack) {
        return this.shouldConsumeMana(stack);
    }

    @Override
    public boolean openGuiIfModifierPressed(ItemStack stack, Player player, Level world) {
        if (!this.shouldConsumeMana(stack)) {
            return false;
        }
        return super.openGuiIfModifierPressed(stack, player, world);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack activeStack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_ && !this.shouldConsumeMana(activeStack)) {
            this.consumeCharge(activeStack, playerIn, handIn);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public int getMaxDamage(ItemStack stack) {
        if (!stack.m_41782_()) {
            return super.getMaxDamage(stack);
        }
        CompoundTag tag = stack.m_41783_();
        if (!tag.m_128441_(KEY_CHARGES)) {
            return super.getMaxDamage(stack);
        }
        return tag.m_128451_(KEY_CHARGES);
    }

    public int m_142159_(ItemStack stack) {
        return FastColor.ARGB32.m_13660_((int)255, (int)128, (int)64, (int)255);
    }

    public int m_142158_(ItemStack stack) {
        SpellRecipe recipe = SpellRecipe.fromNBT(stack.m_41784_());
        int chargeConsumed = (int)Math.ceil(recipe.getManaCost());
        if (!recipe.isChanneled()) {
            chargeConsumed *= charge_modifier;
        }
        int charges = ItemUtils.getCharges(stack) - chargeConsumed;
        int maxCharges = Math.max(ItemUtils.getMaxCharges(stack), 1);
        float pct = (float)charges / (float)maxCharges;
        return Math.round(13.0f * pct);
    }

    public boolean m_142522_(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag.m_128441_(KEY_CHARGES);
    }

    @Override
    protected boolean shouldConsumeMana(ItemStack stack) {
        if (!stack.m_41782_()) {
            return true;
        }
        return !stack.m_41783_().m_128441_(KEY_CHARGES);
    }

    @Override
    protected boolean consumeChanneledMana(Player player, ItemStack stack) {
        if (this.shouldConsumeMana(stack)) {
            return super.consumeChanneledMana(player, stack);
        }
        this.consumeCharge(stack, player, player.m_7655_());
        return true;
    }

    protected void consumeCharge(ItemStack spellStack, Player player, InteractionHand handIn) {
        if (player.m_7500_()) {
            return;
        }
        SpellRecipe recipe = SpellRecipe.fromNBT(spellStack.m_41784_());
        if (!recipe.isValid()) {
            return;
        }
        int chargeConsumed = (int)Math.ceil(recipe.getManaCost());
        if (!recipe.isChanneled()) {
            chargeConsumed *= charge_modifier;
        }
        int charges = ItemUtils.getCharges(spellStack) - chargeConsumed;
        int maxCharges = Math.max(ItemUtils.getMaxCharges(spellStack), 1);
        ItemUtils.writeCharges(spellStack, charges);
        float damagePct = 1.0f - (float)charges / (float)maxCharges;
        int newDamage = (int)((float)spellStack.m_41776_() * damagePct);
        if (charges <= 0) {
            player.m_21190_(handIn);
            Item item = spellStack.m_41720_();
            spellStack.m_41774_(1);
            player.m_36246_(Stats.f_12983_.m_12902_((Object)item));
            spellStack.m_41721_(0);
        } else {
            spellStack.m_41721_(newDamage);
        }
    }

    @Override
    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @Override
    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public Multimap<net.minecraft.world.entity.ai.attributes.Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 25;
    }

    @Override
    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)book);
        for (Enchantment ench : enchantments.keySet()) {
            if (this.getAllowedEnchantments().contains(ench)) continue;
            return false;
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.getAllowedEnchantments().contains(enchantment);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        SpellRecipe recipe = SpellRecipe.fromNBT(stack.m_41784_());
        if (recipe != null && !recipe.isMysterious()) {
            int charges;
            int chargeConsumed = (int)Math.ceil(recipe.getManaCost());
            if (!recipe.isChanneled()) {
                chargeConsumed *= charge_modifier;
            }
            if ((charges = (int)Math.ceil((float)ItemUtils.getCharges(stack) / Math.max((float)chargeConsumed, 1.0f))) > 0) {
                MutableComponent comp = Component.m_237110_((String)"item.mna.spell.charges_display", (Object[])new Object[]{charges}).m_130940_(ChatFormatting.AQUA);
                tooltip.add((Component)comp);
            }
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public static ItemStack buildRandomSpellStaff(float chanceForForceSelf, float chanceForNoHelpfulLogic, boolean allowMessWithMori, ServerLevel level) {
        boolean skipTags;
        boolean forceSelf;
        Random random = new Random();
        ItemStack stack = MATags.getRandomItemFrom(MATags.Items.GENERATED_SPELL_ITEMS);
        if (stack.m_41619_()) {
            stack = new ItemStack((ItemLike)ItemInit.STAFF_AUM.get());
        }
        SpellRecipe randomRecipe = new SpellRecipe();
        int numCharges = 20 + (int)(Math.random() * 180.0);
        boolean bl = forceSelf = Math.random() <= (double)chanceForForceSelf;
        boolean bl2 = forceSelf ? false : (skipTags = Math.random() <= (double)chanceForNoHelpfulLogic);
        if (!forceSelf) {
            List<Shape> shapeList = Registries.Shape.get().getValues().stream().filter(s -> s.canBeOnRandomStaff()).collect(Collectors.toList());
            MutableInt tierTotal = new MutableInt(0);
            shapeList.forEach(s -> tierTotal.add(s.getTier((Level)level)));
            shapeList.sort((a, b) -> {
                int bT;
                int aT = a.getTier((Level)level);
                if (aT < (bT = b.getTier((Level)level))) {
                    return -1;
                }
                if (aT > bT) {
                    return 1;
                }
                return 0;
            });
            double r = Math.random() * (double)tierTotal.getValue().intValue();
            Shape selectedShape = null;
            for (Shape shape : shapeList) {
                if (!((r -= (double)(6 - shape.getTier((Level)level))) <= 0.0)) continue;
                selectedShape = shape;
                break;
            }
            randomRecipe.setShape(selectedShape);
        } else {
            randomRecipe.setShape(Shapes.SELF);
        }
        MutableObject targetTag = new MutableObject((Object)((Shape)((ModifiedSpellPart)randomRecipe.getShape()).getPart()).getUseTag());
        if (forceSelf) {
            double rnd = random.nextDouble();
            if (rnd < 0.05) {
                targetTag.setValue((Object)SpellPartTags.DONOTUSE);
            } else if (rnd < 0.75) {
                targetTag.setValue((Object)SpellPartTags.HARMFUL);
            } else {
                targetTag.setValue((Object)SpellPartTags.SELF);
            }
        }
        int count = MathUtils.clamp(MathUtils.weightedRandomNumber(new int[]{89, 5, 3, 2, 1}) + 1, 1, 5);
        for (int i = 0; i < count; ++i) {
            SpellEffect c2 = CollectionUtils.getRandom(Registries.SpellEffect.get().getValues().stream().filter(comp -> {
                if (comp.getUseTag() == SpellPartTags.DONOTUSE && !skipTags || !comp.canBeOnRandomStaff()) {
                    return false;
                }
                List<SpellReagent> reagents = comp.getRequiredReagents(null, null);
                if (reagents != null && reagents.size() > 0) {
                    return false;
                }
                return skipTags ? true : CollectionUtils.componentMatchesShapeAndTag((Shape)((ModifiedSpellPart)randomRecipe.getShape()).getPart(), comp, (SpellPartTags)((Object)((Object)targetTag.getValue())));
            }).collect(Collectors.toList())).orElse(null);
            if (c2 == null) continue;
            if (targetTag.getValue() == SpellPartTags.NEUTRAL) {
                targetTag.setValue((Object)c2.getUseTag());
            }
            randomRecipe.addComponent(c2);
        }
        if (randomRecipe.getComponents().size() == 0) {
            return stack;
        }
        for (Attribute attr : ((ModifiedSpellPart)randomRecipe.getShape()).getContainedAttributes()) {
            if (attr == Attribute.DELAY) continue;
            ((ModifiedSpellPart)randomRecipe.getShape()).setValue(attr, ((ModifiedSpellPart)randomRecipe.getShape()).getMinimumValue(attr) + (((ModifiedSpellPart)randomRecipe.getShape()).getMaximumValue(attr) - ((ModifiedSpellPart)randomRecipe.getShape()).getMinimumValue(attr)) * (float)Math.random());
        }
        randomRecipe.iterateComponents(c -> {
            for (Attribute attr : c.getContainedAttributes()) {
                if (attr == Attribute.DELAY) continue;
                c.setValue(attr, c.getMinimumValue(attr) + (c.getMaximumValue(attr) - c.getMinimumValue(attr)) * 0.5f + ((float)Math.random() - 0.5f));
            }
        });
        if (!randomRecipe.isValid()) {
            return ItemStack.f_41583_;
        }
        randomRecipe.setMysterious(true);
        randomRecipe.writeToNBT(stack.m_41784_());
        int charges = (int)((float)numCharges * randomRecipe.getManaCost());
        ItemUtils.writeCharges(stack, charges *= charge_modifier);
        ItemUtils.writeMaxCharges(stack, charges);
        return stack;
    }

    protected ArrayList<Enchantment> getAllowedEnchantments() {
        this.allowedEnchantments.clear();
        if (this.allowedEnchantments.size() == 0) {
            this.allowedEnchantments.add(Enchantments.f_44979_);
            this.allowedEnchantments.add(Enchantments.f_44981_);
            this.allowedEnchantments.add(Enchantments.f_44980_);
            this.allowedEnchantments.add(Enchantments.f_44982_);
            this.allowedEnchantments.add(Enchantments.f_44978_);
            this.allowedEnchantments.add((Enchantment)EnchantmentInit.BEHEADING.get());
            this.allowedEnchantments.add((Enchantment)EnchantmentInit.DURATION_MOD.get());
            this.allowedEnchantments.add((Enchantment)EnchantmentInit.RANGE_MOD.get());
            this.allowedEnchantments.add((Enchantment)EnchantmentInit.SPEED_MOD.get());
            this.allowedEnchantments.add((Enchantment)EnchantmentInit.BLUDGEONING.get());
            this.allowedEnchantments.add(Enchantments.f_44971_);
            this.allowedEnchantments.add(Enchantments.f_44958_);
            this.allowedEnchantments.add(Enchantments.f_44984_);
            this.allowedEnchantments.add(Enchantments.f_44990_);
            this.allowedEnchantments.add(Enchantments.f_44955_);
            this.allowedEnchantments.add(Enchantments.f_44954_);
            this.allowedEnchantments.add(Enchantments.f_44988_);
            this.allowedEnchantments.add(Enchantments.f_44960_);
            this.allowedEnchantments.add(Enchantments.f_44972_);
            this.allowedEnchantments.add(Enchantments.f_44974_);
            this.buildAllowedEnchantments(this.allowedEnchantments);
        }
        return this.allowedEnchantments;
    }

    protected void buildAllowedEnchantments(ArrayList<Enchantment> defaultList) {
    }

    @Override
    public void setCachedTier(int tier) {
        this.tier = tier;
    }

    @Override
    public int getCachedTier() {
        return this.tier;
    }

    public boolean isChargeSpell(ItemStack stack) {
        return !this.shouldConsumeMana(stack);
    }
}

