/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery.bound;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.interop.CuriosInterop;
import com.mna.items.ItemInit;
import com.mna.items.base.INoCreativeTab;
import com.mna.items.renderers.bound.BoundAxeItemRenderer;
import com.mna.items.sorcery.bound.IBoundItem;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.NonNullLazy;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import top.theillusivec4.curios.api.SlotTypePreset;

public class ItemBoundAxe
extends AxeItem
implements IBoundItem,
INoCreativeTab {
    public AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ItemBoundAxe(float attackDamageIn, float attackSpeedIn) {
        super((Tier)Tiers.DIAMOND, attackDamageIn, attackSpeedIn, new Item.Properties());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new BoundAxeItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    @Override
    public float getPassiveManaDrain(Entity entity) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (CuriosInterop.IsItemInCurioSlot((Item)ItemInit.BATTLEMAGE_AMULET.get(), (LivingEntity)p, SlotTypePreset.NECKLACE)) {
                return 0.0f;
            }
        }
        return 0.2f;
    }

    public Multimap<net.minecraft.world.entity.ai.attributes.Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap baseAttrs = super.getAttributeModifiers(slot, stack);
        if (slot != EquipmentSlot.MAINHAND) {
            return baseAttrs;
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!stack.m_41782_()) {
            return baseAttrs;
        }
        SpellRecipe recipe = SpellRecipe.fromNBT(stack.m_41783_());
        if (!recipe.isValid()) {
            return baseAttrs;
        }
        int damage = (int)((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.DAMAGE);
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)damage, AttributeModifier.Operation.ADDITION));
        int range = (int)((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RANGE);
        builder.put((Object)((net.minecraft.world.entity.ai.attributes.Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_RANGE_UUID, "Weapon modifier", (double)range, AttributeModifier.Operation.ADDITION));
        baseAttrs.forEach((a, m) -> {
            if (a == ForgeMod.ENTITY_REACH.get() || a == Attributes.f_22281_) {
                return;
            }
            builder.put(a, m);
        });
        return builder.build();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        SpellRecipe recipe = this.getRecipe(stack);
        if (attacker instanceof Player && recipe.isValid() && !(player = (Player)attacker).m_36335_().m_41519_((Item)this)) {
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(c -> {
                if (c.getCastingResource().hasEnoughAbsolute((LivingEntity)player, recipe.getManaCost()) && this.affectTarget(recipe, attacker, target, InteractionHand.MAIN_HAND)) {
                    c.getCastingResource().consume((LivingEntity)player, recipe.getManaCost());
                }
            });
            player.m_36335_().m_41524_((Item)this, (int)((float)recipe.getCooldown((LivingEntity)player) * 0.75f));
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.handleInventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        SpellRecipe recipe = this.getRecipe(stack);
        recipe.addItemTooltip(stack, worldIn, tooltip, (Player)mc.f_91074_);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public ItemStack createFromSpell(ItemStack original, ISpellDefinition recipe) {
        return IBoundItem.super.createFromSpell((Item)this, original, recipe);
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        ItemStack restored = this.restoreItem(item);
        player.m_150109_().m_6836_(player.m_150109_().f_35977_, restored);
        return false;
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenLoop("animation.bound_swordaxe.idle")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }
}

