/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.handlers;

import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.tileentities.ParticleEmitterTile;
import com.mna.blocks.tileentities.wizard_lab.InscriptionTableTile;
import com.mna.capabilities.entity.MAPFXProvider;
import com.mna.capabilities.particles.ParticleAuraProvider;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.entities.IAnimPacketSync;
import com.mna.entities.rituals.Ritual;
import com.mna.gui.HUDOverlayRenderer;
import com.mna.gui.containers.entity.ContainerWanderingWizard;
import com.mna.gui.containers.item.ContainerEnderDisc;
import com.mna.network.messages.BaseMessage;
import com.mna.network.messages.to_client.AuraSyncMessageToClient;
import com.mna.network.messages.to_client.CantripCastingTimerMessage;
import com.mna.network.messages.to_client.ClientboundPlayerFocusDistanceMessage;
import com.mna.network.messages.to_client.CloudstepJumpMessage;
import com.mna.network.messages.to_client.EnderDiscGuiDimensionCycle;
import com.mna.network.messages.to_client.EntityStateMessage;
import com.mna.network.messages.to_client.ExtendedSlotContainerContentsMessage;
import com.mna.network.messages.to_client.ExtendedSlotContentsMessage;
import com.mna.network.messages.to_client.MAPFXMessage;
import com.mna.network.messages.to_client.MagicSyncMessageToClient;
import com.mna.network.messages.to_client.MindVisionMessage;
import com.mna.network.messages.to_client.PosessionMessage;
import com.mna.network.messages.to_client.ProgressionSyncMessageToClient;
import com.mna.network.messages.to_client.RecalculateGuidebookUnlocks;
import com.mna.network.messages.to_client.RespondLootTableItems;
import com.mna.network.messages.to_client.RoteProgressSyncMessageToClient;
import com.mna.network.messages.to_client.SetIcarianDataMessage;
import com.mna.network.messages.to_client.SetLiftPositionMessage;
import com.mna.network.messages.to_client.SetLiftSpeedMessage;
import com.mna.network.messages.to_client.SetRitualCollectedReagentsMessage;
import com.mna.network.messages.to_client.ShowDidYouKnow;
import com.mna.network.messages.to_client.SpawnParticleEffectMessage;
import com.mna.network.messages.to_client.SpawnParticleMessage;
import com.mna.network.messages.to_client.StructureSyncMessage;
import com.mna.network.messages.to_client.WanderingWizardInventoryMessage;
import com.mna.network.messages.to_client.WellspringPowerNetworkSyncMessage;
import com.mna.network.messages.to_client.WellspringSyncMessage;
import com.mna.network.messages.to_server.InscriptionTableCraftingUpdateMessage;
import com.mna.recipes.multiblock.MultiblockDefinition;
import com.mna.tools.loot.LootTableCache;
import com.mna.tools.math.MathUtils;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientMessageHandler {
    private static <T extends BaseMessage> boolean validateBasics(T message, NetworkEvent.Context ctx) {
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.CLIENT) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " received on wrong side: " + sideReceived);
            return false;
        }
        if (!message.isMessageValid()) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " was invalid: " + message);
            return false;
        }
        return true;
    }

    public static void handleMagicSyncMessage(MagicSyncMessageToClient message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processMagicSyncMessage((Level)clientWorld.get(), message));
    }

    public static void handleEnderDiscGuiDimensionCycle(EnderDiscGuiDimensionCycle message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("EnderDiscGuiDimensionCycle context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processEnderDiscGuiDimensionCycle(Minecraft.m_91087_(), message));
    }

    public static void handleRespondLootTableItems(RespondLootTableItems message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("RespondLootTableItems context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processRespondLootTableItems(Minecraft.m_91087_(), message));
    }

    public static void handleShowDidYouKnow(ShowDidYouKnow message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("ShowDidYouKnow context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> message.Handle());
    }

    public static void handleRecalculateGuidebookUnlocks(RecalculateGuidebookUnlocks message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("RecalculateGuidebookUnlocks context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> message.Handle());
    }

    public static void handleSetIcarianDataMessage(SetIcarianDataMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("SetIcarianDataMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> message.Handle((Level)clientWorld.get()));
    }

    public static void handleClientboundPlayerFocusDistanceMessage(ClientboundPlayerFocusDistanceMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            Player player = ManaAndArtifice.instance.proxy.getClientPlayer();
            if (player == null) {
                return;
            }
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.setFocusDistance(message.getDelta()));
        });
    }

    public static void handleEntityStateMessage(EntityStateMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processEntityStateMessage((Level)clientWorld.get(), message));
    }

    public static void handleProgressionSyncMessage(ProgressionSyncMessageToClient message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("ProgressionSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processProgressionSyncMessage((Level)clientWorld.get(), message));
    }

    public static void handleRoteSyncMessage(RoteProgressSyncMessageToClient message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("RoteProgressSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processRoteSyncMessage((Level)clientWorld.get(), message));
    }

    public static void handleInscriptionTableCraftingUpdate(InscriptionTableCraftingUpdateMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        InscriptionTableTile.handleCraftingUpdate((Level)clientWorld.get(), message);
    }

    public static void handleSpawnParticleMessage(SpawnParticleMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("SpawnParticleMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            ParticleType resolvedType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(message.getType());
            if (resolvedType == null || !(resolvedType instanceof MAParticleType)) {
                return;
            }
            MAParticleType particle = new MAParticleType((MAParticleType)resolvedType);
            if (message.getColor() != 0) {
                int clr = message.getColor();
                float pct = MathUtils.clamp((float)FastColor.ARGB32.m_13655_((int)clr) / 255.0f, 0.1f, 1.0f);
                particle.setColor((float)FastColor.ARGB32.m_13665_((int)clr) * pct, (float)FastColor.ARGB32.m_13667_((int)clr) * pct, (float)FastColor.ARGB32.m_13669_((int)clr) * pct);
            }
            ((Level)clientWorld.get()).m_7106_((ParticleOptions)particle, (double)message.getPosition().x, (double)message.getPosition().y, (double)message.getPosition().z, (double)message.getSpeed().x, (double)message.getSpeed().y, (double)message.getSpeed().z);
        });
    }

    public static void handleSpawnParticleEffectMessage(SpawnParticleEffectMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("SpawnParticleMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> message.handle((Level)clientWorld.get()));
    }

    public static void handleSetLiftPositionMessage(SetLiftPositionMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ctx.enqueueWork(() -> {
            Player clientPlayer = ManaAndArtifice.instance.proxy.getClientPlayer();
            LazyOptional magicCap = clientPlayer.getCapability(PlayerMagicProvider.MAGIC);
            if (!magicCap.isPresent()) {
                return;
            }
            IPlayerMagic magicProperties = (IPlayerMagic)magicCap.orElse(null);
            if (magicProperties == null) {
                return;
            }
            magicProperties.setLiftPosition(message.getPosition());
        });
    }

    public static void handleSetRitualReagentData(SetRitualCollectedReagentsMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ctx.enqueueWork(() -> {
            Entity e = ManaAndArtifice.instance.proxy.getClientWorld().m_6815_(message.getEntityID());
            if (e != null && e instanceof Ritual) {
                ((Ritual)e).readCollectedReagents(message.getData().m_128437_("data", 10));
            }
        });
    }

    public static void handleCantripCastingTimerMessage(CantripCastingTimerMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ctx.enqueueWork(() -> HUDOverlayRenderer.instance.setCastingCantrip(message.getCantripId(), message.getTicks()));
    }

    public static void handleWanderingWizardInventoryMessage(WanderingWizardInventoryMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processWanderingWizardInventoryMessage(Minecraft.m_91087_(), message));
    }

    public static void handleWellspringSyncMessage(WellspringSyncMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("ProgressionSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ((Level)clientWorld.get()).getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().readFromNBT(message.getData())));
    }

    public static void handleMindVisionMessage(MindVisionMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MindVisionMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            if (message.getEntityID() == -1) {
                ManaAndArtifice.instance.proxy.resetRenderViewEntity();
            } else {
                Entity e = ((Level)clientWorld.get()).m_6815_(message.getEntityID());
                if (e != null) {
                    ManaAndArtifice.instance.proxy.setRenderViewEntity(e);
                }
            }
        });
    }

    public static void handlePosessionMessage(PosessionMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("PosessionMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            Entity e = ((Level)clientWorld.get()).m_6815_(message.getEntityID());
            if (e != null) {
                ManaAndArtifice.instance.proxy.setRenderViewEntity(e);
            }
        });
    }

    public static void handleMAPFXMessage(MAPFXMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MAPFXMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            Entity e = ((Level)clientWorld.get()).m_6815_(message.getEntityID());
            if (e != null && e instanceof LivingEntity) {
                ((LivingEntity)e).getCapability(MAPFXProvider.MAPFX).ifPresent(p -> p.setFlags(message.getFlags()));
            }
        });
    }

    public static void handleCloudstepJumpMessage(CloudstepJumpMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MAPFXMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            Entity e = ((Level)clientWorld.get()).m_6815_(message.getEntityID());
            if (e != null && e instanceof LivingEntity) {
                for (int i = 0; i < 20; ++i) {
                    Vec3 pos = e.m_20182_();
                    e.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.2f).setColor(10, 10, 10), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.25, (double)0.05f, 0.5);
                }
            }
        });
    }

    public static void handleStructureSyncMessage(StructureSyncMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MAPFXMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ((Level)clientWorld.get()).m_7465_().m_44043_(message.getStructureID()).ifPresent(r -> {
            if (r instanceof MultiblockDefinition) {
                ((MultiblockDefinition)r).deserializeCoreBlocks(message.getData());
            }
        }));
    }

    public static void handleWellspringPowerNetworkSyncMessage(WellspringPowerNetworkSyncMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("handleWellspringPowerNetworkSyncMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            if (!((Level)clientWorld.get()).m_46472_().m_135782_().equals((Object)message.getDimension().m_135782_())) {
                return;
            }
            if (!((Level)clientWorld.get()).m_46472_().m_211136_().equals((Object)message.getDimension().m_211136_())) {
                return;
            }
            ctx.enqueueWork(() -> ((Level)clientWorld.get()).getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().deserializeNetworkStrength(ManaAndArtifice.instance.proxy.getClientPlayer(), message.getData())));
        });
    }

    public static void handleExtendedSlotContentsMessage(ExtendedSlotContentsMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("handleExtendedSlotContentsMessage context could not provide a ClientWorld");
            return;
        }
        Player player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            if (player.f_36096_.f_38840_ == message.getScreenID()) {
                player.f_36096_.m_182406_(message.getSlotIndex(), message.getStateID(), message.getStack());
            }
        });
    }

    public static void handleExtendedSlotContainerContentsMessage(ExtendedSlotContainerContentsMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("handleExtendedSlotContentsMessage context could not provide a ClientWorld");
            return;
        }
        Player player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            if (message.getContainerID() == 0) {
                player.f_36095_.m_182410_(message.getStateID(), message.getItems(), message.getCarried());
            } else if (message.getContainerID() == player.f_36096_.f_38840_) {
                player.f_36096_.m_182410_(message.getStateID(), message.getItems(), message.getCarried());
            }
        });
    }

    public static void handlePlayerAuraSyncMessage(AuraSyncMessageToClient message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("PlayerAuraSyncMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            Level world = ManaAndArtifice.instance.proxy.getClientWorld();
            if (world != null) {
                if (message.isBlock() && world.m_46749_(message.getBlockPos())) {
                    BlockEntity be = world.m_7702_(message.getBlockPos());
                    if (be != null && be instanceof ParticleEmitterTile) {
                        ((ParticleEmitterTile)be).setData(message.getTag());
                    }
                } else {
                    Entity entity = world.m_6815_(message.getEntityID());
                    if (entity != null && entity instanceof Player) {
                        ((Player)entity).getCapability(ParticleAuraProvider.AURA).ifPresent(a -> a.load(message.getTag()));
                    }
                }
            }
        });
    }

    public static void handleSetLiftSpeedMessage(SetLiftSpeedMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("PlayerAuraSyncMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            Entity e;
            Level world = ManaAndArtifice.instance.proxy.getClientWorld();
            if (world != null && (e = world.m_6815_(message.getEntityID())) != null) {
                e.getPersistentData().m_128350_("lift_speed", message.getLiftSpeed());
            }
        });
    }

    private static void processMagicSyncMessage(Level worldClient, MagicSyncMessageToClient message) {
        Player player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            int i;
            m.setMagicLevel(player, message.getLevel());
            m.setMagicXP(message.getXP());
            if (message.syncCastingResource()) {
                m.setCastingResourceType(message.getCastingResourceType());
                m.getCastingResource().readNBT(message.getCastingResourceData());
            }
            for (i = 0; i < Math.min(message.getAffinities().length, Affinity.values().length); ++i) {
                m.setAffinityDepth(Affinity.values()[i], message.getAffinities()[i]);
            }
            if (message.syncGrimoire()) {
                m.getGrimoireInventory().m_6211_();
                for (i = 0; i < message.getGrimoireInventory().size(); ++i) {
                    m.getGrimoireInventory().m_6836_(i, (ItemStack)message.getGrimoireInventory().get(i));
                }
            }
            if (message.syncRote()) {
                m.getRoteInventory().m_6211_();
                for (i = 0; i < message.getRoteInventory().size(); ++i) {
                    m.getRoteInventory().m_6836_(i, (ItemStack)message.getRoteInventory().get(i));
                }
            }
            if (message.syncCantrips()) {
                m.getCantripData().readFromNBT(message.getCantripData());
            }
            m.updateClientsideTeleportData(message.getIsTeleporting(), message.getTeleportElapsed(), message.getTeleportTotal());
        });
    }

    private static void processProgressionSyncMessage(Level worldClient, ProgressionSyncMessageToClient message) {
        Player player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.getTier() < message.getTier()) {
                ManaAndArtifice.instance.proxy.showCodexEntriesUnlocked();
            }
            p.setTier(message.getTier(), null);
            p.setFactionStanding(message.getFactionStanding());
            p.setAlliedFaction(message.getFaction(), player);
            p.setTierProgression(message.getCompletedProgressionSteps());
        });
    }

    private static void processEntityStateMessage(Level clientWorld, EntityStateMessage message) {
        Entity entity = clientWorld.m_6815_(message.getEntityID());
        if (entity != null && entity instanceof IAnimPacketSync) {
            ((IAnimPacketSync)entity).handlePacketData(message.getData());
        }
    }

    private static void processRoteSyncMessage(Level worldClient, RoteProgressSyncMessageToClient message) {
        Player player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        player.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> {
            r.resetMastery();
            r.resetRote();
            for (Map.Entry<ResourceLocation, Float> e : message.getRoteProgress().entrySet()) {
                r.setRoteXP(e.getKey(), e.getValue().floatValue());
            }
            for (Map.Entry<ResourceLocation, Float> e : message.getSpellMastery().entrySet()) {
                r.setMastery(e.getKey(), e.getValue().floatValue());
            }
        });
    }

    private static void processWanderingWizardInventoryMessage(Minecraft minecraft, WanderingWizardInventoryMessage message) {
        Player player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        AbstractContainerMenu container = player.f_36096_;
        if (message.getContainerId() == container.f_38840_ && container instanceof ContainerWanderingWizard) {
            ((ContainerWanderingWizard)container).setClientSideOffers(new MerchantOffers(message.getOffers().m_45388_()));
            ((ContainerWanderingWizard)container).setXp(message.getExp());
            ((ContainerWanderingWizard)container).setFinalized(message.getIsFinal());
        }
    }

    private static void processEnderDiscGuiDimensionCycle(Minecraft minecraft, EnderDiscGuiDimensionCycle message) {
        AbstractContainerMenu menu = minecraft.f_91074_.f_36096_;
        if (menu != null && menu instanceof ContainerEnderDisc) {
            ((ContainerEnderDisc)menu).setDimension(message.getDimensionID());
        }
    }

    private static void processRespondLootTableItems(Minecraft minecraft, RespondLootTableItems message) {
        LootTableCache.cacheLoot(message.getLootTableID(), message.getLootDrops());
    }
}

