/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import com.mna.network.messages.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ProgressionSyncMessageToClient
extends BaseMessage {
    private int _tier;
    private IFaction _faction;
    private int _factionStanding;
    private List<ResourceLocation> completedProgressionSteps;

    private ProgressionSyncMessageToClient() {
        this.completedProgressionSteps = new ArrayList<ResourceLocation>();
        this.messageIsValid = false;
    }

    public ProgressionSyncMessageToClient(int tier, IFaction faction, int factionStanding, List<ResourceLocation> progressionCompletion) {
        this.completedProgressionSteps = progressionCompletion;
        this._tier = tier;
        this._faction = faction;
        this._factionStanding = factionStanding;
        this.messageIsValid = true;
    }

    public int getTier() {
        return this._tier;
    }

    public IFaction getFaction() {
        return this._faction;
    }

    public int getFactionStanding() {
        return this._factionStanding;
    }

    public List<ResourceLocation> getCompletedProgressionSteps() {
        return this.completedProgressionSteps;
    }

    public static ProgressionSyncMessageToClient decode(FriendlyByteBuf buf) {
        ProgressionSyncMessageToClient msg = new ProgressionSyncMessageToClient();
        try {
            msg._tier = buf.readInt();
            msg._factionStanding = buf.readInt();
            if (buf.readBoolean()) {
                msg._faction = (IFaction)Registries.Factions.get().getValue(new ResourceLocation(buf.m_130277_()));
            }
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                msg.completedProgressionSteps.add(buf.m_130281_());
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MagicSyncMessageToClient: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(ProgressionSyncMessageToClient msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.getTier());
        buf.writeInt(msg.getFactionStanding());
        buf.writeBoolean(msg.getFaction() != null);
        if (msg.getFaction() != null) {
            buf.m_130070_(Registries.Factions.get().getKey((Object)msg.getFaction()).toString());
        }
        buf.writeInt(msg.getCompletedProgressionSteps().size());
        for (ResourceLocation rLoc : msg.getCompletedProgressionSteps()) {
            buf.m_130085_(rLoc);
        }
    }

    public static ProgressionSyncMessageToClient fromCapability(IPlayerProgression capability) {
        return new ProgressionSyncMessageToClient(capability.getTier(), capability.getAlliedFaction(), capability.getFactionStanding(), capability.getCompletedProgressionSteps());
    }
}

