/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.network.messages.BaseMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class RoteProgressSyncMessageToClient
extends BaseMessage {
    private HashMap<ResourceLocation, Float> roteSpellProgress = new HashMap();
    private HashMap<ResourceLocation, Float> spellMastery = new HashMap();

    private RoteProgressSyncMessageToClient() {
        this.messageIsValid = false;
    }

    public RoteProgressSyncMessageToClient(HashMap<ISpellComponent, Float> roteSpellProgress, HashMap<ISpellComponent, Float> masteryProgress) {
        this();
        for (Map.Entry<ISpellComponent, Float> e : roteSpellProgress.entrySet()) {
            if (e == null) continue;
            this.roteSpellProgress.put(e.getKey().getRegistryName(), e.getValue());
        }
        for (Map.Entry<ISpellComponent, Float> e : masteryProgress.entrySet()) {
            if (e == null) continue;
            this.spellMastery.put(e.getKey().getRegistryName(), e.getValue());
        }
        this.messageIsValid = true;
    }

    public HashMap<ResourceLocation, Float> getRoteProgress() {
        return this.roteSpellProgress;
    }

    public HashMap<ResourceLocation, Float> getSpellMastery() {
        return this.spellMastery;
    }

    public static RoteProgressSyncMessageToClient decode(FriendlyByteBuf buf) {
        RoteProgressSyncMessageToClient msg = new RoteProgressSyncMessageToClient();
        try {
            int roteCount = buf.readInt();
            for (int i = 0; i < roteCount; ++i) {
                ResourceLocation rLoc = buf.m_130281_();
                float xp = buf.readFloat();
                msg.getRoteProgress().put(rLoc, Float.valueOf(xp));
            }
            int masteryCount = buf.readInt();
            for (int i = 0; i < masteryCount; ++i) {
                ResourceLocation rLoc = buf.m_130281_();
                float mastery = buf.readFloat();
                msg.getSpellMastery().put(rLoc, Float.valueOf(mastery));
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading RoteSyncMessageToClient: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(RoteProgressSyncMessageToClient msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.getRoteProgress().size());
        for (Map.Entry<ResourceLocation, Float> e : msg.getRoteProgress().entrySet()) {
            buf.m_130085_(e.getKey());
            buf.writeFloat(e.getValue().floatValue());
        }
        buf.writeInt(msg.getSpellMastery().size());
        for (Map.Entry<ResourceLocation, Float> e : msg.getSpellMastery().entrySet()) {
            buf.m_130085_(e.getKey());
            buf.writeFloat(e.getValue().floatValue());
        }
    }

    public static RoteProgressSyncMessageToClient fromCapability(IPlayerRoteSpells capability) {
        return new RoteProgressSyncMessageToClient(capability.getRoteData(), capability.getMasteryData());
    }
}

