/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.network.messages.BaseMessage;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class WellspringPowerNetworkSyncMessage
extends BaseMessage {
    CompoundTag wellspringData;
    private ResourceKey<Level> forDimension;

    public WellspringPowerNetworkSyncMessage(CompoundTag nbt, ResourceKey<Level> dimension) {
        this.wellspringData = nbt;
        this.messageIsValid = true;
        this.forDimension = dimension;
    }

    private WellspringPowerNetworkSyncMessage() {
        this.messageIsValid = false;
    }

    public CompoundTag getData() {
        return this.wellspringData;
    }

    public ResourceKey<Level> getDimension() {
        return this.forDimension;
    }

    public static WellspringPowerNetworkSyncMessage decode(FriendlyByteBuf buf) {
        WellspringPowerNetworkSyncMessage msg = new WellspringPowerNetworkSyncMessage();
        try {
            msg.wellspringData = buf.m_130260_();
            ResourceLocation location = buf.m_130281_();
            msg.forDimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)location);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading WellspringPowerNetworkSyncMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(WellspringPowerNetworkSyncMessage msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.getData());
        buf.m_130085_(msg.forDimension.m_135782_());
    }

    public static WellspringPowerNetworkSyncMessage from(ServerLevel world, ServerPlayer player, boolean fullSync) {
        CompoundTag nbt = new CompoundTag();
        world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().serializeNetworkStrength((Player)player, nbt, fullSync));
        return new WellspringPowerNetworkSyncMessage(nbt, (ResourceKey<Level>)world.m_46472_());
    }
}

