/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.network.messages.BaseMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;

public class PatterningPrismPasteMessage
extends BaseMessage {
    private CompoundTag logic;
    private InteractionHand hand;
    private boolean isParticleEmitter;

    public PatterningPrismPasteMessage(CompoundTag logic, InteractionHand hand, boolean isParticleEmitter) {
        this.logic = logic;
        this.hand = hand;
        this.isParticleEmitter = isParticleEmitter;
        this.messageIsValid = true;
    }

    public PatterningPrismPasteMessage() {
        this.messageIsValid = false;
    }

    public CompoundTag getLogic() {
        return this.logic;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public boolean isParticleEmitter() {
        return this.isParticleEmitter;
    }

    public static PatterningPrismPasteMessage decode(FriendlyByteBuf buf) {
        PatterningPrismPasteMessage msg = new PatterningPrismPasteMessage();
        try {
            msg.logic = buf.m_130261_();
            msg.hand = InteractionHand.values()[buf.readInt()];
            msg.isParticleEmitter = buf.readBoolean();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading PatterningPrismPasteMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(PatterningPrismPasteMessage msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.getLogic());
        buf.writeInt(msg.hand.ordinal());
        buf.writeBoolean(msg.isParticleEmitter());
    }
}

