/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.network.messages.BaseMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class PlayerBounceMessage
extends BaseMessage {
    private Vec3 velocity;

    public PlayerBounceMessage() {
        this.messageIsValid = false;
    }

    public PlayerBounceMessage(Vec3 velocity) {
        this.velocity = velocity;
        this.messageIsValid = true;
    }

    public Vec3 getVelocity() {
        return this.velocity;
    }

    public static final PlayerBounceMessage decode(FriendlyByteBuf buf) {
        PlayerBounceMessage msg = new PlayerBounceMessage();
        try {
            msg.velocity = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading PlayerBouncePacket: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(PlayerBounceMessage message, FriendlyByteBuf buf) {
        buf.writeDouble(message.velocity.f_82479_);
        buf.writeDouble(message.velocity.f_82480_);
        buf.writeDouble(message.velocity.f_82481_);
    }
}

