/*
 * Decompiled with CFR 0.152.
 */
package com.mna.recipes.arcanefurnace;

import com.google.gson.JsonObject;
import com.mna.recipes.AMRecipeBase;
import com.mna.recipes.RecipeInit;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ArcaneFurnaceRecipe
extends AMRecipeBase {
    private ResourceLocation inputItem;
    private ResourceLocation outputItem;
    private int burnTime;
    private int outputQuantity = 1;
    private Item __outputItem = null;

    public ArcaneFurnaceRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public void parseExtraJson(JsonObject object) {
        if (object.has("input") && object.has("output") && object.has("burnTime")) {
            this.inputItem = new ResourceLocation(object.get("input").getAsString());
            this.outputItem = new ResourceLocation(object.get("output").getAsString());
            this.burnTime = object.get("burnTime").getAsInt();
        }
        if (object.has("outputQuantity")) {
            this.outputQuantity = object.get("outputQuantity").getAsInt();
        }
    }

    public void setInputItem(ResourceLocation rLoc) {
        this.inputItem = rLoc;
    }

    public ResourceLocation getInputItem() {
        return this.inputItem;
    }

    public void setOutputItem(ResourceLocation rLoc) {
        this.outputItem = rLoc;
    }

    public ResourceLocation getOutputItem() {
        return this.outputItem;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getOutputQuantity() {
        return this.outputQuantity;
    }

    public void setOutputQuantity(int quantity) {
        this.outputQuantity = quantity;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        if (inv.m_6643_() != 1) {
            return false;
        }
        ItemStack stack = inv.m_8020_(0);
        return ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).equals((Object)this.inputItem);
    }

    @Override
    public ItemStack getResultItem() {
        IForgeRegistry itemRegistry;
        if (this.__outputItem == null && (itemRegistry = ForgeRegistries.ITEMS) != null) {
            this.__outputItem = (Item)itemRegistry.getValue(this.outputItem);
        }
        if (this.__outputItem != null) {
            return new ItemStack((ItemLike)this.__outputItem, this.outputQuantity);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        return this.m_8043_(access);
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeInit.ARCANE_FURNACE_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeInit.ARCANE_FURNACE_TYPE.get();
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        return this.getResultItem();
    }

    @Override
    public ResourceLocation getRegistryId() {
        return this.m_6423_();
    }
}

