/*
 * Decompiled with CFR 0.152.
 */
package com.mna.recipes.crush;

import com.google.gson.JsonObject;
import com.mna.api.recipes.IRuneforgeRecipe;
import com.mna.api.tools.MATags;
import com.mna.recipes.AMRecipeBase;
import com.mna.recipes.RecipeInit;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CrushingRecipe
extends AMRecipeBase
implements IRuneforgeRecipe {
    private ResourceLocation inputItem = new ResourceLocation("");
    private ResourceLocation outputItem = new ResourceLocation("");
    private Item __outputItem = null;
    private int outputQuantity = 1;

    public CrushingRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public void parseExtraJson(JsonObject recipeJSON) {
        this.inputItem = new ResourceLocation(recipeJSON.get("input").getAsString());
        this.outputItem = new ResourceLocation(recipeJSON.get("output").getAsString());
        if (recipeJSON.has("output_quantity")) {
            this.outputQuantity = recipeJSON.get("output_quantity").getAsInt();
        }
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack inputStack;
        return inv.m_6643_() == 1 && MATags.isItemEqual(inputStack = inv.m_8020_(0), this.inputItem);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        return this.getResultItem();
    }

    @Override
    public ItemStack getResultItem() {
        IForgeRegistry itemRegistry;
        if (this.__outputItem == null && (itemRegistry = ForgeRegistries.ITEMS) != null) {
            this.__outputItem = (Item)itemRegistry.getValue(this.outputItem);
        }
        if (this.__outputItem != null) {
            return new ItemStack((ItemLike)this.__outputItem, this.outputQuantity);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeInit.CRUSHING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeInit.CRUSHING_TYPE.get();
    }

    public int getOutputQuantity() {
        return this.outputQuantity;
    }

    public ResourceLocation getInputResource() {
        return this.inputItem;
    }

    public void setInputResource(ResourceLocation pattern) {
        this.inputItem = pattern;
    }

    public ResourceLocation getOutputResource() {
        return this.outputItem;
    }

    public void setOutputResource(ResourceLocation output) {
        this.outputItem = output;
    }

    public void setOutputQuantity(int outputQuantity) {
        this.outputQuantity = outputQuantity;
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        return this.getResultItem();
    }

    @Override
    public ResourceLocation getRegistryId() {
        return this.m_6423_();
    }
}

