/*
 * Decompiled with CFR 0.152.
 */
package com.mna.recipes.multiblock;

import com.google.gson.JsonObject;
import com.mna.ManaAndArtifice;
import com.mna.recipes.AMRecipeBaseSerializer;
import com.mna.recipes.multiblock.MultiblockDefinition;
import java.util.HashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class MultiblockRecipeSerializer
extends AMRecipeBaseSerializer<MultiblockDefinition> {
    @Override
    protected MultiblockDefinition readExtra(ResourceLocation recipeId, JsonObject json) {
        MultiblockDefinition recipe = new MultiblockDefinition(recipeId);
        recipe.parseJSON(json);
        return recipe;
    }

    @Override
    protected MultiblockDefinition readExtra(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        try {
            MultiblockDefinition recipe = new MultiblockDefinition(recipeId);
            recipe.setStructurePath(buffer.m_130281_());
            int count = buffer.readInt();
            HashMap<ResourceLocation, Integer> matchersByBlock = new HashMap<ResourceLocation, Integer>();
            for (int i = 0; i < count; ++i) {
                ResourceLocation rLoc = buffer.m_130281_();
                int index = buffer.readInt();
                matchersByBlock.put(rLoc, index);
            }
            recipe.setSpecialBlockMatchersByBlock(matchersByBlock);
            count = buffer.readInt();
            HashMap<Long, Integer> matchersByOffset = new HashMap<Long, Integer>();
            for (int i = 0; i < count; ++i) {
                Long offset = buffer.readLong();
                int index = buffer.readInt();
                matchersByOffset.put(offset, index);
            }
            recipe.setSpecialBlockMatchersByOffset(matchersByOffset);
            recipe.deserializeVariations(buffer.m_130260_());
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading multiblock definition from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void writeExtra(FriendlyByteBuf buffer, MultiblockDefinition recipe) {
        try {
            buffer.m_130085_(recipe.getStructurePath());
            HashMap<ResourceLocation, Integer> matchersByBlock = recipe.getSpecialBlockMatchersByBlock();
            buffer.writeInt(matchersByBlock.size());
            matchersByBlock.entrySet().forEach(e -> {
                buffer.m_130085_((ResourceLocation)e.getKey());
                buffer.writeInt(((Integer)e.getValue()).intValue());
            });
            HashMap<Long, Integer> matchersByOffset = recipe.getSpecialBlockMatchersByOffset();
            buffer.writeInt(matchersByOffset.size());
            matchersByOffset.entrySet().forEach(e -> {
                buffer.writeLong(((Long)e.getKey()).longValue());
                buffer.writeInt(((Integer)e.getValue()).intValue());
            });
            buffer.m_130079_(recipe.serializeVariations());
        }
        catch (Exception e2) {
            ManaAndArtifice.LOGGER.error("Error writing multiblock definition to packet.", (Throwable)e2);
            throw e2;
        }
    }
}

