/*
 * Decompiled with CFR 0.152.
 */
package com.mna.recipes.rituals;

import com.google.gson.JsonObject;
import com.mna.ManaAndArtifice;
import com.mna.recipes.AMRecipeBaseSerializer;
import com.mna.recipes.rituals.RitualRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class RitualRecipeSerializer
extends AMRecipeBaseSerializer<RitualRecipe> {
    @Override
    public RitualRecipe readExtra(ResourceLocation recipeId, JsonObject json) {
        RitualRecipe recipe = new RitualRecipe(recipeId);
        recipe.parseJSON(json);
        return recipe;
    }

    @Override
    public RitualRecipe readExtra(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        try {
            RitualRecipe recipe = new RitualRecipe(recipeId);
            recipe.setConnectBeam(buffer.readBoolean());
            recipe.setDisplayIndexes(buffer.readBoolean());
            recipe.setInnerColor(buffer.readLong());
            recipe.setOuterColor(buffer.readLong());
            recipe.setBeamColor(buffer.readLong());
            int[][] pattern = new int[buffer.m_130242_()][];
            for (int i = 0; i < pattern.length; ++i) {
                pattern[i] = buffer.m_130100_();
            }
            recipe.setPattern(pattern);
            int[][] displayPattern = new int[buffer.m_130242_()][];
            for (int i = 0; i < displayPattern.length; ++i) {
                displayPattern[i] = buffer.m_130100_();
            }
            recipe.setDisplayPattern(displayPattern);
            recipe.reagentsFromNBT(buffer.m_130260_());
            int pattern_count = buffer.readInt();
            String[] manaweave_patterns = new String[pattern_count];
            for (int i = 0; i < pattern_count; ++i) {
                manaweave_patterns[i] = buffer.m_130277_();
            }
            recipe.setManaweavePatterns(manaweave_patterns);
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading ritual recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void writeExtra(FriendlyByteBuf buffer, RitualRecipe recipe) {
        try {
            int i;
            buffer.writeBoolean(recipe.getConnectBeam());
            buffer.writeBoolean(recipe.getDisplayIndexes());
            buffer.writeLong(recipe.getInnerColor());
            buffer.writeLong(recipe.getOuterColor());
            buffer.writeLong(recipe.getBeamColor());
            buffer.m_130130_(recipe.getPattern().length);
            for (i = 0; i < recipe.getPattern().length; ++i) {
                buffer.m_130089_(recipe.getPattern()[i]);
            }
            buffer.m_130130_(recipe.getDisplayPattern().length);
            for (i = 0; i < recipe.getDisplayPattern().length; ++i) {
                buffer.m_130089_(recipe.getDisplayPattern()[i]);
            }
            buffer.m_130079_(recipe.reagentsToNBT());
            buffer.writeInt(recipe.getManaweavePatterns().length);
            for (i = 0; i < recipe.getManaweavePatterns().length; ++i) {
                buffer.m_130070_(recipe.getManaweavePatterns()[i]);
            }
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error writing ritual recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

