/*
 * Decompiled with CFR 0.152.
 */
package com.mna.recipes.runeforging;

import com.google.gson.JsonObject;
import com.mna.api.recipes.IRunescribeRecipe;
import com.mna.items.ItemInit;
import com.mna.items.runes.ItemRunePattern;
import com.mna.recipes.AMRecipeBase;
import com.mna.recipes.RecipeInit;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RunescribingRecipe
extends AMRecipeBase
implements IRunescribeRecipe {
    private long hMutex;
    private long vMutex;
    private ResourceLocation patternItem = new ResourceLocation("");
    private Item __outputItem = null;

    public RunescribingRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public void parseExtraJson(JsonObject recipeJSON) {
        this.hMutex = recipeJSON.get("mutex_h").getAsLong();
        this.vMutex = recipeJSON.get("mutex_v").getAsLong();
        this.patternItem = new ResourceLocation(recipeJSON.get("output").getAsString());
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack checkStack = inv.m_8020_(0);
        if (inv.m_6643_() == 1 && checkStack.m_41720_() == ItemInit.RUNE_PATTERN.get()) {
            return ((ItemRunePattern)ItemInit.RUNE_PATTERN.get()).getHMutex(checkStack) == this.hMutex && ((ItemRunePattern)ItemInit.RUNE_PATTERN.get()).getVMutex(checkStack) == this.vMutex;
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        return this.getResultItem();
    }

    @Override
    public ItemStack getResultItem() {
        IForgeRegistry itemRegistry;
        if (this.__outputItem == null && (itemRegistry = ForgeRegistries.ITEMS) != null) {
            this.__outputItem = (Item)itemRegistry.getValue(this.patternItem);
        }
        if (this.__outputItem != null) {
            return new ItemStack((ItemLike)this.__outputItem);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeInit.RUNESCRIBING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeInit.RUNESCRIBING_TYPE.get();
    }

    @Override
    public long getHMutex() {
        return this.hMutex;
    }

    public void setHMutex(long mutex) {
        this.hMutex = mutex;
    }

    @Override
    public long getVMutex() {
        return this.vMutex;
    }

    public void setVMutex(long mutex) {
        this.vMutex = mutex;
    }

    public ResourceLocation getOutputResource() {
        return this.patternItem;
    }

    public void setOutputResource(String output) {
        this.patternItem = new ResourceLocation(output);
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        return this.getResultItem();
    }

    @Override
    public ResourceLocation getRegistryId() {
        return this.m_6423_();
    }
}

