/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals;

import com.mna.api.rituals.IRitualReagent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class RitualReagent
implements IRitualReagent {
    private ResourceLocation rLoc;
    private boolean isOptional;
    private boolean shouldConsume;
    private boolean manualReturn;
    private boolean isDynamic;
    private boolean isDynamicSource;

    public RitualReagent(ResourceLocation rLoc) {
        this.rLoc = rLoc;
        this.isOptional = false;
        this.shouldConsume = true;
        this.manualReturn = false;
    }

    public RitualReagent(String namespaceID, String path) {
        this(new ResourceLocation(namespaceID, path));
    }

    public RitualReagent(String resourceName) {
        this(new ResourceLocation(resourceName));
    }

    public RitualReagent asOptional() {
        if (!this.isDynamicSource) {
            this.isOptional = true;
        }
        return this;
    }

    public RitualReagent noConsume() {
        this.shouldConsume = false;
        return this;
    }

    public RitualReagent manualReturn() {
        this.manualReturn = true;
        return this;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.rLoc;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean shouldConsumeReagent() {
        return this.shouldConsume;
    }

    @Override
    public boolean isManualReturn() {
        return this.manualReturn;
    }

    @Override
    public boolean isEmpty() {
        return this.rLoc == null || this.rLoc.toString().equals(ForgeRegistries.ITEMS.getKey((Object)Items.f_41852_).toString());
    }

    @Override
    public boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public boolean isDynamicSource() {
        return this.isDynamicSource;
    }

    public RitualReagent asDynamic() {
        this.isDynamic = true;
        return this;
    }

    public RitualReagent asDynamicSource() {
        this.isOptional = false;
        this.isDynamicSource = true;
        return this;
    }

    @Override
    public void setResourceLocation(ResourceLocation rLoc) {
        if (this.isDynamic()) {
            this.rLoc = rLoc;
            this.isDynamic = false;
            this.isOptional = false;
        }
    }

    public void writeToNBT(CompoundTag nbt) {
        if (this.rLoc == null) {
            return;
        }
        nbt.m_128359_("ritual_reagent_resource", this.rLoc.toString());
        nbt.m_128379_("ritual_reagent_optional", this.isOptional);
        nbt.m_128379_("ritual_reagent_consume", this.shouldConsume);
        nbt.m_128379_("ritual_reagent_manual_return", this.manualReturn);
        nbt.m_128379_("ritual_reagent_dynamic", this.isDynamic);
        nbt.m_128379_("ritual_reagent_dynamic_source", this.isDynamicSource);
    }

    public static RitualReagent fromNBT(CompoundTag nbt) {
        RitualReagent rr;
        String key = "";
        if (nbt.m_128441_("ritual_reagent_resource")) {
            key = nbt.m_128461_("ritual_reagent_resource");
        }
        RitualReagent ritualReagent = rr = key.isEmpty() ? null : new RitualReagent(new ResourceLocation(key));
        if (nbt.m_128441_("ritual_reagent_optional")) {
            rr.isOptional = nbt.m_128471_("ritual_reagent_optional");
        }
        if (nbt.m_128441_("ritual_reagent_consume")) {
            rr.shouldConsume = nbt.m_128471_("ritual_reagent_consume");
        }
        if (nbt.m_128441_("ritual_reagent_manual_return")) {
            rr.manualReturn = nbt.m_128471_("ritual_reagent_manual_return");
        }
        if (nbt.m_128441_("ritual_reagent_dynamic")) {
            rr.isDynamic = nbt.m_128471_("ritual_reagent_dynamic");
        }
        if (nbt.m_128441_("ritual_reagent_dynamic_source")) {
            rr.isDynamicSource = nbt.m_128471_("ritual_reagent_dynamic_source");
        }
        return rr;
    }
}

