/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.entities.EntityInit;
import com.mna.entities.rituals.Portal;
import com.mna.items.ItemInit;
import com.mna.items.ritual.ItemPlayerCharm;
import com.mna.items.ritual.ItemWorldCharm;
import com.mna.tools.TeleportHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RitualEffectVisit
extends RitualEffect {
    public RitualEffectVisit(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        Player teleportTarget = null;
        int boneCount = 0;
        ResourceKey<Level> worldKey = null;
        ItemStack playerCharm = ItemStack.f_41583_;
        for (ItemStack stack : context.getCollectedReagents()) {
            if (stack.m_41720_() == ItemInit.PLAYER_CHARM.get()) {
                playerCharm = stack;
            }
            if (stack.m_41720_() == ItemInit.WORLD_CHARM.get()) {
                worldKey = ((ItemWorldCharm)ItemInit.WORLD_CHARM.get()).GetWorldTarget(stack);
            }
            if (stack.m_41720_() != Items.f_42500_) continue;
            ++boneCount;
        }
        if (worldKey == null) {
            worldKey = context.getLevel().m_46472_();
        }
        if (!playerCharm.m_41619_()) {
            ServerLevel targetWorld = TeleportHelper.resolveRegistryKey((ServerLevel)context.getLevel(), worldKey.m_135782_());
            Player player = ((ItemPlayerCharm)ItemInit.PLAYER_CHARM.get()).GetPlayerTarget(playerCharm, (Level)targetWorld);
            if (player != null) {
                teleportTarget = player;
            }
        } else {
            teleportTarget = context.getCaster();
        }
        if (teleportTarget == null) {
            if (context.getCaster() != null) {
                context.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:rituals/visit.not_found"));
            }
            return false;
        }
        BlockPos teleportTargetPos = teleportTarget.m_20183_().m_7494_();
        ResourceKey teleportTargetDimension = teleportTarget.m_9236_().m_46472_();
        if (boneCount >= 2) {
            CompoundTag casterPD = teleportTarget.getPersistentData();
            if (!casterPD.m_128441_("mna_last_death_data")) {
                context.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:rituals/visit.no_death_data"));
                return false;
            }
            CompoundTag deathData = casterPD.m_128469_("mna_last_death_data");
            teleportTargetPos = BlockPos.m_122022_((long)deathData.m_128454_("position"));
            teleportTargetDimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(deathData.m_128461_("dimension")));
        }
        Portal portal = new Portal((EntityType)EntityInit.PORTAL_ENTITY.get(), context.getLevel());
        portal.m_146884_(Vec3.m_82539_((Vec3i)context.getCenter()));
        portal.setTeleportBlockPos(teleportTargetPos, (ResourceKey<Level>)teleportTargetDimension);
        context.getLevel().m_7967_((Entity)portal);
        return false;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 20;
    }
}

