/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.items.ItemInit;
import com.mna.items.ritual.ItemThaumaturgicLink;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public class WorldUtils {
    @Nullable
    public static BlockPos locateBiome(ServerLevel world, BlockPos center, ItemStack thaumLink) {
        ResourceLocation biomeLoc = ((ItemThaumaturgicLink)((Object)ItemInit.THAUMATURGIC_LINK.get())).getLocationKey(thaumLink);
        if (biomeLoc == null) {
            return null;
        }
        return WorldUtils.locateBiome(world, center, biomeLoc);
    }

    @Nullable
    public static BlockPos locateBiome(ServerLevel world, BlockPos center, ResourceLocation biomeLoc) {
        Registry registry = world.m_9598_().m_175515_(Registries.f_256952_);
        Biome biome = (Biome)registry.m_7745_(biomeLoc);
        if (biome == null) {
            return null;
        }
        Pair result = world.m_215069_(b -> b.m_203633_() && ((Biome)b.get()).equals(biome), center, 6400, 8, 64);
        if (result == null) {
            return null;
        }
        return (BlockPos)result.getFirst();
    }

    @Nullable
    public static BlockPos locateStructure(ServerLevel world, BlockPos center, ItemStack thaumLink) {
        ResourceLocation structureLoc = ((ItemThaumaturgicLink)((Object)ItemInit.THAUMATURGIC_LINK.get())).getLocationKey(thaumLink);
        if (structureLoc == null) {
            return null;
        }
        return WorldUtils.locateStructure(world, center, structureLoc, false);
    }

    @Nullable
    public static BlockPos locateStructure(ServerLevel world, BlockPos center, ResourceLocation structureLoc, boolean ignoreExisting) {
        Registry registry = world.m_9598_().m_175515_(Registries.f_256944_);
        Structure pStructure = (Structure)registry.m_7745_(structureLoc);
        int pStructureId = registry.m_7447_((Object)pStructure);
        try {
            HolderSet holderset = (HolderSet)registry.m_203300_(pStructureId).map(p_214491_ -> HolderSet.m_205809_((Holder[])new Holder[]{p_214491_})).get();
            Pair pair = world.m_7726_().m_8481_().m_223037_(world, holderset, center, 100, ignoreExisting);
            if (pair != null) {
                return (BlockPos)pair.getFirst();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

