/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells;

import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.resource.CastingResourceIDs;
import com.mna.api.spells.adjusters.SpellAdjustingContext;
import com.mna.api.spells.adjusters.SpellCastStage;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.collections.Components;
import com.mna.api.spells.collections.Shapes;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.effects.EffectInit;
import com.mna.enchantments.base.ModifierEnchantment;
import com.mna.factions.Factions;
import com.mna.interop.CuriosInterop;
import com.mna.items.ItemInit;
import com.mna.items.artifice.curio.ItemEldrinBracelet;
import com.mna.items.base.IHellfireItem;
import com.mna.items.sorcery.ItemSpell;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;

public final class SpellAdjusters {
    private static final float AFFINITY_MANA_COST_FACTOR = 0.5f;

    public static final void modifyBasedOnAffinity(ISpellDefinition recipe, @Nullable LivingEntity caster) {
        if (caster == null) {
            return;
        }
        LazyOptional magicContainer = caster.getCapability(PlayerMagicProvider.MAGIC);
        if (!magicContainer.isPresent()) {
            return;
        }
        IPlayerMagic magic = (IPlayerMagic)magicContainer.orElse(null);
        if (magic == null) {
            return;
        }
        float base_mana_cost = recipe.getManaCost();
        float modification_reduce = 0.0f;
        float modification_increase = 0.0f;
        HashMap<Affinity, Float> affList = recipe.getAffinity();
        for (Affinity affinity : affList.keySet()) {
            Affinity mainAdjuster = affinity.getShiftAffinity();
            Affinity oppositeAdjuster = affinity.getOpposite().getShiftAffinity();
            modification_reduce += magic.getAffinityDepth(mainAdjuster) * 0.5f / 100.0f * affList.get((Object)affinity).floatValue();
            modification_increase += magic.getAffinityDepth(oppositeAdjuster) * 0.5f / 100.0f * affList.get((Object)affinity).floatValue();
        }
        recipe.setManaCost(base_mana_cost - base_mana_cost * modification_reduce + base_mana_cost * modification_increase);
    }

    public static final void modifyChanneled(ISpellDefinition recipe, @Nullable LivingEntity caster) {
        if (recipe.isChanneled()) {
            float manaCostPerTick = recipe.getManaCost() / 20.0f;
            recipe.setManaCost(manaCostPerTick * 0.5f);
        }
    }

    public static final void modifySigils(ISpellDefinition recipe, @Nullable LivingEntity caster) {
        if (recipe.getShape() != null && recipe.getShape().getPart() != null && recipe.getShape().getPart() == Shapes.RUNE) {
            recipe.setManaCost(recipe.getManaCost() / 2.0f);
        }
    }

    public static final boolean checkHellfireStaff(SpellAdjustingContext context) {
        return context.stack.m_41720_() instanceof IHellfireItem;
    }

    public static final void modifyHellfireStaff(ISpellDefinition recipe, @Nullable LivingEntity caster) {
        if (caster == null) {
            return;
        }
        if (recipe.getAffinity().containsKey((Object)Affinity.FIRE)) {
            recipe.iterateComponents(c -> {
                if (((SpellEffect)c.getPart()).getAffinity() == Affinity.FIRE) {
                    for (Attribute attr : c.getContainedAttributes()) {
                        if (!((SpellEffect)c.getPart()).isHellfireBoosted(attr)) continue;
                        c.setValue(attr, c.getValue(attr) * 2.0f);
                    }
                }
            });
            recipe.setOverrideAffinity(Affinity.HELLFIRE);
            recipe.setManaCost(recipe.getManaCost() * 3.0f);
        }
    }

    public static final boolean checkArcaneCrown(SpellAdjustingContext context) {
        if (context.caster == null || !(context.caster instanceof Player)) {
            return false;
        }
        return ((ItemStack)((Player)context.caster).m_150109_().f_35975_.get(EquipmentSlot.HEAD.m_20749_())).m_41720_() == ItemInit.ARCANE_CROWN.get() || CuriosInterop.IsItemInCurioSlot((Item)ItemInit.ARCANE_CROWN.get(), context.caster, SlotTypePreset.HEAD);
    }

    public static final void modifyArcaneCrown(ISpellDefinition recipe, @Nullable LivingEntity caster) {
        if (caster == null) {
            return;
        }
        recipe.setManaCost(recipe.getManaCost() * 0.85f);
    }

    public static final void modifyBreakRings(ISpellDefinition recipe, @Nullable LivingEntity caster) {
        if (caster == null) {
            return;
        }
        recipe.getComponents().stream().filter(c -> c.getPart() == Components.BREAK || c.getPart() == Components.EXCHANGE).findFirst().ifPresent(c -> {
            int magnitudeIncrease = 0;
            if (CuriosApi.getCuriosHelper().findFirstCurio(caster, (Item)ItemInit.BREAK_RING_GREATER.get()).isPresent()) {
                magnitudeIncrease = 2;
            } else if (CuriosApi.getCuriosHelper().findFirstCurio(caster, (Item)ItemInit.BREAK_RING_LESSER.get()).isPresent()) {
                magnitudeIncrease = 1;
            }
            for (int i = 0; i < magnitudeIncrease; ++i) {
                c.stepUpIgnoreMax(Attribute.MAGNITUDE);
            }
        });
    }

    public static final boolean checkRingOfTheSkies(SpellAdjustingContext context) {
        if (context.caster == null) {
            return false;
        }
        if (context.stage == SpellCastStage.CASTING || context.stage == SpellCastStage.SPELL_TOOLTIP) {
            return CuriosInterop.IsItemInCurioSlot((Item)ItemInit.AIR_CAST_RING.get(), context.caster, SlotTypePreset.RING);
        }
        return false;
    }

    public static final void modifyAirCastRing(ISpellDefinition recipe, @Nullable LivingEntity caster) {
        if (caster == null) {
            return;
        }
        recipe.getComponents().stream().filter(c -> c.getPart() == Components.FLING).findFirst().ifPresent(c -> c.stepUpIgnoreMax(Attribute.SPEED));
    }

    public static final void modifyBattlemageAmulet(ISpellDefinition recipe, @Nullable LivingEntity caster) {
        if (caster == null) {
            return;
        }
        if (!CuriosApi.getCuriosHelper().findFirstCurio(caster, (Item)ItemInit.BATTLEMAGE_AMULET.get()).isPresent()) {
            return;
        }
        ItemStack mainHand = caster.m_21205_();
        ItemStack offHand = caster.m_21206_();
        if (mainHand.m_41720_() instanceof SwordItem && offHand.m_41720_() instanceof ItemSpell || offHand.m_41720_() instanceof SwordItem && mainHand.m_41720_() instanceof ItemSpell) {
            recipe.getComponents().forEach(c -> c.setMultiplier(Attribute.DAMAGE, c.getMultiplier(Attribute.DAMAGE) + 0.3f));
        }
    }

    public static final boolean checkEldrinBracelet(SpellAdjustingContext context) {
        if (context.caster == null || !(context.caster instanceof Player)) {
            return false;
        }
        if (context.stage == SpellCastStage.SPELL_TOOLTIP || context.stage == SpellCastStage.CALCULATING_MANA_COST) {
            return ((ItemEldrinBracelet)ItemInit.ELDRIN_BRACELET.get()).isEquippedAndHasMana(context.caster, 1.0f, false);
        }
        if (context.stage == SpellCastStage.CASTING && ((ItemEldrinBracelet)ItemInit.ELDRIN_BRACELET.get()).isEquippedAndHasMana(context.caster, 1.0f, true)) {
            ((ItemEldrinBracelet)ItemInit.ELDRIN_BRACELET.get()).usedByPlayer((Player)context.caster);
            return true;
        }
        return false;
    }

    public static final void modifyEldrinBracelet(ISpellDefinition recipe, @Nullable LivingEntity caster) {
        if (caster == null) {
            return;
        }
        caster.m_9236_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
            BlockPos casterPos = new BlockPos(caster.m_20183_().m_123341_(), 0, caster.m_20183_().m_123343_());
            m.getWellspringRegistry().getNearbyNodes(casterPos, 0, 10).forEach((pos, node) -> {
                double dist = casterPos.m_123331_((Vec3i)pos);
                float pctReduction = (float)(0.5 * ((100.0 - dist) / 100.0));
                recipe.setManaCost(recipe.getManaCost() - recipe.getManaCost() * pctReduction);
            });
        });
    }

    public static final boolean checkCircleOfPower(SpellAdjustingContext context) {
        if (context.caster == null) {
            return false;
        }
        if (context.stage == SpellCastStage.CASTING || context.stage == SpellCastStage.SPELL_TOOLTIP) {
            return context.caster.m_21023_((MobEffect)EffectInit.CIRCLE_OF_POWER.get());
        }
        return false;
    }

    public static final void modifyCircleOfPower(ISpellDefinition recipe, @Nullable LivingEntity caster) {
        if (caster == null) {
            return;
        }
        float originalMana = recipe.getManaCost();
        int amp = caster.m_21124_((MobEffect)EffectInit.CIRCLE_OF_POWER.get()).m_19564_() + 1;
        recipe.iterateComponents(c -> c.getContainedAttributes().forEach(attr -> {
            if (attr == Attribute.SPEED) {
                c.setValue((Attribute)((Object)((Object)attr)), c.getValue((Attribute)((Object)((Object)attr))) + (float)amp);
            }
            if (attr == Attribute.DAMAGE) {
                c.setMultiplier((Attribute)((Object)((Object)attr)), 1.0f + 0.25f * (float)amp);
            }
            if (attr == Attribute.DURATION) {
                c.setMultiplier((Attribute)((Object)((Object)attr)), 2 * amp);
            }
        }));
        recipe.setManaCost(originalMana);
    }

    public static final void modifyAmplifyMagic(ISpellDefinition recipe, @Nullable LivingEntity caster) {
        int amplifier;
        if (caster == null) {
            return;
        }
        if (caster.m_21023_((MobEffect)EffectInit.AMPLIFY_MAGIC.get())) {
            amplifier = caster.m_21124_((MobEffect)EffectInit.AMPLIFY_MAGIC.get()).m_19564_();
            recipe.setManaCost(recipe.getManaCost() * (1.0f - 0.05f * (float)amplifier));
        }
        if (caster.m_21023_((MobEffect)EffectInit.DAMPEN_MAGIC.get())) {
            amplifier = caster.m_21124_((MobEffect)EffectInit.DAMPEN_MAGIC.get()).m_19564_();
            recipe.setManaCost(recipe.getManaCost() * (1.0f + 0.05f * (float)amplifier));
        }
    }

    public static final void modifyEfficiencyEnchant(SpellAdjustingContext context) {
        if (context.caster == null) {
            return;
        }
        int level = context.stack.getEnchantmentLevel(Enchantments.f_44984_);
        if (level == 0) {
            return;
        }
        context.spell.setManaCost(context.spell.getManaCost() * (1.0f - 0.05f * (float)level));
    }

    public static final void modifyStepEnchantments(SpellAdjustingContext context) {
        if (!context.spell.isValid()) {
            return;
        }
        ItemStack spellStack = context.stack;
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)spellStack);
        for (Map.Entry e : enchantments.entrySet()) {
            if (!(e.getKey() instanceof ModifierEnchantment)) continue;
            ModifierEnchantment me = (ModifierEnchantment)((Object)e.getKey());
            int steps = me.bonusStepsPerLevel * (Integer)e.getValue();
            if (context.spell.getShape().getContainedAttributes().contains((Object)me.boost)) {
                for (int i = 0; i < steps; ++i) {
                    context.spell.getShape().stepUpIgnoreMax(me.boost);
                }
            }
            context.spell.iterateComponents(c -> {
                if (c.getContainedAttributes().contains((Object)me.boost)) {
                    for (int i = 0; i < steps; ++i) {
                        c.stepUpIgnoreMax(me.boost);
                    }
                }
            });
        }
    }

    public static final boolean checkSummerFire(SpellAdjustingContext context) {
        if (!(context.caster instanceof Player) || context.stage != SpellCastStage.CASTING && context.stage != SpellCastStage.SPELL_TOOLTIP) {
            return false;
        }
        Player player = (Player)context.caster;
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null || progression.getAlliedFaction() != Factions.FEY) {
            return false;
        }
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        return magic != null && magic.getCastingResource().getRegistryName() == CastingResourceIDs.SUMMER_FIRE;
    }

    public static final boolean checkWinterIce(SpellAdjustingContext context) {
        if (!(context.caster instanceof Player) || context.stage != SpellCastStage.CASTING && context.stage != SpellCastStage.SPELL_TOOLTIP) {
            return false;
        }
        Player player = (Player)context.caster;
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null || progression.getAlliedFaction() != Factions.FEY) {
            return false;
        }
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        return magic != null && magic.getCastingResource().getRegistryName() == CastingResourceIDs.WINTER_ICE;
    }

    public static final void modifySummerFire(SpellAdjustingContext context) {
        boolean isDay;
        if (!context.spell.isValid()) {
            return;
        }
        long time = context.caster.m_9236_().m_46468_() % 24000L;
        boolean bl = isDay = time <= 13000L;
        if (isDay) {
            SpellAdjusters.multiplyAttributes(context, 1.25f, Attribute.DURATION, Attribute.DAMAGE);
            SpellAdjusters.multiplyAttributes(context, 1.5f, Attribute.RANGE, Attribute.SPEED);
        } else {
            SpellAdjusters.stepDownAttributes(context, 2, Attribute.DURATION, Attribute.SPEED);
            SpellAdjusters.stepDownAttributes(context, 3, Attribute.RANGE);
            SpellAdjusters.stepDownAttributes(context, 5, Attribute.DAMAGE);
        }
    }

    public static final void modifyWinterIce(SpellAdjustingContext context) {
        boolean isNight;
        if (!context.spell.isValid()) {
            return;
        }
        long time = context.caster.m_9236_().m_46468_() % 24000L;
        boolean bl = isNight = time >= 13000L;
        if (isNight) {
            SpellAdjusters.multiplyAttributes(context, 1.25f, Attribute.DURATION, Attribute.DAMAGE);
            SpellAdjusters.multiplyAttributes(context, 1.5f, Attribute.RANGE, Attribute.SPEED);
        } else {
            SpellAdjusters.stepDownAttributes(context, 2, Attribute.DURATION, Attribute.SPEED);
            SpellAdjusters.stepDownAttributes(context, 3, Attribute.RANGE);
            SpellAdjusters.stepDownAttributes(context, 5, Attribute.DAMAGE);
        }
    }

    private static final void multiplyAttributes(SpellAdjustingContext context, float multiplier, Attribute ... attributes) {
        for (Attribute attr : attributes) {
            context.spell.getShape().setMultiplier(attr, multiplier);
            context.spell.iterateComponents(c -> c.setMultiplier(attr, multiplier));
        }
    }

    private static final void stepDownAttributes(SpellAdjustingContext context, int steps, Attribute ... attributes) {
        for (Attribute attr : attributes) {
            for (int i = 0; i < steps; ++i) {
                context.spell.getShape().stepDown(attr, 0.0f);
            }
            context.spell.iterateComponents(c -> {
                for (int i = 0; i < steps; ++i) {
                    c.stepDown(attr, 0.0f);
                }
            });
        }
    }
}

