/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.items.ItemInit;
import com.mna.items.artifice.SpellModifierRing;
import com.mna.tools.TeleportHelper;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import top.theillusivec4.curios.api.CuriosApi;

public class ComponentBlink
extends SpellEffect {
    public ComponentBlink(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.RANGE, 5.0f, 5.0f, 16.0f, 1.0f, 2.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        if (target == SpellTarget.NONE) {
            return ComponentApplicationResult.FAIL;
        }
        Vec3 targetPosition = null;
        LivingEntity tgt = null;
        if (target.isLivingEntity()) {
            if (source.isPlayerCaster() && ((SpellModifierRing)ItemInit.BLINK_PRECISION_RING.get()).isEquippedAndHasMana(source.getCaster(), 1.0f, false) && source.getCaster() != target.getEntity()) {
                float step = 1.5f;
                Vec3 delta = target.getLivingEntity().m_20156_().m_82541_().m_82490_((double)step);
                tgt = source.getCaster();
                do {
                    if (!((targetPosition = target.getLivingEntity().m_20182_().m_82546_(delta)).m_82554_(source.getCaster().m_20182_()) < (double)step)) continue;
                    ((Player)source.getCaster()).m_213846_((Component)Component.m_237115_((String)"mna:components/blink.failed"));
                    return ComponentApplicationResult.FAIL;
                } while (!TeleportHelper.coordsValidForBlink((Level)context.getServerLevel(), (int)targetPosition.m_7096_(), (int)targetPosition.m_7098_(), (int)targetPosition.m_7094_()));
                Vec3 targetEye = target.getLivingEntity().m_146892_();
                Player looker = source.getPlayer();
                DelayedEventQueue.pushEvent(context.getLevel(), new TimedDelayedEvent<Vec3>("look", 1, targetEye, (k, v) -> looker.m_7618_(EntityAnchorArgument.Anchor.EYES, targetEye)));
                CuriosApi.getCuriosHelper().findFirstCurio(source.getCaster(), (Item)ItemInit.BLINK_PRECISION_RING.get()).ifPresent(t -> ((SpellModifierRing)ItemInit.BLINK_PRECISION_RING.get()).consumeMana(t.stack(), 1.0f, source.getPlayer()));
            } else {
                tgt = target.getLivingEntity();
                targetPosition = TeleportHelper.calculateBlinkPosition(modificationData.getValue(Attribute.RANGE), tgt, tgt.m_20156_(), (Level)context.getServerLevel());
            }
        } else if (target.isBlock()) {
            if (source.hasCasterReference() && source.isPlayerCaster() && ((SpellModifierRing)ItemInit.BLINK_PRECISION_RING.get()).isEquippedAndHasMana(source.getCaster(), 1.0f, false)) {
                tgt = source.getCaster();
                BlockPos check = target.getBlock().m_7494_();
                if (TeleportHelper.coordsValidForBlink((Level)context.getServerLevel(), check.m_123341_(), check.m_123342_(), check.m_123343_()) && (targetPosition = target.getPosition().m_82520_(0.0, 1.0, 0.0)).m_82554_(tgt.m_20182_()) > (double)(modificationData.getValue(Attribute.RANGE) * 2.0f)) {
                    if (tgt instanceof Player) {
                        ((Player)tgt).m_213846_((Component)Component.m_237115_((String)"mna:components/blink.toofar"));
                    }
                    return ComponentApplicationResult.FAIL;
                }
                if (source.isPlayerCaster()) {
                    CuriosApi.getCuriosHelper().findFirstCurio(source.getCaster(), (Item)ItemInit.BLINK_PRECISION_RING.get()).ifPresent(t -> ((SpellModifierRing)ItemInit.BLINK_PRECISION_RING.get()).consumeMana(t.stack(), 1.0f, source.getPlayer()));
                }
            }
        } else {
            return ComponentApplicationResult.FAIL;
        }
        if (tgt == source.getCaster() && source.isPlayerCaster()) {
            IPlayerMagic magic = (IPlayerMagic)source.getPlayer().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            if (magic == null || magic.getAirCasts() >= magic.getAirCastLimit(source.getPlayer(), context.getSpell())) {
                return ComponentApplicationResult.FAIL;
            }
            if (!source.getPlayer().m_20096_()) {
                magic.incrementAirCasts(source.getPlayer(), context.getSpell());
            }
        }
        if (!context.getServerLevel().m_5776_() && tgt != null) {
            if (targetPosition == null) {
                if (tgt instanceof Player) {
                    ((Player)tgt).m_213846_((Component)Component.m_237115_((String)"mna:components/blink.failed"));
                }
                return ComponentApplicationResult.FAIL;
            }
            EntityTeleportEvent tpEvent = new EntityTeleportEvent((Entity)tgt, targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_);
            if (!MinecraftForge.EVENT_BUS.post((Event)tpEvent)) {
                tgt.m_6021_(targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_);
            }
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ENDER;
    }

    @Override
    public void SpawnParticles(Level world, Vec3 impact_position, Vec3 normal, int age, LivingEntity caster, ISpellDefinition recipe) {
        if (age == 0) {
            float particle_spread = 1.0f;
            float v = 1.0f;
            int particleCount = 25;
            for (int i = 0; i < particleCount; ++i) {
                Vec3 velocity = new Vec3(0.0, Math.random() * (double)v, 0.0);
                world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get())), (Entity)caster), impact_position.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            }
        }
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 300;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.SELF;
    }
}

