/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.faction.IFaction;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.entities.constructs.animated.Construct;
import com.mna.items.sorcery.ItemEntityCrystal;
import com.mna.spells.SpellCaster;
import com.mna.tools.InventoryUtilities;
import com.mna.tools.SummonUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ComponentCrystallize
extends SpellEffect {
    public ComponentCrystallize(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.LESSER_MAGNITUDE, 1.0f, 1.0f, 4.0f, 1.0f, 10.0f));
        this.addReagent(new ItemStack((ItemLike)Items.f_42415_), false, true, false, new IFaction[0]);
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        if (!source.isPlayerCaster()) {
            return ComponentApplicationResult.FAIL;
        }
        LivingEntity living = target.getLivingEntity();
        if (living != null && !(living instanceof Player) && living.m_6072_() && living.m_6084_()) {
            boolean isConstructAndIsMine = living instanceof Construct && ((Construct)living).getOwner() == source.getPlayer();
            int magnitude = (int)modificationData.getValue(Attribute.LESSER_MAGNITUDE);
            if (!(isConstructAndIsMine || this.magnitudeHealthCheck(source, target, magnitude, 20) && !SummonUtils.isSummon((Entity)living))) {
                return ComponentApplicationResult.FAIL;
            }
            if (!SpellCaster.consumeReagents(source.getPlayer(), source.getHand(), this.getRequiredReagents(source.getPlayer(), source.getHand()))) {
                return ComponentApplicationResult.FAIL;
            }
            if (!context.getLevel().m_5776_()) {
                Pair<Boolean, Boolean> captureRedirect = InventoryUtilities.getCaptureAndRedirect(source.getPlayer());
                ItemStack stack = ItemEntityCrystal.storeEntity(target.getEntity());
                target.getEntity().m_142687_(Entity.RemovalReason.DISCARDED);
                if (((Boolean)captureRedirect.getFirst()).booleanValue()) {
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                    drops.add(stack);
                    InventoryUtilities.redirectCaptureOrDrop(source.getPlayer(), (Level)context.getServerLevel(), drops, (Boolean)captureRedirect.getSecond());
                } else {
                    ItemEntity item = new ItemEntity(context.getLevel(), target.getPosition().f_82479_, target.getPosition().f_82480_, target.getPosition().f_82481_, stack);
                    context.getLevel().m_7967_((Entity)item);
                }
            }
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public boolean targetsEntities() {
        return true;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

