/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.boss.BossMonster;
import com.mna.interop.CuriosInterop;
import com.mna.items.ItemInit;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import top.theillusivec4.curios.api.SlotTypePreset;

public class ComponentFling
extends SpellEffect {
    public static final String FLING_STRENGTH = "mna:flung";
    public static final String FLING_TIME = "mna:fling_time";

    public ComponentFling(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.SPEED, 1.0f, 1.0f, 3.0f, 1.0f, 5.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        Entity vehicle;
        float speed = modificationData.getValue(Attribute.SPEED);
        if (!target.isEntity()) {
            return ComponentApplicationResult.FAIL;
        }
        Entity eTarget = target.getEntity();
        if (target.getEntity() == source.getCaster() && (vehicle = source.getCaster().m_20202_()) != null) {
            eTarget = vehicle;
        }
        if (eTarget instanceof LivingEntity) {
            MobEffectInstance effect;
            LivingEntity le = (LivingEntity)eTarget;
            float max_velocity = 2.0f;
            if (CuriosInterop.IsItemInCurioSlot((Item)ItemInit.AIR_CAST_RING.get(), le, SlotTypePreset.RING)) {
                max_velocity += 1.0f;
                speed += 1.0f;
            }
            if ((effect = le.m_21124_((MobEffect)EffectInit.ENLARGE.get())) != null) {
                speed = (float)((double)speed * (1.0 - 0.1 * (double)(effect.m_19564_() + 1)));
                max_velocity *= 0.5f;
            }
            if ((effect = le.m_21124_((MobEffect)EffectInit.REDUCE.get())) != null) {
                speed = (float)((double)speed * (1.0 + 0.2 * (double)(effect.m_19564_() + 1)));
                max_velocity = (float)((double)max_velocity * (1.0 + 0.2 * (double)(effect.m_19564_() + 1)));
            }
            if (source.hasCasterReference() && le == source.getCaster()) {
                if (source.isPlayerCaster()) {
                    IPlayerMagic magic = (IPlayerMagic)source.getPlayer().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
                    if (magic == null || magic.getAirCasts() >= magic.getAirCastLimit(source.getPlayer(), context.getSpell())) {
                        return ComponentApplicationResult.FAIL;
                    }
                    if (!source.getPlayer().m_20096_()) {
                        magic.incrementAirCasts(source.getPlayer(), context.getSpell());
                    }
                    if (source.getPlayer().m_21120_(source.getHand()).m_41720_() == ItemInit.ICARIAN_FLIGHT.get()) {
                        max_velocity = 1000.0f;
                    }
                }
                Vec3 motion = source.getCaster().m_20154_().m_82541_();
                motion = motion.m_82490_((double)speed);
                source.getCaster().m_5997_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
                motion = source.getCaster().m_20184_();
                if (motion.m_82553_() > (double)max_velocity) {
                    double scale = (double)max_velocity / motion.m_82553_();
                    source.getCaster().m_20256_(motion.m_82490_(scale));
                }
                source.getCaster().f_19864_ = true;
                if (source.isPlayerCaster()) {
                    ((ServerPlayer)source.getPlayer()).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)le));
                }
                ComponentFling.setFlags(le, speed);
                return ComponentApplicationResult.SUCCESS;
            }
            if (le instanceof Player) {
                Player targetPlayer = (Player)le;
                Vec3 motion = source.hasCasterReference() ? source.getCaster().m_20154_() : targetPlayer.m_20154_();
                ComponentFling.flingTarget((LivingEntity)targetPlayer, motion, speed, max_velocity, source.getCaster() instanceof BossMonster ? 0.5f : 1.0f);
                return ComponentApplicationResult.SUCCESS;
            }
            float mX = (float)(source.getOrigin().m_7096_() - target.getLivingEntity().m_20185_());
            float mZ = (float)(source.getOrigin().m_7094_() - target.getLivingEntity().m_20189_());
            if (source.getCaster().m_20202_() == le) {
                mX = (float)(-source.getCaster().m_20156_().f_82479_);
                mZ = (float)(-source.getCaster().m_20156_().f_82481_);
            }
            ComponentFling.flingTarget(le, new Vec3((double)mX, (double)speed, (double)mZ), speed, max_velocity);
            return ComponentApplicationResult.SUCCESS;
        }
        float mX = (float)(source.getOrigin().m_7096_() - eTarget.m_20185_());
        float mZ = (float)(source.getOrigin().m_7094_() - eTarget.m_20189_());
        if (source.getCaster().m_20202_() == eTarget) {
            mX = (float)(-source.getCaster().m_20156_().f_82479_);
            mZ = (float)(-source.getCaster().m_20156_().f_82481_);
        }
        eTarget.f_19812_ = true;
        Vec3 vector3d = eTarget.m_20184_();
        Vec3 vector3d1 = new Vec3((double)mX, 0.0, (double)mZ).m_82541_().m_82490_((double)speed);
        eTarget.m_20334_(vector3d.f_82479_ / 2.0 - vector3d1.f_82479_, eTarget.m_20096_() ? Math.min(0.4, vector3d.f_82480_ / 2.0 + (double)speed) : vector3d.f_82480_, vector3d.f_82481_ / 2.0 - vector3d1.f_82481_);
        return ComponentApplicationResult.SUCCESS;
    }

    public static void flingTarget(LivingEntity target, Vec3 direction, float strength, float kbResistFactor) {
        ComponentFling.flingTarget(target, direction, strength, 2.0f, kbResistFactor);
    }

    public static void flingTarget(LivingEntity target, Vec3 direction, float strength, float max_velocity, float kbResistFactor) {
        if (target == null) {
            return;
        }
        MobEffectInstance effect = target.m_21124_((MobEffect)EffectInit.ENLARGE.get());
        if (effect != null) {
            strength = (float)((double)strength * (1.0 - 0.1 * (double)(effect.m_19564_() + 1)));
            max_velocity *= 0.5f;
        }
        if ((effect = target.m_21124_((MobEffect)EffectInit.REDUCE.get())) != null) {
            strength = (float)((double)strength * (1.0 + 0.2 * (double)(effect.m_19564_() + 1)));
            max_velocity = (float)((double)max_velocity * (1.0 + 0.2 * (double)(effect.m_19564_() + 1)));
        }
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            Vec3 motion = direction.m_82541_().m_82490_((double)strength);
            targetPlayer.m_5997_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
            motion = targetPlayer.m_20184_();
            if (motion.m_82553_() > (double)max_velocity) {
                double scale = (double)max_velocity / motion.m_82553_();
                targetPlayer.m_20256_(motion.m_82490_(scale));
            }
            targetPlayer.f_19864_ = true;
            ((ServerPlayer)targetPlayer).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)targetPlayer));
            if (!CuriosInterop.IsItemInCurioSlot((Item)ItemInit.AIR_CAST_RING.get(), (LivingEntity)targetPlayer, SlotTypePreset.RING)) {
                ComponentFling.setFlags((LivingEntity)targetPlayer, strength);
            }
        } else {
            LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)strength, (double)direction.f_82479_, (double)direction.f_82481_);
            if (!event.isCanceled()) {
                double kbRes = target.m_21133_(Attributes.f_22278_);
                strength = event.getStrength();
                direction = new Vec3(event.getRatioX(), 0.0, event.getRatioZ());
                if (!((double)(strength = (float)((double)strength * (1.0 - kbRes * (double)kbResistFactor))) <= 0.0)) {
                    target.f_19812_ = true;
                    Vec3 vec3 = target.m_20184_();
                    Vec3 vec31 = new Vec3(direction.f_82479_, 0.0, direction.f_82481_).m_82541_().m_82490_((double)strength);
                    target.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, target.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0 + (double)strength) : vec3.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                }
            }
            target.m_5997_(0.0, (double)(0.2f * strength), 0.0);
            if (target instanceof PathfinderMob) {
                ((PathfinderMob)target).m_21573_().m_26573_();
            }
            ComponentFling.setFlags(target, strength);
        }
    }

    private static void setFlags(LivingEntity le, float strength) {
        le.getPersistentData().m_128350_(FLING_STRENGTH, strength);
        le.getPersistentData().m_128356_(FLING_TIME, le.m_9236_().m_46467_());
        le.f_19812_ = true;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.WIND;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.WIND;
    }

    @Override
    public void SpawnParticles(Level world, Vec3 impact_position, Vec3 normal, int age, LivingEntity caster, ISpellDefinition recipe) {
        if (age > 10) {
            return;
        }
        float particle_spread = 1.0f;
        int particleCount = 10;
        Vec3 velocity = caster != null ? caster.m_20154_() : new Vec3(0.0, 0.1, 0.0);
        for (int i = 0; i < particleCount; ++i) {
            world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setScale(0.2f).setColor(10, 10, 10), (Entity)caster), impact_position.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), impact_position.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.HARMFUL;
    }
}

