/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.entities.DamageHelper;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IDamageComponent;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.config.GeneralConfig;
import com.mna.effects.EffectInit;
import com.mna.tools.BlockUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ComponentFrostDamage
extends SpellEffect
implements IDamageComponent {
    public ComponentFrostDamage(ResourceLocation icon) {
        super(icon, new AttributeValuePair(Attribute.DAMAGE, 5.0f, 1.0f, 20.0f, 0.5f, 3.0f), new AttributeValuePair(Attribute.DURATION, 3.0f, 0.0f, 10.0f, 1.0f, 2.0f));
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        if (target.isEntity()) {
            if (target.isLivingEntity()) {
                if (target.getEntity().m_142079_()) {
                    int addedTicks = (int)(20.0f * modificationData.getValue(Attribute.DAMAGE));
                    if (target.getLivingEntity().m_21023_((MobEffect)EffectInit.SOAKED.get())) {
                        addedTicks *= 2;
                    }
                    target.getEntity().m_146917_(target.getEntity().m_146888_() + addedTicks);
                }
                float damage = modificationData.getValue(Attribute.DAMAGE) * GeneralConfig.getDamageMultiplier();
                target.getEntity().m_6469_(DamageHelper.createSourcedType(DamageHelper.FROST, context.getLevel().m_9598_(), (Entity)source.getCaster()), damage);
                if (target.isLivingEntity()) {
                    target.getLivingEntity().m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)modificationData.getValue(Attribute.DURATION) * 20));
                }
                return ComponentApplicationResult.SUCCESS;
            }
        } else if (target.isBlock()) {
            BlockState state = context.getServerLevel().m_8055_(target.getBlock());
            if (state.m_60734_() == Blocks.f_49990_ && state.m_61138_((Property)LiquidBlock.f_54688_)) {
                if ((Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                    BlockUtils.placeBlock(context.getServerLevel(), target.getBlock(), Direction.UP, modificationData.getValue(Attribute.DAMAGE) >= 10.0f ? Blocks.f_50126_.m_49966_() : Blocks.f_50449_.m_49966_(), source.getPlayer());
                    return ComponentApplicationResult.SUCCESS;
                }
            } else {
                if (state.m_60734_() == Blocks.f_49991_ && state.m_61138_((Property)LiquidBlock.f_54688_) && modificationData.getValue(Attribute.DAMAGE) >= 10.0f) {
                    if ((Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                        BlockUtils.placeBlock(context.getServerLevel(), target.getBlock(), Direction.UP, Blocks.f_50080_.m_49966_(), source.getPlayer());
                    } else {
                        BlockUtils.placeBlock(context.getServerLevel(), target.getBlock(), Direction.UP, Blocks.f_50652_.m_49966_(), source.getPlayer());
                    }
                    return ComponentApplicationResult.SUCCESS;
                }
                if (state.m_60734_() == Blocks.f_50083_ && BlockUtils.destroyBlock(source.getCaster(), (Level)context.getServerLevel(), target.getBlock(), false, (Tier)Tiers.STONE)) {
                    BlockUtils.updateBlockState((Level)context.getServerLevel(), target.getBlock());
                    return ComponentApplicationResult.SUCCESS;
                }
            }
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.ICE;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ICE;
    }

    @Override
    public void SpawnParticles(Level world, Vec3 impact_position, Vec3 normal, int age, LivingEntity caster, ISpellDefinition recipe) {
        Random rndm = new Random(1234L);
        if (age < 5) {
            for (int i = 0; i < 25; ++i) {
                world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), (Entity)caster), impact_position.f_82479_ + (double)rndm.nextFloat() - 0.5, impact_position.f_82480_ + (double)rndm.nextFloat() - 0.5, impact_position.f_82481_ + (double)rndm.nextFloat() - 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.HARMFUL;
    }

    @Override
    public List<Affinity> getValidTinkerAffinities() {
        return Arrays.asList(Affinity.WATER, Affinity.ICE);
    }
}

