/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.faction.IFaction;
import com.mna.api.items.IPositionalItem;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.factions.Factions;
import com.mna.items.ItemInit;
import com.mna.tools.TeleportHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class ComponentRecall
extends SpellEffect {
    public ComponentRecall(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.RANGE, 1.0f, 1.0f, 5.0f, 1.0f, 25.0f), new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 10.0f));
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        double maxDist;
        ItemStack markingRune;
        if (!source.hasCasterReference()) return ComponentApplicationResult.FAIL;
        if (!target.isEntity()) return ComponentApplicationResult.FAIL;
        if (!target.getEntity().m_6084_()) return ComponentApplicationResult.FAIL;
        if (!target.getEntity().m_6072_()) return ComponentApplicationResult.FAIL;
        ItemStack itemStack = markingRune = source.getCaster().m_21205_().m_41720_() == ItemInit.RUNE_MARKING.get() || source.getCaster().m_21205_().m_41720_() == ItemInit.BOOK_MARKS.get() ? source.getCaster().m_21205_() : source.getCaster().m_21206_();
        if (!(markingRune.m_41720_() instanceof IPositionalItem)) {
            if (!source.isPlayerCaster()) return ComponentApplicationResult.FAIL;
            source.getPlayer().m_213846_((Component)Component.m_237115_((String)"mna:components/recall.no_marker"));
            return ComponentApplicationResult.FAIL;
        }
        BlockPos pos = ((IPositionalItem)markingRune.m_41720_()).getLocation(markingRune);
        if (pos == null) return ComponentApplicationResult.FAIL;
        double dist = target.getEntity().m_20183_().m_123331_((Vec3i)pos);
        if (dist > (maxDist = (double)(modificationData.getValue(Attribute.RANGE) * 500.0f)) * maxDist) {
            source.getPlayer().m_213846_((Component)Component.m_237115_((String)"mna:components/recall.too_far"));
            return ComponentApplicationResult.FAIL;
        }
        int magnitude = (int)modificationData.getValue(Attribute.MAGNITUDE);
        if (this.casterTeamCheck(source, target) && this.magnitudeHealthCheck(source, target, magnitude, 20)) {
            Vec3 targetPos = Vec3.m_82512_((Vec3i)pos);
            EntityTeleportEvent tpEvent = new EntityTeleportEvent(target.getEntity(), targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            if (MinecraftForge.EVENT_BUS.post((Event)tpEvent)) return ComponentApplicationResult.FAIL;
            TeleportHelper.teleportEntity(target.getEntity(), (ResourceKey<Level>)context.getServerLevel().m_46472_(), targetPos);
            return ComponentApplicationResult.SUCCESS;
        }
        source.getPlayer().m_213846_((Component)Component.m_237115_((String)"mna:generic.too_powerful"));
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    @Override
    public IFaction getFactionRequirement() {
        return Factions.COUNCIL;
    }

    @Override
    public float initialComplexity() {
        return 50.0f;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

