/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.blocks.BlockInit;
import com.mna.blocks.ritual.ChalkRuneBlock;
import com.mna.blocks.sorcery.SpectralCraftingTableBlock;
import com.mna.blocks.sorcery.SpectralStonecutterBlock;
import com.mna.gui.containers.block.ContainerSpectralStonecutter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class ComponentSpectralStonecutter
extends SpellEffect {
    public ComponentSpectralStonecutter(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[0]);
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        if (context.hasEntityBeenAffected(this, (Entity)source.getCaster())) {
            return ComponentApplicationResult.FAIL;
        }
        context.addAffectedEntity(this, (Entity)source.getCaster());
        if (target.isBlock()) {
            ServerLevel world = context.getServerLevel();
            BlockPos targetBlock = target.getBlock();
            Direction targetBlockFace = target.getBlockFace(this);
            BlockState against = world.m_8055_(targetBlock);
            if (against.m_60734_() == BlockInit.CHALK_RUNE.get() && ((Boolean)against.m_61143_((Property)ChalkRuneBlock.METAL)).booleanValue() && source.isPlayerCaster()) {
                boolean placed = false;
                if (!ForgeEventFactory.onBlockPlace((Entity)source.getPlayer(), (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)targetBlock), (Direction)targetBlockFace)) {
                    BlockState placementState = (BlockState)((SpectralStonecutterBlock)BlockInit.SPECTRAL_STONECUTTER.get()).m_49966_().m_61124_((Property)SpectralCraftingTableBlock.PERMANENT, (Comparable)Boolean.valueOf(true));
                    world.m_46597_(targetBlock, placementState);
                    placed = true;
                }
                return ComponentApplicationResult.fromBoolean(placed);
            }
            return ComponentApplicationResult.fromBoolean(this.tryPlaceBlock((Player)source.getPlayer(), (ServerLevel)world, (Block)((Block)BlockInit.SPECTRAL_STONECUTTER.get()), (BlockPos)targetBlock, (Direction)targetBlockFace, (boolean)true, null).success);
        }
        if (target.isEntity() && source.isPlayerCaster() && target.getEntity() instanceof Player) {
            ((Player)target.getEntity()).m_5893_(this.getContainer(context.getServerLevel().m_8055_(source.getPlayer().m_20183_()), (Level)context.getServerLevel(), source.getPlayer().m_20183_()));
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    public MenuProvider getContainer(BlockState state, Level worldIn, BlockPos pos) {
        return new SimpleMenuProvider((p_220272_2_, p_220272_3_, p_220272_4_) -> new ContainerSpectralStonecutter(p_220272_2_, p_220272_3_, ContainerLevelAccess.m_39289_((Level)worldIn, (BlockPos)pos)), SpectralStonecutterBlock.CONTAINER_TITLE);
    }

    @Override
    public void SpawnParticles(Level world, Vec3 impact_position, Vec3 normal, int age, LivingEntity caster, ISpellDefinition recipe) {
        if (age > 1) {
            return;
        }
        BlockPos imp = BlockPos.m_274446_((Position)impact_position);
        for (int i = 0; i < 50; ++i) {
            world.m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), (Entity)caster), (double)imp.m_123341_() + 0.5, (double)imp.m_123342_() + 0.5, (double)imp.m_123343_() + 0.5, -0.25 + Math.random() * 0.5, Math.random() * 0.25, -0.25 + Math.random() * 0.5);
        }
    }

    @Override
    public boolean targetsBlocks() {
        return true;
    }

    @Override
    public boolean canBeChanneled() {
        return false;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    @Override
    public float initialComplexity() {
        return 5.0f;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.UTILITY;
    }
}

