/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.effects.EffectInit;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ComponentSplash
extends SpellEffect {
    public ComponentSplash(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.DURATION, 20.0f, 5.0f, 60.0f, 5.0f, 5.0f), new AttributeValuePair(Attribute.PRECISION, 0.0f, 0.0f, 1.0f, 1.0f, 5.0f));
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        if (target.isLivingEntity()) {
            target.getLivingEntity().m_7292_(new MobEffectInstance((MobEffect)EffectInit.SOAKED.get(), (int)modificationData.getValue(Attribute.DURATION) * 20, 0, false, true));
        } else if (target.isBlock()) {
            if (context.countAffectedBlocks(this) > 0) {
                return ComponentApplicationResult.FAIL;
            }
            BlockPos block = target.getBlock();
            BlockState targetState = context.getServerLevel().m_8055_(block);
            if (targetState.m_60734_() == Blocks.f_50256_) {
                context.getLevel().m_7731_(block, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 3);
                context.addAffectedBlock(this, block);
                return ComponentApplicationResult.SUCCESS;
            }
            if (targetState.m_60734_() == Blocks.f_152476_) {
                context.getLevel().m_7731_(block, (BlockState)targetState.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 3);
                context.addAffectedBlock(this, block);
                return ComponentApplicationResult.SUCCESS;
            }
            if (modificationData.getValue(Attribute.PRECISION) == 1.0f) {
                return ComponentApplicationResult.FAIL;
            }
            if (context.getServerLevel().m_6042_().f_63857_()) {
                if (context.countAffectedBlocks(this) == 0) {
                    context.addAffectedBlock(this, block);
                    context.getServerLevel().m_5594_(null, block, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (context.getServerLevel().m_213780_().m_188501_() - context.getServerLevel().m_213780_().m_188501_()) * 0.8f);
                }
                return ComponentApplicationResult.FAIL;
            }
            context.addAffectedBlock(this, block);
            if (!this.setBlockWaterlogged((Level)context.getServerLevel(), block, targetState)) {
                block = block.m_121955_(target.getBlockFace(this).m_122436_());
                if (context.getServerLevel().m_46859_(block)) {
                    context.addAffectedBlock(this, block);
                    context.getServerLevel().m_7731_(block, Blocks.f_49990_.m_49966_(), 3);
                    if (!GeneralConfigValues.SplashCreatesSources) {
                        DelayedEventQueue.pushEvent(context.getLevel(), new TimedDelayedEvent<BlockPos>("water_fix", 20, block, (s, i) -> context.getServerLevel().m_7731_(i, (BlockState)Blocks.f_49990_.m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(15)), 3)));
                    }
                    context.getServerLevel().m_186460_(block, Blocks.f_49990_, 3);
                } else if (!this.setBlockWaterlogged((Level)context.getServerLevel(), block, targetState)) {
                    return ComponentApplicationResult.FAIL;
                }
            }
        }
        return ComponentApplicationResult.SUCCESS;
    }

    private boolean setBlockWaterlogged(Level world, BlockPos pos, BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_) && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.WATER;
    }

    @Override
    public float initialComplexity() {
        return 10.0f;
    }

    @Override
    public boolean canBeChanneled() {
        return false;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.HARMFUL;
    }
}

