/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.shapes;

import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.bound.ItemBoundShield;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ShapeBoundShield
extends Shape {
    public ShapeBoundShield(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair[0]);
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, Level world, IModifiedSpellPart<Shape> modifiedData, ISpellDefinition recipe) {
        if (source.getCaster() == null || !source.isPlayerCaster()) {
            return Arrays.asList(SpellTarget.NONE);
        }
        ItemStack held = source.getPlayer().m_21120_(source.getHand());
        ItemStack replacement = ((ItemBoundShield)ItemInit.BOUND_SHIELD.get()).createFromSpell(held, recipe);
        int slot = source.getHand() == InteractionHand.MAIN_HAND ? source.getPlayer().m_150109_().f_35977_ : 40;
        source.getPlayer().m_150109_().m_6836_(slot, replacement);
        return Arrays.asList(new SpellTarget((Entity)source.getCaster()));
    }

    @Override
    public float initialComplexity() {
        return 5.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public boolean canBeOnRandomStaff() {
        return false;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }

    @Override
    public boolean grantComponentRoteXP() {
        return false;
    }
}

