/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.shapes;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.sorcery.targeting.Smite;
import com.mna.factions.Factions;
import com.mna.items.sorcery.ItemStaff;
import com.mna.spells.shapes.ShapeRaytrace;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public class ShapeSmite
extends ShapeRaytrace {
    public ShapeSmite(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.RADIUS, 1.0f, 1.0f, 5.0f, 0.5f, 3.0f), new AttributeValuePair(Attribute.RANGE, 8.0f, 8.0f, 32.0f, 1.0f, 2.0f), new AttributeValuePair(Attribute.HEIGHT, 1.0f, 1.0f, 3.0f, 0.5f, 3.0f));
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, Level world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        List<SpellTarget> tgts = super.Target(source, world, modificationData, recipe);
        SpellTarget tgt = tgts.get(0);
        if (tgt == SpellTarget.NONE) {
            return tgts;
        }
        return this.targetAfterRaytrace(source, world, modificationData, recipe, tgt);
    }

    @Override
    public List<SpellTarget> TargetNPCCast(SpellSource source, Level world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe, SpellTarget targetHint) {
        return this.targetAfterRaytrace(source, world, modificationData, recipe, targetHint);
    }

    private List<SpellTarget> targetAfterRaytrace(SpellSource source, Level world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe, SpellTarget hint) {
        if (!world.f_46443_) {
            ItemStack heldItem;
            LazyOptional progression;
            Vec3 position = null;
            if (hint.isBlock()) {
                BlockPos blockPos = hint.getBlock().m_121945_(hint.getBlockFace(null));
                position = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
            } else if (hint.isEntity()) {
                position = hint.getEntity().m_20182_();
            }
            int count = 0;
            BlockPos targetPos = BlockPos.m_274446_((Position)position);
            while (count < 15) {
                if (!world.m_46859_(targetPos)) {
                    --count;
                    break;
                }
                ++count;
                targetPos = targetPos.m_7494_();
            }
            position = position.m_82520_(0.0, (double)count, 0.0);
            float bonusDamage = 0.0f;
            if (source.isPlayerCaster() && (progression = source.getPlayer().getCapability(PlayerProgressionProvider.PROGRESSION)).isPresent() && ((IPlayerProgression)progression.resolve().get()).getAlliedFaction() == Factions.COUNCIL && (heldItem = source.getCaster().m_21120_(source.getHand())).m_41720_() instanceof ItemStaff) {
                bonusDamage = (float)((byte)heldItem.getEnchantmentLevel(Enchantments.f_44988_)) * 0.1f;
            }
            CompoundTag recipeData = new CompoundTag();
            recipe.writeToNBT(recipeData);
            Smite projectile = new Smite(world, position, recipeData, source.getCaster());
            projectile.setBonusDamagePctFromHeight(bonusDamage);
            world.m_7967_((Entity)projectile);
            return Arrays.asList(new SpellTarget((Entity)projectile));
        }
        return Arrays.asList(SpellTarget.NONE);
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 500;
    }
}

