/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.shapes;

import com.mna.api.config.GeneralConfigValues;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedSpellEffect;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.PhylacteryStaffItem;
import com.mna.spells.shapes.ShapeRaytrace;
import com.mna.tools.SummonUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class ShapeSummon
extends ShapeRaytrace {
    public ShapeSummon(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.DURATION, 30.0f, 30.0f, 240.0f, 30.0f, 20.0f), new AttributeValuePair(Attribute.RANGE, 8.0f, 1.0f, 32.0f, 1.0f, 2.0f), new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 10.0f));
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, Level world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        List<SpellTarget> supertargets;
        SpellTarget superTarget;
        if (source.isPlayerCaster() && (superTarget = (supertargets = super.Target(source, world, modificationData, recipe)).get(0)) != SpellTarget.NONE) {
            if (!world.f_46443_) {
                ItemStack phylactery;
                ItemStack itemStack = phylactery = source.getHand() == InteractionHand.MAIN_HAND ? source.getPlayer().m_21206_() : source.getPlayer().m_21205_();
                if (phylactery.m_41619_() || !PhylacteryStaffItem.isFilled(phylactery)) {
                    List results = CuriosApi.getCuriosHelper().findCurios((LivingEntity)source.getPlayer(), is -> is.m_41720_() == ItemInit.STAFF_PHYLACTERY.get() || is.m_41720_() == ItemInit.CRYSTAL_PHYLACTERY.get());
                    for (SlotResult sr : results) {
                        if (sr.stack().m_41619_()) continue;
                        phylactery = sr.stack().m_41777_();
                    }
                }
                if (!PhylacteryStaffItem.isFilled(phylactery)) {
                    source.getPlayer().m_213846_((Component)Component.m_237115_((String)"mna:shapes/summon.nophylactery"));
                    return Arrays.asList(SpellTarget.NONE);
                }
                EntityType<? extends Mob> type = PhylacteryStaffItem.getEntityType(phylactery);
                if (type == null) {
                    source.getPlayer().m_213846_((Component)Component.m_237115_((String)"mna:shapes/summon.nophylactery"));
                    return Arrays.asList(SpellTarget.NONE);
                }
                if (GeneralConfigValues.SummonBlacklist.contains(ForgeRegistries.ENTITY_TYPES.getKey(type).toString())) {
                    source.getPlayer().m_213846_((Component)Component.m_237115_((String)"mna:shapes/summon.blacklisted"));
                    return Arrays.asList(SpellTarget.NONE);
                }
                ItemStack castItem = source.getHand() == InteractionHand.MAIN_HAND ? source.getPlayer().m_21205_() : source.getPlayer().m_21206_();
                SummonUtils.clampTrackedEntities((LivingEntity)source.getPlayer());
                int numSummons = 1 + (int)Math.ceil((float)castItem.getEnchantmentLevel(Enchantments.f_44955_) / 2.0f);
                for (int i = 0; i < numSummons; ++i) {
                    if (this.summonCreature(source, world, modificationData, recipe, type, superTarget)) continue;
                    return Arrays.asList(SpellTarget.NONE);
                }
            }
            return Arrays.asList(new SpellTarget((Entity)source.getPlayer()));
        }
        return Arrays.asList(SpellTarget.NONE);
    }

    private boolean summonCreature(SpellSource source, Level world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe, EntityType<? extends Mob> type, SpellTarget superTarget) {
        String name = source.getPlayer().m_5446_().getString();
        MutableComponent summonName = Component.m_237113_((String)name);
        summonName.m_130946_("'s ");
        summonName.m_7220_((Component)Component.m_237115_((String)type.m_20675_()));
        Mob summon = (Mob)type.m_20615_(world);
        summon.m_146884_(Vec3.m_82539_((Vec3i)superTarget.getBlock().m_7494_()));
        if (!GeneralConfigValues.SummonBosses && !summon.m_6072_()) {
            return false;
        }
        int magnitude = (int)modificationData.getValue(Attribute.MAGNITUDE);
        if (!this.magnitudeHealthCheck(source, new SpellTarget((Entity)summon), magnitude, 20)) {
            return false;
        }
        SummonUtils.setSummon(summon, (LivingEntity)source.getPlayer(), (int)(modificationData.getValue(Attribute.DURATION) * 20.0f));
        SpellTarget tgt = new SpellTarget((Entity)summon);
        SpellContext context = new SpellContext(world, recipe, (Entity)summon);
        recipe.getComponents().forEach(c -> {
            int delay = (int)Math.max(10.0f, c.getValue(Attribute.DELAY) * 20.0f);
            DelayedEventQueue.pushEvent((Level)context.getServerLevel(), new TimedDelayedSpellEffect("summon_delay", delay, source, tgt, (IModifiedSpellPart<SpellEffect>)c, context));
        });
        if (!world.m_7967_((Entity)summon)) {
            return false;
        }
        SummonUtils.addTrackedEntity((LivingEntity)source.getPlayer(), (Entity)summon);
        return true;
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public float initialComplexity() {
        return 40.0f;
    }

    @Override
    public int baselineCooldown() {
        return 20;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }

    @Override
    public boolean canBeOnRandomStaff() {
        return false;
    }
}

