/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.items.IFactionSpecific;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.effects.EffectInit;
import com.mna.effects.beneficial.EffectCamouflage;
import com.mna.entities.sorcery.EntityDecoy;
import com.mna.items.ItemInit;
import com.mna.items.artifice.FactionSpecificSpellModifierRing;
import com.mna.network.ServerMessageDispatcher;
import com.mna.tools.SummonUtils;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;

public class EntityUtil {
    public static boolean doElytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks, float manaCost, float maxSpeed) {
        IPlayerMagic magic;
        if (!(entity instanceof Player)) {
            return false;
        }
        if (maxSpeed <= 0.0f) {
            return true;
        }
        if (flightTicks % 100 == 0 && stack.m_41720_() instanceof IFactionSpecific) {
            ((IFactionSpecific)stack.m_41720_()).usedByPlayer((Player)entity);
        }
        if ((magic = (IPlayerMagic)((Player)entity).getCapability(PlayerMagicProvider.MAGIC).orElse(null)) == null || !magic.getCastingResource().hasEnoughAbsolute(entity, manaCost)) {
            return false;
        }
        Vec3 look = entity.m_20154_();
        if (!entity.m_6144_()) {
            magic.getCastingResource().consume(entity, manaCost);
            motion = entity.m_20184_();
            float maxLength = maxSpeed;
            lookScale = 0.06;
            scaled_look = look.m_82490_(lookScale);
            motion = motion.m_82549_(scaled_look);
            if (motion.m_82553_() > (double)maxLength) {
                motion = motion.m_82490_((double)maxLength / motion.m_82553_());
            }
            entity.m_20256_(motion);
        } else {
            magic.getCastingResource().consume(entity, manaCost * 0.75f);
            motion = entity.m_20184_();
            float minLength = 0.1f;
            lookScale = -0.01;
            scaled_look = look.m_82490_(lookScale);
            motion = motion.m_82549_(scaled_look);
            if (motion.m_82553_() < (double)minLength) {
                motion = motion.m_82490_((double)minLength / motion.m_82553_());
            }
            entity.m_20256_(motion);
        }
        if (entity.m_9236_().m_5776_()) {
            Vec3 pos = entity.m_20182_().m_82549_(look.m_82490_(3.0));
            for (int i = 0; i < 5; ++i) {
                entity.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setScale(0.2f).setColor(10, 10, 10), pos.f_82479_ - 0.5 + Math.random(), pos.f_82480_ - 0.5 + Math.random(), pos.f_82481_ - 0.5 + Math.random(), -look.f_82479_, -look.f_82480_, -look.f_82481_);
            }
        }
        return true;
    }

    public static void SetLiftSpeed(Player p, float speed) {
        p.getPersistentData().m_128350_("lift_speed", 0.055f);
        if (!p.m_9236_().m_5776_() && p instanceof ServerPlayer) {
            ServerMessageDispatcher.sendSetLiftSpeedMessage((ServerPlayer)p, speed);
        }
    }

    public static List<LivingEntity> getEntitiesWithinCone(Level world, Vec3 origin, Vec3 forward, float distance, float minAngle, float maxAngle, Predicate<LivingEntity> selectionPredicate) {
        List entities = world.m_6249_((Entity)null, new AABB(BlockPos.m_274446_((Position)origin)).m_82400_((double)distance), e -> {
            Vec3 direction;
            float angleDeg;
            if (e instanceof LivingEntity && (angleDeg = (float)(Math.acos(forward.m_82526_(direction = e.m_20182_().m_82546_(origin).m_82541_())) * 180.0 / Math.PI)) >= minAngle && angleDeg <= maxAngle) {
                return selectionPredicate.test((LivingEntity)e);
            }
            return false;
        });
        return entities.stream().map(e -> (LivingEntity)e).collect(Collectors.toList());
    }

    public static float getSoulsRestored(Player soulRecipient, Entity target) {
        if (soulRecipient != null) {
            if (!(target instanceof LivingEntity) || SummonUtils.isSummon(target)) {
                return 0.0f;
            }
            if (target instanceof EntityDecoy) {
                return 0.0f;
            }
            MutableFloat restoreAmount = new MutableFloat(1.0f);
            if (target instanceof Player) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForPlayerKill);
            } else if (target instanceof Villager) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForVillagerKill);
            } else if (target instanceof IFactionEnemy) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForFactionMobKill);
            } else if (((LivingEntity)target).m_21222_()) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForUndeadKill);
            } else if (target instanceof Animal) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForAnimalKill);
            } else if (target instanceof AbstractGolem) {
                restoreAmount.setValue(0.0f);
            } else if (target instanceof Mob) {
                restoreAmount.setValue((float)GeneralConfigValues.SoulsForMobKill);
            }
            if (((LivingEntity)target).m_21023_((MobEffect)EffectInit.SOUL_VULNERABILITY.get())) {
                restoreAmount.setValue(restoreAmount.getValue().floatValue() * 5.0f);
            }
            if (((FactionSpecificSpellModifierRing)ItemInit.BONE_RING.get()).isEquippedAndHasMana((LivingEntity)soulRecipient, 3.5f, true)) {
                restoreAmount.setValue(restoreAmount.getValue().floatValue() * 2.25f);
            }
            return restoreAmount.getValue().floatValue();
        }
        return 0.0f;
    }

    @Nullable
    public static Vec3 getRetreatPos(Entity e, Vec3 direction, int maxDistance) {
        Vec3 startPos = e.m_20182_().m_82520_(0.0, 0.5, 0.0);
        Vec3 delta = direction.m_82541_();
        delta = new Vec3(delta.f_82479_, 0.0, delta.f_82481_);
        Vec3 endPos = startPos.m_82549_(delta.m_82490_((double)maxDistance));
        int count = 0;
        while (!e.m_9236_().m_46859_(BlockPos.m_274561_((double)endPos.f_82479_, (double)endPos.f_82480_, (double)endPos.f_82481_)) && count < 10) {
            ++count;
            endPos = endPos.m_82520_(0.0, 1.0, 0.0);
        }
        if (count >= 10) {
            return null;
        }
        ClipContext ctx = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, e);
        BlockHitResult brtr = e.m_9236_().m_45547_(ctx);
        if (brtr.m_6662_() == HitResult.Type.MISS) {
            return endPos;
        }
        return brtr.m_82450_().m_82549_(delta);
    }

    public static void removeInvisibility(LivingEntity living) {
        if (EntityUtil.shouldBeInvisible(living)) {
            return;
        }
        living.m_6842_(false);
    }

    public static boolean shouldBeInvisible(LivingEntity living) {
        return living.m_21023_(MobEffects.f_19609_) || living.m_21023_((MobEffect)EffectInit.MIST_FORM.get()) || living.m_21023_((MobEffect)EffectInit.TRUE_INVISIBILITY.get()) || EffectCamouflage.getCamoflagePercent(living) > 0.5f;
    }
}

