/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools;

import com.mna.api.entities.possession.PossessionActions;
import com.mna.effects.EffectInit;
import com.mna.network.messages.to_server.PossessionInputMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;

public class PossessionHelper {
    public static void handleRemoteInput(PossessionInputMessage message, Player sendingPlayer, Mob living) {
        switch (message.getType()) {
            case CLICK: {
                if (sendingPlayer.m_9236_().m_5776_()) {
                    return;
                }
                if (sendingPlayer.getPersistentData().m_128441_("posession_left_click_time")) {
                    long time = sendingPlayer.getPersistentData().m_128454_("posession_left_click_time");
                    if (sendingPlayer.m_9236_().m_46467_() < time) {
                        return;
                    }
                }
                if (!PossessionActions.Invoke(living) && !PossessionActions.InvokeDefault(living)) {
                    living.m_8032_();
                }
                sendingPlayer.getPersistentData().m_128356_("posession_left_click_time", sendingPlayer.m_9236_().m_46467_() + 30L);
                break;
            }
            case MOVEMENT: {
                boolean canFly;
                living.m_19890_(living.m_20185_(), living.m_20186_(), living.m_20189_(), message.getYaw(), message.getPitch());
                living.m_5616_(message.getYawHead());
                double y = 0.0;
                boolean bl = canFly = living.m_20068_() || living instanceof FlyingMob || living instanceof Bat || living.m_21023_((MobEffect)EffectInit.LEVITATION.get());
                if (message.getJump()) {
                    if (living.m_20096_() && !canFly) {
                        PossessionHelper.jump((LivingEntity)living);
                    } else if (canFly) {
                        living.m_20242_(true);
                        y = 1.0;
                    }
                } else if (message.getSneak() && canFly) {
                    if (living.m_20096_()) {
                        living.m_20242_(false);
                    }
                    y = -1.0;
                }
                living.m_7910_((float)living.m_21133_(Attributes.f_22279_) * 0.5f);
                if (living instanceof FlyingMob) {
                    living.m_7023_(new Vec3((double)message.getStrafe(), y, (double)message.getForward()));
                    break;
                }
                PossessionHelper.doTravel((LivingEntity)living, new Vec3((double)message.getStrafe(), y, (double)message.getForward()));
                break;
            }
        }
    }

    public static void doTravel(LivingEntity ent, Vec3 travelVector) {
        double d0 = 0.08;
        d0 = ent.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22135_();
        boolean flag = ent.m_20184_().f_82480_ <= 0.0;
        FluidState fluidstate = ent.m_9236_().m_6425_(ent.m_20183_());
        if (ent.m_20069_() && ent.m_6129_() && !ent.m_203441_(fluidstate)) {
            double d8 = ent.m_20186_();
            float f5 = ent.m_20142_() ? 0.9f : 0.8f;
            float f6 = 0.02f;
            float f7 = EnchantmentHelper.m_44922_((LivingEntity)ent);
            if (f7 > 3.0f) {
                f7 = 3.0f;
            }
            if (!ent.m_20096_()) {
                f7 *= 0.5f;
            }
            if (f7 > 0.0f) {
                f5 += (0.54600006f - f5) * f7 / 3.0f;
                f6 += (ent.m_6113_() - f6) * f7 / 3.0f;
            }
            if (ent.m_21023_(MobEffects.f_19593_)) {
                f5 = 0.96f;
            }
            ent.m_19920_(f6 *= (float)ent.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_(), travelVector);
            ent.m_6478_(MoverType.SELF, ent.m_20184_());
            Vec3 vector3d6 = ent.m_20184_();
            if (ent.f_19862_ && ent.m_6147_()) {
                vector3d6 = new Vec3(vector3d6.f_82479_, 0.2, vector3d6.f_82481_);
            }
            ent.m_20256_(vector3d6.m_82542_((double)f5, (double)0.8f, (double)f5));
            Vec3 vector3d2 = ent.m_20994_(d0, flag, ent.m_20184_());
            ent.m_20256_(vector3d2);
            if (ent.f_19862_ && ent.m_20229_(vector3d2.f_82479_, vector3d2.f_82480_ + (double)0.6f - ent.m_20186_() + d8, vector3d2.f_82481_)) {
                ent.m_20334_(vector3d2.f_82479_, (double)0.3f, vector3d2.f_82481_);
            }
        } else if (ent.m_20077_() && ent.m_6129_() && !ent.m_203441_(fluidstate)) {
            double d7 = ent.m_20186_();
            ent.m_19920_(0.02f, travelVector);
            ent.m_6478_(MoverType.SELF, ent.m_20184_());
            if (ent.m_204036_(FluidTags.f_13132_) <= ent.m_20204_()) {
                ent.m_20256_(ent.m_20184_().m_82542_(0.5, (double)0.8f, 0.5));
                Vec3 vector3d3 = ent.m_20994_(d0, flag, ent.m_20184_());
                ent.m_20256_(vector3d3);
            } else {
                ent.m_20256_(ent.m_20184_().m_82490_(0.5));
            }
            if (!ent.m_20068_()) {
                ent.m_20256_(ent.m_20184_().m_82520_(0.0, -d0 / 4.0, 0.0));
            }
            Vec3 vector3d4 = ent.m_20184_();
            if (ent.f_19862_ && ent.m_20229_(vector3d4.f_82479_, vector3d4.f_82480_ + (double)0.6f - ent.m_20186_() + d7, vector3d4.f_82481_)) {
                ent.m_20334_(vector3d4.f_82479_, (double)0.3f, vector3d4.f_82481_);
            }
        } else if (ent.m_21255_()) {
            double d10;
            double d6;
            float f2;
            Vec3 vector3d = ent.m_20184_();
            if (vector3d.f_82480_ > -0.5) {
                ent.f_19789_ = 1.0f;
            }
            Vec3 vector3d1 = ent.m_20154_();
            float f = ent.m_146909_() * ((float)Math.PI / 180);
            double d1 = Math.sqrt(vector3d1.f_82479_ * vector3d1.f_82479_ + vector3d1.f_82481_ * vector3d1.f_82481_);
            double d3 = Math.sqrt(vector3d.m_165925_());
            double d4 = vector3d1.m_82553_();
            float f1 = Mth.m_14089_((float)f);
            f1 = (float)((double)f1 * (double)f1 * Math.min(1.0, d4 / 0.4));
            vector3d = ent.m_20184_().m_82520_(0.0, d0 * (-1.0 + (double)f1 * 0.75), 0.0);
            if (vector3d.f_82480_ < 0.0 && d1 > 0.0) {
                double d5 = vector3d.f_82480_ * -0.1 * (double)f1;
                vector3d = vector3d.m_82520_(vector3d1.f_82479_ * d5 / d1, d5, vector3d1.f_82481_ * d5 / d1);
            }
            if (f < 0.0f && d1 > 0.0) {
                double d9 = d3 * (double)(-Mth.m_14031_((float)f)) * 0.04;
                vector3d = vector3d.m_82520_(-vector3d1.f_82479_ * d9 / d1, d9 * 3.2, -vector3d1.f_82481_ * d9 / d1);
            }
            if (d1 > 0.0) {
                vector3d = vector3d.m_82520_((vector3d1.f_82479_ / d1 * d3 - vector3d.f_82479_) * 0.1, 0.0, (vector3d1.f_82481_ / d1 * d3 - vector3d.f_82481_) * 0.1);
            }
            ent.m_20256_(vector3d.m_82542_((double)0.99f, (double)0.98f, (double)0.99f));
            ent.m_6478_(MoverType.SELF, ent.m_20184_());
            if (ent.f_19862_ && !ent.m_9236_().m_5776_() && (f2 = (float)((d6 = d3 - (d10 = Math.sqrt(ent.m_20184_().m_165925_()))) * 10.0 - 3.0)) > 0.0f) {
                ent.m_5496_(SoundEvents.f_11908_, (float)((double)0.9f + Math.random() * (double)0.2f), (float)((double)0.9f + Math.random() * (double)0.2f));
                ent.m_6469_(ent.m_269291_().m_269515_(), f2);
            }
            if (ent.m_20096_() && !ent.m_9236_().m_5776_()) {
                ent.m_20115_(7, false);
            }
        } else {
            BlockPos blockpos = ent.m_20183_().m_7495_();
            float f3 = ent.m_9236_().m_8055_(blockpos).getFriction((LevelReader)ent.m_9236_(), blockpos, (Entity)ent);
            float f4 = ent.m_20096_() ? f3 * 0.91f : 0.91f;
            Vec3 vector3d5 = ent.m_21074_(travelVector, f3);
            double d2 = vector3d5.f_82480_;
            if (ent.m_21023_(MobEffects.f_19620_)) {
                d2 += (0.05 * (double)(ent.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - vector3d5.f_82480_) * 0.2;
                ent.f_19789_ = 0.0f;
            } else if (ent.m_9236_().m_5776_() && !ent.m_9236_().m_46749_(blockpos)) {
                d2 = ent.m_20186_() > 0.0 ? -0.1 : 0.0;
            } else if (!ent.m_20068_()) {
                d2 -= d0;
            }
            ent.m_20334_(vector3d5.f_82479_ * (double)f4, d2 * (double)0.98f, vector3d5.f_82481_ * (double)f4);
        }
    }

    public static float getJumpUpwardsMotion(LivingEntity ent) {
        return 0.42f * PossessionHelper.getJumpFactor(ent);
    }

    public static void jump(LivingEntity ent) {
        float f = PossessionHelper.getJumpUpwardsMotion(ent);
        if (ent.m_21023_(MobEffects.f_19603_)) {
            f += 0.1f * (float)(ent.m_21124_(MobEffects.f_19603_).m_19564_() + 1);
        }
        Vec3 vector3d = ent.m_20184_();
        ent.m_20334_(vector3d.f_82479_, (double)f, vector3d.f_82481_);
        if (ent.m_20142_()) {
            float f1 = ent.m_146908_() * ((float)Math.PI / 180);
            ent.m_20256_(ent.m_20184_().m_82520_((double)(-Mth.m_14031_((float)f1) * 0.2f), 0.0, (double)(Mth.m_14089_((float)f1) * 0.2f)));
        }
        ent.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)ent);
    }

    public static float getJumpFactor(LivingEntity ent) {
        float f = ent.m_9236_().m_8055_(ent.m_20183_()).m_60734_().m_49964_();
        float f1 = ent.m_9236_().m_8055_(ent.m_20183_().m_7495_()).m_60734_().m_49964_();
        return (double)f == 1.0 ? f1 : f;
    }
}

