/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;

public class TeleportHelper {
    private static void teleport(Entity entityIn, ServerLevel worldIn, double x, double y, double z, float yaw, float pitch) {
        if (entityIn instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)entityIn;
            spe.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.delayedTeleportTo(40, new Vec3(x, y, z), new Vec2(yaw, pitch), worldIn));
        } else {
            float wrappedYaw = Mth.m_14177_((float)yaw);
            float wrappedPitch = Mth.m_14036_((float)Mth.m_14177_((float)pitch), (float)-90.0f, (float)90.0f);
            if (worldIn == entityIn.m_9236_()) {
                entityIn.m_7678_(x, y, z, wrappedYaw, wrappedPitch);
                entityIn.m_5616_(wrappedYaw);
            } else {
                entityIn.m_19877_();
                Entity entity = entityIn.m_6095_().m_20615_((Level)worldIn);
                if (entity == null) {
                    return;
                }
                entity.m_20361_(entityIn);
                entity.m_7678_(x, y, z, wrappedYaw, wrappedPitch);
                entity.m_5616_(wrappedYaw);
                worldIn.m_143334_(entity);
                entityIn.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
            }
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).m_21255_()) {
            entityIn.m_20256_(entityIn.m_20184_().m_82542_(1.0, 0.0, 1.0));
            entityIn.m_6853_(true);
        }
        if (entityIn instanceof PathfinderMob) {
            ((PathfinderMob)entityIn).m_21573_().m_26573_();
        }
    }

    public static void performDelayedTeleport(ServerPlayer spe, Vec3 location, Vec2 rotation, ServerLevel destination, IPlayerMagic magic) {
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        set.add(RelativeMovement.X_ROT);
        set.add(RelativeMovement.Y_ROT);
        ChunkPos chunkPos = new ChunkPos(BlockPos.m_274446_((Position)location));
        destination.m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 1, (Object)spe.m_19879_());
        spe.m_8127_();
        if (spe.m_5803_()) {
            spe.m_6145_(true, true);
        }
        if (destination == spe.m_9236_()) {
            spe.f_8906_.m_9780_(location.f_82479_, location.f_82480_, location.f_82481_, rotation.f_82470_, rotation.f_82471_, set);
        } else {
            spe.m_8999_(destination, location.f_82479_, location.f_82480_, location.f_82481_, rotation.f_82470_, rotation.f_82471_);
        }
        spe.m_5616_(rotation.f_82471_);
    }

    public static void teleportEntity(Entity entity, ResourceKey<Level> destType, Vec3 destPos) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel world = entity.m_20194_().m_129880_(destType);
        if (world != null) {
            TeleportHelper.teleport(entity, world, destPos.m_7096_(), destPos.m_7098_(), destPos.m_7094_(), entity.m_146908_(), entity.m_146909_());
        } else if (entity instanceof Player) {
            ((Player)entity).m_213846_((Component)Component.m_237113_((String)"Error looking up world key. Teleport failed."));
        }
    }

    public static boolean randomTeleport(LivingEntity entity, float maxDist, int tries) {
        do {
            boolean teleported;
            double rX = entity.m_20208_((double)maxDist);
            double rY = entity.m_20227_((double)maxDist);
            double rZ = entity.m_20262_((double)maxDist);
            BlockPos.MutableBlockPos targetPos = new BlockPos.MutableBlockPos(rX, rY, rZ);
            while (targetPos.m_123342_() > 0 && !entity.m_9236_().m_8055_((BlockPos)targetPos).m_280555_()) {
                targetPos.m_122173_(Direction.DOWN);
            }
            BlockState blockstate = entity.m_9236_().m_8055_((BlockPos)targetPos);
            boolean blocksMotion = blockstate.m_280555_();
            boolean isLava = blockstate.m_60819_().m_205070_(FluidTags.f_13132_);
            if (!blocksMotion || isLava || !(teleported = entity.m_20984_(rX, rY, rZ, true))) continue;
            if (!entity.m_20067_()) {
                entity.m_9236_().m_6263_((Player)null, entity.f_19854_, entity.f_19855_, entity.f_19856_, SoundEvents.f_11852_, entity.m_5720_(), 1.0f, 1.0f);
                entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return true;
        } while (--tries >= 0);
        return false;
    }

    @Nullable
    public static ServerLevel resolveRegistryKey(ServerLevel world, ResourceKey<Level> dimension) {
        return TeleportHelper.resolveRegistryKey(world, dimension.m_135782_());
    }

    @Nullable
    public static ServerLevel resolveRegistryKey(ServerLevel world, ResourceLocation location) {
        if (world.m_46472_().m_135782_().equals((Object)location)) {
            return world;
        }
        MinecraftServer server = world.m_7654_();
        if (server == null) {
            return null;
        }
        MutableObject targetWorld = new MutableObject(null);
        server.m_129785_().iterator().forEachRemaining(sw -> {
            if (sw == null) {
                return;
            }
            if (sw.m_46472_().m_135782_().equals((Object)location)) {
                targetWorld.setValue(sw);
            }
        });
        return (ServerLevel)targetWorld.getValue();
    }

    public static Vec3 calculateBlinkPosition(double distance, LivingEntity tgt, Vec3 direction, Level world) {
        direction = direction.m_82541_();
        Vec3 motion = direction.m_82490_(distance);
        double newX = tgt.m_20185_() + motion.f_82479_;
        double newZ = tgt.m_20189_() + motion.f_82481_;
        double newY = tgt.m_20186_() + motion.f_82480_;
        if (newY < 1.0) {
            newY = 1.0;
        }
        boolean coordsValid = false;
        while (!coordsValid && distance > 0.0) {
            motion = direction.m_82490_(distance);
            newX = tgt.m_20185_() + motion.f_82479_;
            newZ = tgt.m_20189_() + motion.f_82481_;
            newY = tgt.m_20186_() + motion.f_82480_;
            if (distance < 0.0) {
                coordsValid = false;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.floor(newX), (int)newY, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.floor(newX), (int)newY, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.ceil(newX), (int)newY, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.ceil(newX), (int)newY, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.floor(newX), (int)newY - 1, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.floor(newX), (int)newY - 1, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.ceil(newX), (int)newY - 1, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.ceil(newX), (int)newY - 1, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.floor(newX), (int)newY + 1, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.floor(newX), (int)newY + 1, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.ceil(newX), (int)newY + 1, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (TeleportHelper.coordsValidForBlink(world, (int)Math.ceil(newX), (int)newY + 1, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            motion = direction.m_82490_(distance -= 1.0);
            newX = tgt.m_20185_() + motion.f_82479_;
            newZ = tgt.m_20189_() + motion.f_82481_;
            newY = tgt.m_20186_() + motion.f_82480_;
        }
        if (coordsValid) {
            return new Vec3(newX, newY, newZ);
        }
        return null;
    }

    public static boolean coordsValidForBlink(Level world, int x, int y, int z) {
        if (y < world.m_141937_()) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.m_46749_(pos)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        BlockState up = world.m_8055_(pos.m_7494_());
        return !state.m_60815_() && !up.m_60815_();
    }
}

