/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools.math;

import com.mna.tools.math.Vector3;
import com.mojang.datafixers.util.Pair;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MathUtils {
    public static float RandomBetween(float start, float end) {
        return (float)((double)start + Math.random() * (double)(end - start));
    }

    public static Vector3[] GetHorizontalBlocksInFrontOfCharacter(LivingEntity entity, int numBlocks, int x, int y, int z) {
        float speed = 0.1f;
        float factor = (float)Math.PI / 180;
        float sinYawRadians = Mth.m_14031_((float)(entity.m_146908_() * factor));
        float cosYawRadians = Mth.m_14089_((float)(entity.m_146908_() * factor));
        double motionZ = cosYawRadians * speed;
        double motionX = -sinYawRadians * speed;
        double curX = x;
        double curY = y;
        double curZ = z;
        float minimum = 0.01f;
        if (Math.abs(motionX) < (double)minimum) {
            motionX = 0.0;
        }
        if (Math.abs(motionZ) < (double)minimum) {
            motionZ = 0.0;
        }
        int lastX = x;
        int lastY = y;
        int lastZ = z;
        Vector3[] list = new Vector3[numBlocks];
        list[0] = new Vector3(x, y, z);
        int count = 1;
        while (count < numBlocks) {
            if ((int)Math.round(curX += motionX) == lastX && (int)Math.round(curY) == lastY && (int)Math.round(curZ += motionZ) == lastZ) continue;
            lastX = (int)Math.round(curX);
            lastY = (int)Math.round(curY);
            lastZ = (int)Math.round(curZ);
            list[count++] = new Vector3(lastX, lastY, lastZ);
        }
        return list;
    }

    public static Vector3[] GetBlocksInFrontOfCharacter(LivingEntity entity, int numBlocks, int x, int y, int z) {
        float speed = 0.1f;
        float factor = (float)Math.PI / 180;
        float sinYawRadians = Mth.m_14031_((float)(entity.m_146908_() * factor));
        float cosYawRadians = Mth.m_14089_((float)(entity.m_146908_() * factor));
        float sinPitchRadians = Mth.m_14031_((float)(entity.m_146909_() * factor));
        float cosPitchRadians = Mth.m_14089_((float)(entity.m_146909_() * factor));
        double motionZ = cosYawRadians * cosPitchRadians * speed;
        double motionX = -sinYawRadians * cosPitchRadians * speed;
        double motionY = -sinPitchRadians * speed;
        double curX = x;
        double curY = y;
        double curZ = z;
        float minimum = 0.01f;
        if (Math.abs(motionX) < (double)minimum) {
            motionX = 0.0;
        }
        if (Math.abs(motionY) < (double)minimum) {
            motionY = 0.0;
        }
        if (Math.abs(motionZ) < (double)minimum) {
            motionZ = 0.0;
        }
        int lastX = x;
        int lastY = y;
        int lastZ = z;
        Vector3[] list = new Vector3[numBlocks];
        list[0] = new Vector3(x, y, z);
        int count = 1;
        while (count < numBlocks) {
            if ((int)Math.round(curX += motionX) == lastX && (int)Math.round(curY += motionY) == lastY && (int)Math.round(curZ += motionZ) == lastZ) continue;
            lastX = (int)Math.round(curX);
            lastY = (int)Math.round(curY);
            lastZ = (int)Math.round(curZ);
            list[count++] = new Vector3(lastX, lastY, lastZ);
        }
        return list;
    }

    public static int getDistanceToGround(LivingEntity ent, Level world) {
        int yCoordOffset = 0;
        int distance = 0;
        while (distance < 20 && !world.m_46859_(ent.m_20183_().m_7918_(0, yCoordOffset, 0))) {
            ++distance;
            --yCoordOffset;
        }
        return distance;
    }

    public static Vec3 reflect(Vec3 incident, Vec3 reflectionNormal) {
        Vec3 rn = reflectionNormal.m_82541_();
        Vec3 i = incident.m_82541_();
        double scale = 2.0 * rn.m_82526_(i);
        return rn.m_82546_(i).m_82490_(scale);
    }

    public static float[] colorIntToFloats(int color) {
        float[] colors = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return colors;
    }

    public static int colorFloatsToInt(float r, float g, float b) {
        return ((int)(r * 255.0f) << 16) + ((int)(g * 255.0f) << 8) + (int)(b * 255.0f);
    }

    public static double clamp(double val, double min, double max) {
        return Math.max(min, Math.min(max, val));
    }

    public static double clamp01(double val) {
        return MathUtils.clamp(val, 0.0, 1.0);
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static float clamp01(float val) {
        return MathUtils.clamp(val, 0.0f, 1.0f);
    }

    public static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    public static float lerpf(float start, float end, float t) {
        return start + (end - start) * t;
    }

    public static int lerpColor(int color_1, int color_2, float t) {
        float[] a = new float[]{(float)FastColor.ARGB32.m_13655_((int)color_1) / 255.0f, (float)FastColor.ARGB32.m_13665_((int)color_1) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)color_1) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)color_1) / 255.0f};
        float[] b = new float[]{(float)FastColor.ARGB32.m_13655_((int)color_2) / 255.0f, (float)FastColor.ARGB32.m_13665_((int)color_2) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)color_2) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)color_2) / 255.0f};
        return FastColor.ARGB32.m_13660_((int)((int)(MathUtils.lerpf(a[0], b[0], t) * 255.0f)), (int)((int)(MathUtils.lerpf(a[1], b[1], t) * 255.0f)), (int)((int)(MathUtils.lerpf(a[2], b[2], t) * 255.0f)), (int)((int)(MathUtils.lerpf(a[3], b[3], t) * 255.0f)));
    }

    public static Vec3 lerpVector3d(Vec3 a, Vec3 b, float t) {
        Vec3 diff = b.m_82546_(a);
        Vec3 scaled = diff.m_82490_((double)t);
        return a.m_82549_(scaled);
    }

    public static Vec3 bezierVector3d(Vec3 start, Vec3 end, Vec3 control_1, Vec3 control_2, float time) {
        if (time < 0.0f) {
            time = 0.0f;
        } else if (time > 1.0f) {
            time = 1.0f;
        }
        float one_minus_t = 1.0f - time;
        Vec3 retValue = new Vec3(0.0, 0.0, 0.0);
        Vec3[] terms = new Vec3[]{start.m_82490_((double)(one_minus_t * one_minus_t * one_minus_t)), control_1.m_82490_((double)(3.0f * one_minus_t * one_minus_t * time)), control_2.m_82490_((double)(3.0f * one_minus_t * time * time)), end.m_82490_((double)(time * time * time))};
        for (int i = 0; i < 4; ++i) {
            retValue = retValue.m_82549_(terms[i]);
        }
        return retValue;
    }

    public static Vec3 rotateTowards(Vec3 current, Vec3 target, float maxAngleDegrees) {
        Vec3 fromDirection = current.m_82541_();
        Vec3 toDirection = target.m_82541_();
        double angleRadians = Math.acos(fromDirection.m_82526_(toDirection));
        angleRadians = Math.min(Math.max(angleRadians, (double)(-maxAngleDegrees)), (double)maxAngleDegrees);
        Vec3 axis = fromDirection.m_82537_(toDirection);
        Vector3f vec = new Vector3f((float)current.f_82479_, (float)current.f_82480_, (float)current.f_82481_);
        vec = vec.rotateAxis((float)angleRadians, (float)axis.f_82479_, (float)axis.f_82480_, (float)axis.f_82481_);
        return new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public static AABB createInclusiveBB(BlockPos a, BlockPos b) {
        AABB bb = new AABB(a, b).m_82363_(1.0, 1.0, 1.0);
        return bb;
    }

    public static boolean rotateEntityLookTowards(EntityAnchorArgument.Anchor type, LivingEntity living, Vec3 position, float maxDelta) {
        double d0 = position.m_7096_() - living.m_20185_();
        double d2 = position.m_7094_() - living.m_20189_();
        double d1 = position.f_82480_ - living.m_20188_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
        Pair<Float, Boolean> xRot = MathUtils.rotlerp(living.m_146909_(), f1, maxDelta);
        Pair<Float, Boolean> yRot = MathUtils.rotlerp(living.m_146908_(), f, maxDelta);
        living.m_146926_(((Float)xRot.getFirst()).floatValue());
        living.m_146922_(((Float)yRot.getFirst()).floatValue());
        return (Boolean)yRot.getSecond() == false;
    }

    private static Pair<Float, Boolean> rotlerp(float pAngle, float pTargetAngle, float pMaxIncrease) {
        float f = Mth.m_14177_((float)(pTargetAngle - pAngle));
        boolean clamped = false;
        if (f > pMaxIncrease) {
            f = pMaxIncrease;
            clamped = true;
        }
        if (f < -pMaxIncrease) {
            f = -pMaxIncrease;
            clamped = true;
        }
        return new Pair((Object)Float.valueOf(pAngle + f), (Object)clamped);
    }

    public static int weightedRandomNumber(int[] weights) {
        int sum_of_weight = 0;
        for (int i = 0; i < weights.length; ++i) {
            sum_of_weight += weights[i];
        }
        int target = (int)((double)sum_of_weight * Math.random());
        for (int i = 0; i < weights.length; ++i) {
            if (target <= weights[i]) {
                return i;
            }
            target -= weights[i];
        }
        return 0;
    }

    public static int weightedRandomNumber(int max) {
        int sum_of_weight = 0;
        for (int i = 0; i <= max; ++i) {
            sum_of_weight += i;
        }
        int target = (int)((double)sum_of_weight * Math.random());
        for (int i = 0; i < max; ++i) {
            if (target <= i) {
                return i;
            }
            target -= i;
        }
        return 0;
    }
}

