/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools.render;

import com.mna.ManaAndArtifice;
import com.mna.api.particles.IWorldRenderUtils;
import com.mna.api.recipes.IManaweavePattern;
import com.mna.api.tools.RLoc;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.tools.render.MARenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class WorldRenderUtils
implements IWorldRenderUtils {
    public static final WorldRenderUtils INSTANCE = new WorldRenderUtils();
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    public static final int FULL_BRIGHTNESS = 0xF000F0;

    public static void renderFlatRadiant(Entity entityIn, PoseStack pose, MultiBufferSource bufferSource, int[] innerColor, int[] outerColor, int alpha, float scale) {
        WorldRenderUtils.renderFlatRadiant(entityIn.f_19797_, pose, bufferSource, innerColor, outerColor, alpha, scale, true);
    }

    public static void renderFlatRadiant(float ageTicks, PoseStack pose, MultiBufferSource bufferSource, int[] innerColor, int[] outerColor, int alpha, float scale, boolean grow) {
        float rotationByAge = ageTicks / 100.0f;
        Random random = new Random(432L);
        VertexConsumer vertexconsumer2 = bufferSource.m_6299_(MARenderTypes.RADIANT_RENDER_TYPE);
        pose.m_85836_();
        if (grow) {
            float growth = 1.0f + scale * 25.0f;
            pose.m_85841_(growth, growth, growth);
        } else {
            pose.m_85841_(scale, scale, scale);
        }
        alpha = Math.min(alpha, 255);
        for (int i = 0; i < 20; ++i) {
            pose.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f));
            pose.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + 90.0f * rotationByAge / 5.0f));
            float hOffset = random.nextFloat() * 0.25f;
            float vOffset = random.nextFloat() * 0.25f;
            Matrix4f matrix4f = pose.m_85850_().m_252922_();
            WorldRenderUtils.vertex01(vertexconsumer2, matrix4f, innerColor, alpha);
            WorldRenderUtils.vertex2(vertexconsumer2, matrix4f, hOffset, vOffset, outerColor);
            WorldRenderUtils.vertex3(vertexconsumer2, matrix4f, hOffset, 0.0f, innerColor);
        }
        pose.m_85849_();
    }

    public static void renderRadiant(float ageTicks, PoseStack pose, MultiBufferSource bufferSource, int[] innerColor, int[] outerColor, int alpha, float scale, boolean grow) {
        float rotationByAge = ageTicks / 200.0f;
        Random random = new Random(432L);
        VertexConsumer vertexconsumer2 = bufferSource.m_6299_(MARenderTypes.RADIANT_RENDER_TYPE);
        pose.m_85836_();
        if (grow) {
            float growth = 1.0f + scale * 25.0f;
            pose.m_85841_(growth, growth, growth);
        } else {
            pose.m_85841_(scale, scale, scale);
        }
        alpha = Math.min(alpha, 64);
        for (int i = 0; i < 40; ++i) {
            pose.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
            pose.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            pose.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f));
            pose.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
            pose.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            pose.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + 90.0f * rotationByAge));
            float hOffset = i % 3 == 0 ? random.nextFloat() * 0.55f : random.nextFloat() * 0.25f;
            float vOffset = random.nextFloat() * 0.25f;
            Matrix4f matrix4f = pose.m_85850_().m_252922_();
            WorldRenderUtils.vertex01(vertexconsumer2, matrix4f, innerColor, alpha);
            WorldRenderUtils.vertex2(vertexconsumer2, matrix4f, hOffset, vOffset, outerColor);
            WorldRenderUtils.vertex3(vertexconsumer2, matrix4f, hOffset, vOffset, innerColor);
            WorldRenderUtils.vertex01(vertexconsumer2, matrix4f, innerColor, alpha);
            WorldRenderUtils.vertex3(vertexconsumer2, matrix4f, hOffset, vOffset, outerColor);
            WorldRenderUtils.vertex4(vertexconsumer2, matrix4f, hOffset, vOffset, innerColor);
            WorldRenderUtils.vertex01(vertexconsumer2, matrix4f, innerColor, alpha);
            WorldRenderUtils.vertex4(vertexconsumer2, matrix4f, hOffset, vOffset, outerColor);
            WorldRenderUtils.vertex2(vertexconsumer2, matrix4f, hOffset, vOffset, innerColor);
        }
        pose.m_85849_();
    }

    public static void renderRadiant(Entity entityIn, PoseStack pose, MultiBufferSource bufferSource, int[] innerColor, int[] outerColor, int alpha, float scale) {
        WorldRenderUtils.renderRadiant(entityIn.f_19797_, pose, bufferSource, innerColor, outerColor, alpha, scale, true);
    }

    public static void renderRadiantWithDirection(Entity entityIn, PoseStack pose, MultiBufferSource bufferSource, int[] innerColor, int[] outerColor, int alpha, float scale) {
        float rotationByAge = (float)entityIn.f_19797_ / 220.0f;
        Random random = new Random(432L);
        VertexConsumer lightingBuilder = bufferSource.m_6299_(MARenderTypes.RADIANT_RENDER_TYPE);
        pose.m_85836_();
        pose.m_252781_(Axis.f_252436_.m_252977_(entityIn.m_146908_() - 90.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(entityIn.m_146909_() + 90.0f));
        pose.m_85837_(0.0, -0.25, 0.0);
        pose.m_85841_(scale, scale * 3.0f, scale);
        for (int i = 0; i < 20; ++i) {
            pose.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f + 90.0f * rotationByAge));
            float hOffset = random.nextFloat() * 0.25f;
            float vOffset = random.nextFloat() * 0.25f;
            Matrix4f currentMatrix = pose.m_85850_().m_252922_();
            WorldRenderUtils.vertex01(lightingBuilder, currentMatrix, innerColor, alpha);
            WorldRenderUtils.vertex2(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
            WorldRenderUtils.vertex3(lightingBuilder, currentMatrix, hOffset, vOffset, innerColor);
            WorldRenderUtils.vertex01(lightingBuilder, currentMatrix, innerColor, alpha);
            WorldRenderUtils.vertex3(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
            WorldRenderUtils.vertex4(lightingBuilder, currentMatrix, hOffset, vOffset, innerColor);
            WorldRenderUtils.vertex01(lightingBuilder, currentMatrix, innerColor, alpha);
            WorldRenderUtils.vertex4(lightingBuilder, currentMatrix, hOffset, vOffset, outerColor);
            WorldRenderUtils.vertex2(lightingBuilder, currentMatrix, hOffset, vOffset, innerColor);
        }
        pose.m_85849_();
    }

    public static void renderLightRay(float ageTicks, PoseStack pose, MultiBufferSource bufferSource, int[] innerColor, int[] outerColor, int alpha, float scale, float angle) {
        Random random = new Random(432L);
        VertexConsumer vertexconsumer2 = bufferSource.m_6299_(MARenderTypes.RADIANT_RENDER_TYPE);
        alpha = Math.min(alpha, 255);
        pose.m_85836_();
        pose.m_85841_(scale, scale, scale);
        pose.m_252781_(Axis.f_252403_.m_252977_(angle));
        float hOffset = random.nextFloat() * 0.25f;
        float vOffset = random.nextFloat() * 0.25f;
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        WorldRenderUtils.vertex1(vertexconsumer2, matrix4f, innerColor, alpha);
        WorldRenderUtils.vertex2(vertexconsumer2, matrix4f, hOffset, vOffset, outerColor);
        WorldRenderUtils.vertex3(vertexconsumer2, matrix4f, hOffset, 0.0f, innerColor);
        pose.m_85849_();
    }

    public static void renderLightBeam(float ageTicks, PoseStack pose, MultiBufferSource bufferSource, int[] innerColor, int[] outerColor, int alpha, float scale, float width, float flareScale, float angle) {
        Random random = new Random(432L);
        VertexConsumer vertexconsumer2 = bufferSource.m_6299_(MARenderTypes.RADIANT_RENDER_TYPE);
        alpha = Math.min(alpha, 255);
        pose.m_85836_();
        pose.m_85841_(scale, scale, scale);
        pose.m_252781_(Axis.f_252403_.m_252977_(angle));
        float vOffset = random.nextFloat() * 0.25f;
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        vertexconsumer2.m_252986_(matrix4f, -width * flareScale, 0.0f, 0.0f).m_6122_(innerColor[0], innerColor[1], innerColor[2], alpha).m_5752_();
        vertexconsumer2.m_252986_(matrix4f, -width, vOffset, 0.0f).m_6122_(outerColor[0], outerColor[1], outerColor[2], 0).m_5752_();
        vertexconsumer2.m_252986_(matrix4f, width, vOffset, 0.0f).m_6122_(outerColor[0], outerColor[1], outerColor[2], 0).m_5752_();
        vertexconsumer2.m_252986_(matrix4f, width * flareScale, 0.0f, 0.0f).m_6122_(innerColor[0], innerColor[1], innerColor[2], alpha).m_5752_();
        pose.m_85849_();
    }

    public static void renderBeam(Level world, float partialTicks, PoseStack pose, MultiBufferSource bufferSource, int packedLight, Vec3 start, Vec3 end, float lengthPct, int[] color, RenderType renderType) {
        WorldRenderUtils.renderBeam(world, partialTicks, pose, bufferSource, packedLight, start, end, lengthPct, color, 0.01f, renderType);
    }

    public static void renderBeam(Level world, float partialTicks, PoseStack pose, MultiBufferSource bufferSource, int packedLight, Vec3 start, Vec3 end, float lengthPct, int[] color, float width, RenderType renderType) {
        WorldRenderUtils.renderBeam(world, partialTicks, pose, bufferSource, packedLight, start, end, lengthPct, color, 176, width, renderType);
    }

    public static void renderBeam(Level world, float partialTicks, PoseStack pose, MultiBufferSource bufferSource, int packedLight, Vec3 start, Vec3 end, float lengthPct, int[] color, int alpha, float width, RenderType renderType) {
        float worldPartialTicks = (float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks;
        float uvSlideRate = worldPartialTicks * 0.1f % 1.0f;
        Vec3 direction = end.m_82546_(start);
        float beamLength = (float)direction.m_82553_() * lengthPct;
        direction = direction.m_82541_();
        float aCosDirectionY = (float)Math.acos(direction.f_82480_);
        float atan2DirectionXZ = (float)Math.atan2(direction.f_82481_, direction.f_82479_);
        float rotation = 0.0f;
        int red = color[0];
        int green = color[1];
        int blue = color[2];
        float beamWidth = width;
        float x1Start = Mth.m_14089_((float)(rotation + (float)Math.PI)) * beamWidth;
        float x1End = Mth.m_14089_((float)rotation) * beamWidth;
        float y1Start = Mth.m_14031_((float)(rotation + (float)Math.PI)) * beamWidth;
        float y1End = Mth.m_14031_((float)rotation) * beamWidth;
        float x2Start = Mth.m_14089_((float)(rotation + 1.5707964f)) * beamWidth;
        float x2End = Mth.m_14089_((float)(rotation + 4.712389f)) * beamWidth;
        float y2Start = Mth.m_14031_((float)(rotation + 1.5707964f)) * beamWidth;
        float y2End = Mth.m_14031_((float)(rotation + 4.712389f)) * beamWidth;
        float vSlide = -1.0f - uvSlideRate;
        float f30 = beamLength * 2.5f + vSlide;
        pose.m_85836_();
        pose.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - atan2DirectionXZ) * 57.295776f));
        pose.m_252781_(Axis.f_252529_.m_252977_(aCosDirectionY * 57.295776f));
        VertexConsumer vertexBuilder = bufferSource.m_6299_(renderType);
        PoseStack.Pose activeStack = pose.m_85850_();
        Matrix4f renderMatrix = activeStack.m_252922_();
        Matrix3f normalMatrix = activeStack.m_252943_();
        float uMin = 0.05f;
        float uMax = 0.95f;
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x1Start, beamLength, y1Start, red, green, blue, alpha, uMax, f30);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x1Start, 0.0f, y1Start, red, green, blue, alpha, uMax, vSlide);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x1End, 0.0f, y1End, red, green, blue, alpha, uMin, vSlide);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x1End, beamLength, y1End, red, green, blue, alpha, uMin, f30);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x2Start, beamLength, y2Start, red, green, blue, alpha, uMax, f30);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x2Start, 0.0f, y2Start, red, green, blue, alpha, uMax, vSlide);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x2End, 0.0f, y2End, red, green, blue, alpha, uMin, vSlide);
        WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, x2End, beamLength, y2End, red, green, blue, alpha, uMin, f30);
        pose.m_85849_();
    }

    public static void renderManaweavePatternNoTransparent(ManaweavingPattern pattern, Quaternionf rotation, PoseStack pose, MultiBufferSource bufferSource, boolean inventory) {
        WorldRenderUtils.renderManaweavePattern_internal(pattern, rotation, pose, bufferSource, inventory, RenderType.m_110452_((ResourceLocation)RLoc.create("textures/particle/sparkle.png")), new int[]{109, 227, 220, 176});
    }

    public static void renderManaweavePatternNoTransparent(ManaweavingPattern pattern, Quaternionf rotation, PoseStack pose, MultiBufferSource bufferSource, boolean inventory, int[] color) {
        WorldRenderUtils.renderManaweavePattern_internal(pattern, rotation, pose, bufferSource, inventory, RenderType.m_110452_((ResourceLocation)RLoc.create("textures/particle/sparkle.png")), color);
    }

    public static void renderManaweavePattern(IManaweavePattern pattern, Quaternionf rotation, PoseStack pose, MultiBufferSource bufferSource, boolean inventory) {
        WorldRenderUtils.renderManaweavePattern_internal(pattern, rotation, pose, bufferSource, inventory, MARenderTypes.RENDER_TYPE_MANAWEAVE, new int[]{109, 227, 220, 176});
    }

    public static void renderManaweavePattern(IManaweavePattern pattern, Quaternionf rotation, PoseStack pose, MultiBufferSource bufferSource, boolean inventory, int[] color) {
        WorldRenderUtils.renderManaweavePattern_internal(pattern, rotation, pose, bufferSource, inventory, MARenderTypes.RENDER_TYPE_MANAWEAVE, color);
    }

    public static void renderManaweavePattern_internal(IManaweavePattern pattern, Quaternionf rotation, PoseStack pose, MultiBufferSource bufferSource, boolean inventory, RenderType renderType, int[] color) {
        byte[][] points = pattern.get();
        float offsetX = (float)points.length / 2.0f;
        float offsetY = (float)points[0].length / 2.0f;
        float baseScale = 0.15f;
        pose.m_85836_();
        pose.m_252880_(0.0f, 2.0f, 0.0f);
        pose.m_252781_(rotation);
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pose.m_85837_(-3.6 * (double)baseScale, -3.6 * (double)baseScale, 0.0);
        pose.m_85841_(baseScale, baseScale, baseScale);
        PoseStack.Pose pose$entry = pose.m_85850_();
        Matrix4f renderMatrix = pose$entry.m_252922_();
        Matrix3f normalMatrix = pose$entry.m_252943_();
        VertexConsumer vertexBuilder = bufferSource.m_6299_(renderType);
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                if (points[i][j] != 1) continue;
                float originX = offsetX - (float)j * 0.5f;
                float originY = offsetY - (float)i * 0.5f;
                WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 0.0f + originY, 0.0f, color[0], color[1], color[2], color[3], 0.0f, 1.0f);
                WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 0.0f + originY, 0.0f, color[0], color[1], color[2], color[3], 1.0f, 1.0f);
                WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, 1.0f + originX, 1.0f + originY, 0.0f, color[0], color[1], color[2], color[3], 1.0f, 0.0f);
                WorldRenderUtils.createVertex(vertexBuilder, renderMatrix, normalMatrix, 0.0f + originX, 1.0f + originY, 0.0f, color[0], color[1], color[2], color[3], 0.0f, 0.0f);
            }
        }
        pose.m_85849_();
    }

    public static void renderProgressBar(PoseStack pose, MultiBufferSource bufferSource, float percent, int[] rgb, int alpha) {
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        Matrix3f normalMatrix = pose.m_85850_().m_252943_();
        VertexConsumer vertexconsumer = bufferSource.m_6299_(MARenderTypes.SOLID_RENDER_TYPE);
        vertexconsumer.m_252986_(matrix4f, 0.5f, -0.5f, 0.0f).m_6122_(rgb[0], rgb[1], rgb[2], alpha).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexconsumer.m_252986_(matrix4f, 0.5f - percent, -0.5f, 0.0f).m_6122_(rgb[0], rgb[1], rgb[2], alpha).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexconsumer.m_252986_(matrix4f, 0.5f - percent, 0.5f, 0.0f).m_6122_(rgb[0], rgb[1], rgb[2], alpha).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexconsumer.m_252986_(matrix4f, 0.5f, 0.5f, 0.0f).m_6122_(rgb[0], rgb[1], rgb[2], alpha).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private static void vertex01(VertexConsumer vertexConsumer, Matrix4f renderMatrix, int[] rgb, int alpha) {
        vertexConsumer.m_252986_(renderMatrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_5752_();
        vertexConsumer.m_252986_(renderMatrix, 0.0f, 0.0f, 0.0f).m_6122_(rgb[0], rgb[1], rgb[2], alpha).m_5752_();
    }

    private static void vertex1(VertexConsumer vertexConsumer, Matrix4f renderMatrix, int[] rgb, int alpha) {
        vertexConsumer.m_252986_(renderMatrix, 0.0f, 0.0f, 0.0f).m_6122_(rgb[0], rgb[1], rgb[2], alpha).m_5752_();
        vertexConsumer.m_252986_(renderMatrix, 0.0f, 0.0f, 0.0f).m_6122_(rgb[0], rgb[1], rgb[2], alpha).m_5752_();
    }

    private static void vertex2(VertexConsumer vertexConsumer, Matrix4f renderMatrix, float y, float length, int[] rgb) {
        vertexConsumer.m_252986_(renderMatrix, -HALF_SQRT_3 * length, y, -0.2f * length).m_6122_(rgb[0], rgb[1], rgb[2], 0).m_5752_();
    }

    private static void vertex3(VertexConsumer vertexConsumer, Matrix4f renderMatrix, float y, float length, int[] rgb) {
        vertexConsumer.m_252986_(renderMatrix, HALF_SQRT_3 * length, y, -0.2f * length).m_6122_(rgb[0], rgb[1], rgb[2], 0).m_5752_();
    }

    private static void vertex4(VertexConsumer vertexConsumer, Matrix4f renderMatrix, float y, float length, int[] rgb) {
        vertexConsumer.m_252986_(renderMatrix, 0.0f, y, 1.0f * length).m_6122_(rgb[0], rgb[1], rgb[2], 0).m_5752_();
    }

    private static void createVertex(VertexConsumer vertexBuilder, Matrix4f renderMatrix, Matrix3f normalMatrix, float x, float y, float z, int colorRed, int colorGreen, int colorBlue, int alpha, float u, float v) {
        vertexBuilder.m_252986_(renderMatrix, x, y, z).m_6122_(colorRed, colorGreen, colorBlue, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 1.0f, 0.0f, 0.0f).m_5752_();
    }

    @Override
    public void radiant(Entity entityIn, PoseStack pose, MultiBufferSource bufferSource, int[] innerColor, int[] outerColor, int alpha, float scale) {
        WorldRenderUtils.renderRadiant(entityIn, pose, bufferSource, innerColor, outerColor, alpha, scale);
    }

    @Override
    public void radiant(float ageTicks, PoseStack pose, MultiBufferSource bufferSource, int[] innerColor, int[] outerColor, int alpha, float scale, boolean grow) {
        WorldRenderUtils.renderRadiant(ageTicks, pose, bufferSource, innerColor, outerColor, alpha, scale, grow);
    }

    @Override
    public void directionalRadiant(Entity entityIn, PoseStack pose, MultiBufferSource bufferSource, int[] innerColor, int[] outerColor, int alpha, float scale) {
        WorldRenderUtils.renderRadiantWithDirection(entityIn, pose, bufferSource, innerColor, outerColor, alpha, scale);
    }

    @Override
    public void beam(Level world, float partialTicks, PoseStack pose, MultiBufferSource bufferSource, int packedLight, Vec3 start, Vec3 end, float lengthPct, int[] color, float width, RenderType renderType) {
        WorldRenderUtils.renderBeam(world, partialTicks, pose, bufferSource, packedLight, start, end, lengthPct, color, renderType);
    }

    @Override
    public void beam(Level world, float partialTicks, PoseStack pose, MultiBufferSource bufferSource, int packedLight, Vec3 start, Vec3 end, float lengthPct, int[] color, int alpha, float width, RenderType renderType) {
        WorldRenderUtils.renderBeam(world, partialTicks, pose, bufferSource, packedLight, start, end, lengthPct, color, renderType);
    }

    @Override
    public void beam(Level world, float partialTicks, PoseStack pose, MultiBufferSource bufferSource, int packedLight, Vec3 start, Vec3 end, float lengthPct, int[] color, RenderType renderType) {
        WorldRenderUtils.renderBeam(world, partialTicks, pose, bufferSource, packedLight, start, end, lengthPct, color, packedLight, lengthPct, renderType);
    }

    @Override
    public void manaweavePattern(ManaweavingPattern pattern, Quaternionf rotation, PoseStack pose, MultiBufferSource bufferSource, boolean inventory) {
        WorldRenderUtils.renderManaweavePattern(pattern, rotation, pose, bufferSource, inventory);
    }

    @Override
    public void manaweavePattern(ManaweavingPattern pattern, Quaternionf rotation, PoseStack pose, MultiBufferSource bufferSource, boolean inventory, int[] color) {
        WorldRenderUtils.renderManaweavePattern(pattern, rotation, pose, bufferSource, inventory, color);
    }

    @Override
    public void manaweavePatternNoTransparent(ManaweavingPattern pattern, Quaternionf rotation, PoseStack pose, MultiBufferSource bufferSource, boolean inventory) {
        WorldRenderUtils.renderManaweavePatternNoTransparent(pattern, rotation, pose, bufferSource, inventory);
    }

    @Override
    public void manaweavePatternNoTransparent(ManaweavingPattern pattern, Quaternionf rotation, PoseStack pose, MultiBufferSource bufferSource, boolean inventory, int[] color) {
        WorldRenderUtils.renderManaweavePatternNoTransparent(pattern, rotation, pose, bufferSource, inventory, color);
    }
}

