/*
 * Decompiled with CFR 0.152.
 */
package com.mna.villagers;

import com.mna.api.tools.RLoc;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mna")
public class VillageStructures {
    private static Registry<StructureTemplatePool> templatePoolRegistry;
    private static Registry<StructureProcessorList> processorListRegistry;
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY;

    @SubscribeEvent
    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        templatePoolRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        processorListRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_257011_).orElseThrow();
        VillageStructures.registerDesertVillageStructure(RLoc.create("village/desert/spellmonger"), 4);
        VillageStructures.registerDesertVillageStructure(RLoc.create("village/desert/manaweaver"), 2);
        VillageStructures.registerDesertVillageStructure(RLoc.create("village/desert/runeforge_and_runescribe"), 2);
        VillageStructures.registerDesertVillageStructure(RLoc.create("village/desert/runescribe"), 2);
        VillageStructures.registerPlainsVillageStructure(RLoc.create("village/plains/spellmonger"), 4);
        VillageStructures.registerPlainsVillageStructure(RLoc.create("village/plains/manaweaver"), 2);
        VillageStructures.registerPlainsVillageStructure(RLoc.create("village/plains/runeforge_and_runescribe"), 2);
        VillageStructures.registerPlainsVillageStructure(RLoc.create("village/plains/runescribe"), 2);
        VillageStructures.registerSavannaVillageStructure(RLoc.create("village/savanna/spellmonger"), 4);
        VillageStructures.registerSavannaVillageStructure(RLoc.create("village/savanna/manaweaver"), 2);
        VillageStructures.registerSavannaVillageStructure(RLoc.create("village/savanna/runeforge_and_runescribe"), 2);
        VillageStructures.registerSavannaVillageStructure(RLoc.create("village/savanna/runescribe"), 2);
        VillageStructures.registerSnowyVillageStructure(RLoc.create("village/snowy/spellmonger"), 4);
        VillageStructures.registerSnowyVillageStructure(RLoc.create("village/snowy/manaweaver"), 2);
        VillageStructures.registerSnowyVillageStructure(RLoc.create("village/snowy/runeforge_and_runescribe"), 2);
        VillageStructures.registerSnowyVillageStructure(RLoc.create("village/snowy/runescribe"), 2);
        VillageStructures.registerTaigaVillageStructure(RLoc.create("village/taiga/spellmonger"), 4);
        VillageStructures.registerTaigaVillageStructure(RLoc.create("village/taiga/manaweaver"), 2);
        VillageStructures.registerTaigaVillageStructure(RLoc.create("village/taiga/runeforge_and_runescribe"), 2);
        VillageStructures.registerTaigaVillageStructure(RLoc.create("village/taiga/runescribe"), 2);
    }

    private static void registerTaigaVillageStructure(ResourceLocation pieceNBTLocation, int weight) {
        VillageStructures.addBuildingToPool(new ResourceLocation("village/taiga/houses"), pieceNBTLocation, weight);
    }

    private static void registerDesertVillageStructure(ResourceLocation pieceNBTLocation, int weight) {
        VillageStructures.addBuildingToPool(new ResourceLocation("village/desert/houses"), pieceNBTLocation, weight);
    }

    private static void registerSavannaVillageStructure(ResourceLocation pieceNBTLocation, int weight) {
        VillageStructures.addBuildingToPool(new ResourceLocation("village/savanna/houses"), pieceNBTLocation, weight);
    }

    private static void registerSnowyVillageStructure(ResourceLocation pieceNBTLocation, int weight) {
        VillageStructures.addBuildingToPool(new ResourceLocation("village/snowy/houses"), pieceNBTLocation, weight);
    }

    private static void registerPlainsVillageStructure(ResourceLocation pieceNBTLocation, int weight) {
        VillageStructures.addBuildingToPool(new ResourceLocation("village/plains/houses"), pieceNBTLocation, weight);
    }

    private static void addBuildingToPool(ResourceLocation poolRL, ResourceLocation nbtPieceRL, int weight) {
        Holder.Reference emptyProcessorList = processorListRegistry.m_246971_(EMPTY_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)nbtPieceRL.toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }

    static {
        EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));
    }
}

