/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.block.HedgeBlock;
import org.violetmoon.quark.content.world.module.AncientWoodModule;
import org.violetmoon.quark.content.world.module.BlossomTreesModule;
import org.violetmoon.zeta.block.ZetaSaplingBlock;
import org.violetmoon.zeta.client.AlikeColorHandler;
import org.violetmoon.zeta.client.event.load.ZAddBlockColorHandlers;
import org.violetmoon.zeta.client.event.load.ZAddItemColorHandlers;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.VanillaWoods;

@ZetaLoadModule(category="building")
public class HedgesModule
extends ZetaModule {
    public static TagKey<Block> hedgesTag;

    @LoadEvent
    public final void register(ZRegister event) {
        for (VanillaWoods.Wood wood : VanillaWoods.OVERWORLD_WITH_TREE) {
            new HedgeBlock(wood.name() + "_hedge", this, wood.fence(), wood.leaf());
        }
        new HedgeBlock("azalea_hedge", this, Blocks.f_50132_, Blocks.f_152470_);
        new HedgeBlock("flowering_azalea_hedge", this, Blocks.f_50132_, Blocks.f_152471_);
    }

    @LoadEvent
    public void postRegister(ZRegister.Post e) {
        for (BlossomTreesModule.BlossomTree tree : BlossomTreesModule.blossomTrees) {
            new HedgeBlock(tree.name + "_hedge", this, BlossomTreesModule.woodSet.fence, (Block)tree.leaves).setCondition(() -> ((ZetaSaplingBlock)tree.sapling).isEnabled());
        }
        new HedgeBlock("ancient_hedge", this, AncientWoodModule.woodSet.fence, AncientWoodModule.ancient_leaves).setCondition(() -> Quark.ZETA.modules.isEnabled(AncientWoodModule.class));
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        hedgesTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "hedges"));
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends HedgesModule {
        @LoadEvent
        public void blockColorProviders(ZAddBlockColorHandlers event) {
            event.registerNamed(b -> new AlikeColorHandler((Block)((HedgeBlock)((Object)b)), HedgeBlock::getLeaf), new String[]{"hedge"});
        }

        @LoadEvent
        public void itemColorProviders(ZAddItemColorHandlers event) {
            event.registerNamed(i -> new AlikeColorHandler(i, HedgeBlock::getLeaf), new String[]{"hedge"});
        }
    }
}

