/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.content.building.block.VariantChestBlock;
import org.violetmoon.quark.content.building.block.VariantTrappedChestBlock;
import org.violetmoon.quark.content.building.block.be.VariantChestBlockEntity;
import org.violetmoon.quark.content.building.block.be.VariantTrappedChestBlockEntity;
import org.violetmoon.quark.content.building.client.render.be.VariantChestRenderer;
import org.violetmoon.quark.content.building.recipe.MixedExclusionRecipe;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorAbstractChestedHorse;
import org.violetmoon.zeta.client.SimpleWithoutLevelRenderer;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.ZEntityJoinLevel;
import org.violetmoon.zeta.event.play.entity.living.ZLivingDeath;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerInteract;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.BooleanSuppliers;
import org.violetmoon.zeta.util.VanillaWoods;
import org.violetmoon.zeta.util.handler.StructureBlockReplacementHandler;

@ZetaLoadModule(category="building", antiOverlap={"woodworks"})
public class VariantChestsModule
extends ZetaModule {
    @Config(flag="chest_reversion")
    private static boolean enableRevertingWoodenChests = true;
    protected final List<Block> regularChests = new ArrayList<Block>();
    protected final List<Block> trappedChests = new ArrayList<Block>();
    public static BlockEntityType<VariantChestBlockEntity> chestTEType;
    public static BlockEntityType<VariantTrappedChestBlockEntity> trappedChestTEType;
    @Config
    protected boolean replaceWorldgenChests = true;
    @Config(description="Chests to put in structures. It's preferred to use worldgen tags for this. The format per entry is \"structure=chest\", where \"structure\" is a structure ID, and \"chest\" is a block ID, which must correspond to a standard chest block.")
    public List<String> structureChests = new ArrayList<String>();
    protected final Map<ResourceLocation, Block> manualChestMappings = new HashMap<ResourceLocation, Block>();
    protected final Map<ResourceLocation, Block> manualTrappedChestMappings = new HashMap<ResourceLocation, Block>();
    protected final Map<TagKey<Structure>, Block> chestMappings = new HashMap<TagKey<Structure>, Block>();
    protected final Map<TagKey<Structure>, Block> trappedChestMappings = new HashMap<TagKey<Structure>, Block>();
    private static final String DONK_CHEST = "Quark:DonkChest";
    private static final ThreadLocal<ItemStack> WAIT_TO_REPLACE_CHEST;

    @LoadEvent
    public final void register(ZRegister event) {
        event.getRegistry().register(MixedExclusionRecipe.SERIALIZER, "mixed_exclusion", Registries.f_256764_);
        for (VanillaWoods.Wood s : VanillaWoods.ALL) {
            this.makeChestBlocks(s.name(), Blocks.f_50087_, s.soundPlanks());
        }
        this.makeChestBlocks("nether_brick", Blocks.f_50197_, null);
        this.makeChestBlocks("purpur", Blocks.f_50492_, null);
        this.makeChestBlocks("prismarine", Blocks.f_50377_, null);
        CreativeTabManager.daisyChain();
        for (Block regularChest : this.regularChests) {
            CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.f_256791_, (ItemLike)regularChest, (ItemLike)Blocks.f_50087_, (boolean)false);
        }
        CreativeTabManager.endDaisyChain();
        CreativeTabManager.daisyChain();
        for (Block trappedChest : this.trappedChests) {
            CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.f_257028_, (ItemLike)trappedChest, (ItemLike)Blocks.f_50325_, (boolean)false);
        }
        CreativeTabManager.endDaisyChain();
        StructureBlockReplacementHandler.addReplacement(this::getGenerationChestBlockState);
    }

    private void makeChestBlocks(String name, Block base, @Nullable SoundType sound) {
        this.makeChestBlocks(this, name, base, sound, BooleanSuppliers.TRUE);
    }

    private void makeChestBlocks(ZetaModule module, String name, Block base, @Nullable SoundType sound, BooleanSupplier condition) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60926_((BlockBehaviour)base);
        if (sound != null) {
            props = props.m_60918_(sound);
        }
        VariantChestBlock regularChest = new VariantChestBlock(name, module, () -> chestTEType, props).setCondition(condition);
        this.regularChests.add((Block)regularChest);
        this.chestMappings.put((TagKey<Structure>)TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("quark", name + "_chest_structures")), (Block)regularChest);
        VariantTrappedChestBlock trappedChest = new VariantTrappedChestBlock(name, module, () -> trappedChestTEType, props).setCondition(condition);
        this.trappedChests.add((Block)trappedChest);
        this.trappedChestMappings.put((TagKey<Structure>)TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("quark", name + "_chest_structures")), (Block)trappedChest);
        Quark.LOOTR_INTEGRATION.makeChestBlocks(module, name, base, condition, (Block)regularChest, (Block)trappedChest);
    }

    public static void makeChestBlocksExternal(ZetaModule module, String name, Block base, @Nullable SoundType sound, BooleanSupplier condition) {
        VariantChestsModule me = (VariantChestsModule)Quark.ZETA.modules.get(VariantChestsModule.class);
        me.makeChestBlocks(module, name, base, sound, () -> me.enabled && condition.getAsBoolean());
    }

    @LoadEvent
    public void postRegister(ZRegister.Post e) {
        chestTEType = BlockEntityType.Builder.m_155273_(VariantChestBlockEntity::new, (Block[])this.regularChests.toArray(new Block[0])).m_58966_(null);
        trappedChestTEType = BlockEntityType.Builder.m_155273_(VariantTrappedChestBlockEntity::new, (Block[])this.trappedChests.toArray(new Block[0])).m_58966_(null);
        Quark.ZETA.registry.register(chestTEType, "variant_chest", Registries.f_256922_);
        Quark.ZETA.registry.register(trappedChestTEType, "variant_trapped_chest", Registries.f_256922_);
        Quark.LOOTR_INTEGRATION.postRegister();
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        this.manualChestMappings.clear();
        this.manualTrappedChestMappings.clear();
        ArrayList<String> chestsClone = new ArrayList<String>(this.structureChests);
        for (String s : chestsClone) {
            String[] toks = s.split("=");
            if (toks.length != 2) continue;
            String left = toks[0];
            String right = toks[1];
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(right));
            if (block == Blocks.f_50016_) continue;
            this.manualChestMappings.put(new ResourceLocation(left), block);
            if (!this.regularChests.contains(block)) continue;
            Block trapped = this.trappedChests.get(this.regularChests.indexOf(block));
            this.manualTrappedChestMappings.put(new ResourceLocation(left), trapped);
        }
    }

    private BlockState getGenerationChestBlockState(ServerLevelAccessor accessor, BlockState current, StructureBlockReplacementHandler.StructureHolder structure) {
        if (this.enabled && this.replaceWorldgenChests) {
            if (current.m_60734_() == Blocks.f_50087_) {
                return this.replaceChestState(accessor, current, structure, this.chestMappings, this.manualChestMappings);
            }
            if (current.m_60734_() == Blocks.f_50325_) {
                return this.replaceChestState(accessor, current, structure, this.trappedChestMappings, this.manualTrappedChestMappings);
            }
        }
        return null;
    }

    @Nullable
    private BlockState replaceChestState(ServerLevelAccessor accessor, BlockState current, StructureBlockReplacementHandler.StructureHolder structure, Map<TagKey<Structure>, Block> mappings, Map<ResourceLocation, Block> manualMappings) {
        Holder structureHolder = StructureBlockReplacementHandler.getStructure((ServerLevelAccessor)accessor, (StructureBlockReplacementHandler.StructureHolder)structure);
        if (structureHolder != null) {
            for (TagKey<Structure> structureTagKey : mappings.keySet()) {
                if (!structureHolder.m_203656_(structureTagKey)) continue;
                Block block = mappings.get(structureTagKey);
                return block.m_152465_(current);
            }
            Optional<Block> manualMapping = structureHolder.m_203543_().map(ResourceKey::m_135782_).map(manualMappings::get);
            if (manualMapping.isPresent()) {
                return manualMapping.get().m_152465_(current);
            }
        }
        return null;
    }

    @PlayEvent
    public void onClickEntity(ZPlayerInteract.EntityInteractSpecific event) {
        AbstractChestedHorse horse;
        Entity target = event.getTarget();
        Player player = event.getEntity();
        ItemStack held = player.m_21120_(event.getHand());
        if (!held.m_41619_() && target instanceof AbstractChestedHorse && !(horse = (AbstractChestedHorse)target).m_30502_() && held.m_41720_() != Items.f_42009_ && held.m_204117_(Tags.Items.CHESTS_WOODEN)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_));
            if (!target.m_9236_().f_46443_) {
                ItemStack copy = held.m_41777_();
                copy.m_41764_(1);
                held.m_41774_(1);
                horse.getPersistentData().m_128365_(DONK_CHEST, (Tag)copy.serializeNBT());
                horse.m_30504_(true);
                horse.m_30625_();
                ((AccessorAbstractChestedHorse)horse).quark$playChestEquipsSound();
            }
        }
    }

    @PlayEvent
    public void onDeath(ZLivingDeath event) {
        AbstractChestedHorse horse;
        ItemStack chest;
        Entity target = event.getEntity();
        if (target instanceof AbstractChestedHorse && !(chest = ItemStack.m_41712_((CompoundTag)(horse = (AbstractChestedHorse)target).getPersistentData().m_128469_(DONK_CHEST))).m_41619_() && horse.m_30502_()) {
            WAIT_TO_REPLACE_CHEST.set(chest);
        }
    }

    @PlayEvent
    public void onEntityJoinWorld(ZEntityJoinLevel event) {
        ItemEntity item;
        Entity target = event.getEntity();
        if (target instanceof ItemEntity && (item = (ItemEntity)target).m_32055_().m_41720_() == Items.f_42009_) {
            ItemStack local = WAIT_TO_REPLACE_CHEST.get();
            if (local != null && !local.m_41619_()) {
                ((ItemEntity)target).m_32045_(local);
            }
            WAIT_TO_REPLACE_CHEST.remove();
        }
    }

    static {
        WAIT_TO_REPLACE_CHEST = new ThreadLocal();
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends VariantChestsModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            BlockEntityRenderers.m_173590_((BlockEntityType)chestTEType, ctx -> new VariantChestRenderer(ctx, false));
            BlockEntityRenderers.m_173590_((BlockEntityType)trappedChestTEType, ctx -> new VariantChestRenderer(ctx, true));
            for (Block b : this.regularChests) {
                QuarkClient.ZETA_CLIENT.setBlockEntityWithoutLevelRenderer(b.m_5456_(), (BlockEntityWithoutLevelRenderer)new SimpleWithoutLevelRenderer(chestTEType, b.m_49966_()));
            }
            for (Block b : this.trappedChests) {
                QuarkClient.ZETA_CLIENT.setBlockEntityWithoutLevelRenderer(b.m_5456_(), (BlockEntityWithoutLevelRenderer)new SimpleWithoutLevelRenderer(trappedChestTEType, b.m_49966_()));
            }
            QuarkClient.LOOTR_INTEGRATION.clientSetup(event);
        }
    }

    public static interface IVariantChest {
        public String getTexturePath();

        default public String getTextureFolder() {
            return "quark_variant_chests";
        }
    }
}

