/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.module;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.violetmoon.quark.content.experimental.hax.PseudoAccessorMerchantOffer;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorMerchantOffer;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.entity.living.ZLivingConversion;
import org.violetmoon.zeta.event.play.entity.living.ZLivingTick;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="experimental", enabledByDefault=false)
public class VillagerRerollingReworkModule
extends ZetaModule {
    public static final String TAG_VILLAGER_SEED = "quark:MerchantInitialSeed";
    public static final String TAG_ITEMS_REROLLED_TODAY = "quark:RerolledItemsToday";
    public static final String TAG_TRADE_TIER = "quark:tier";
    public static boolean staticEnabled;
    @Config(description="If enabled, the first two trades a villager generates for a profession will always be the same for a given villager.\nThis prevents repeatedly placing down a job site block to reroll the villager's trades.")
    public static boolean seedInitialVillagerTrades;
    @Config(description="Set to 0 to disable the chance to reroll trades when restocking.\nIt's possible for a trade to not restock even when the chance is 1. This happens when the rerolled trade is one the villager already has.\nThis chance only guarantees a reroll will be attempted.")
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double chanceToRerollWhenRestocking;
    @Config(description="Set to 0 to disable the chance to reroll trades when restocking. Set to -1 to allow unlimited rerolling.\nTrades earlier in the list will restock first.")
    public static int maximumRestocksPerDay;
    @Config(description="If enabled, villagers will reroll when they restock, rather than when they begin work for the day.\nIf disabled, players can prevent rerolling by ensuring the villager isn't out of stock on their last restock of the day.")
    public static boolean rerollOnAnyRestock;
    @Config(description="If enabled, villagers will be able to reroll any trade that has been used AT ALL since the last restock.")
    public static boolean rerollEvenIfNotOutOfStock;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
    }

    @PlayEvent
    public void assignSeedIfUnassigned(ZLivingTick event) {
        CompoundTag persistent;
        LivingEntity entity = event.getEntity();
        if (VillagerRerollingReworkModule.canUseSeededRandom(entity) && !(persistent = entity.getPersistentData()).m_128425_(TAG_VILLAGER_SEED, 4)) {
            persistent.m_128356_(TAG_VILLAGER_SEED, entity.m_217043_().m_188505_());
        }
    }

    @PlayEvent
    public void keepSeedOnConversion(ZLivingConversion.Post event) {
        CompoundTag persistent;
        LivingEntity original = event.getEntity();
        LivingEntity outcome = event.getOutcome();
        if ((VillagerRerollingReworkModule.canUseSeededRandom(original) || VillagerRerollingReworkModule.canUseSeededRandom(outcome)) && (persistent = original.getPersistentData()).m_128425_(TAG_VILLAGER_SEED, 4)) {
            outcome.getPersistentData().m_128356_(TAG_VILLAGER_SEED, persistent.m_128454_(TAG_VILLAGER_SEED));
        }
    }

    public static void clearRerolls(Villager villager) {
        villager.getPersistentData().m_128473_(TAG_ITEMS_REROLLED_TODAY);
    }

    public static void attemptToReroll(Villager villager) {
        if (!staticEnabled || maximumRestocksPerDay == 0 || chanceToRerollWhenRestocking == 0.0) {
            return;
        }
        int restocks = villager.getPersistentData().m_128451_(TAG_ITEMS_REROLLED_TODAY);
        if (restocks >= maximumRestocksPerDay && maximumRestocksPerDay > 0) {
            return;
        }
        MerchantOffers offers = villager.m_6616_();
        for (int i = 0; i < offers.size(); ++i) {
            MerchantOffer rerolled;
            MerchantOffer offer = (MerchantOffer)offers.get(i);
            if ((!rerollEvenIfNotOutOfStock || offer.m_45371_() <= 0) && !offer.m_45380_() || (rerolled = VillagerRerollingReworkModule.attemptToReroll(villager, offer)) == null) continue;
            boolean foundEquivalent = false;
            for (MerchantOffer otherOffer : offers) {
                if (!ItemStack.m_150942_((ItemStack)otherOffer.m_45352_(), (ItemStack)rerolled.m_45352_()) || !ItemStack.m_150942_((ItemStack)otherOffer.m_45364_(), (ItemStack)rerolled.m_45364_()) || !ItemStack.m_150942_((ItemStack)otherOffer.m_45368_(), (ItemStack)rerolled.m_45368_())) continue;
                foundEquivalent = true;
                break;
            }
            if (foundEquivalent) continue;
            rerolled.m_45353_(offer.m_45377_());
            ((AccessorMerchantOffer)rerolled).quark$setRewardExp(rerolled.m_45383_() && offer.m_45383_());
            offers.set(i, (Object)rerolled);
            if (++restocks >= maximumRestocksPerDay && maximumRestocksPerDay > 0) break;
        }
        if (maximumRestocksPerDay > 0) {
            villager.getPersistentData().m_128405_(TAG_ITEMS_REROLLED_TODAY, restocks);
        }
    }

    public static MerchantOffer attemptToReroll(Villager villager, MerchantOffer original) {
        VillagerTrades.ItemListing listing;
        MerchantOffer newOffer;
        VillagerTrades.ItemListing[] listings;
        VillagerData data;
        Int2ObjectMap trades;
        if (((PseudoAccessorMerchantOffer)original).quark$getTier() > 5) {
            return null;
        }
        if (villager.m_217043_().m_188500_() >= chanceToRerollWhenRestocking) {
            return null;
        }
        int tier = ((PseudoAccessorMerchantOffer)original).quark$getTier();
        if (tier >= 0 && tier <= 5 && (trades = (Int2ObjectMap)VillagerTrades.f_35627_.get((data = villager.m_7141_()).m_35571_())) != null && !trades.isEmpty() && (listings = (VillagerTrades.ItemListing[])trades.get(tier)) != null && listings.length > 0 && (newOffer = (listing = listings[villager.m_217043_().m_188503_(listings.length)]).m_213663_((Entity)villager, villager.m_217043_())) != null) {
            ((PseudoAccessorMerchantOffer)newOffer).quark$setTier(tier);
            return newOffer;
        }
        return null;
    }

    public static boolean canUseSeededRandom(LivingEntity villager) {
        return staticEnabled && seedInitialVillagerTrades && villager instanceof VillagerDataHolder;
    }

    public static boolean shouldUseSeededRandom(LivingEntity villager, MerchantOffers offers) {
        return VillagerRerollingReworkModule.canUseSeededRandom(villager) && offers.isEmpty();
    }

    public static RandomSource seededRandomForVillager(AbstractVillager villager) {
        long seed = villager.getPersistentData().m_128454_(TAG_VILLAGER_SEED);
        return RandomSource.m_216335_((long)seed);
    }

    static {
        seedInitialVillagerTrades = true;
        chanceToRerollWhenRestocking = 0.25;
        maximumRestocksPerDay = 3;
        rerollOnAnyRestock = false;
        rerollEvenIfNotOutOfStock = false;
    }
}

