/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class AbacusItem
extends ZetaItem {
    public static final String TAG_POS_X = "boundPosX";
    public static final String TAG_POS_Y = "boundPosY";
    public static final String TAG_POS_Z = "boundPosZ";
    public static int MAX_COUNT = 48;
    private static final int DEFAULT_Y = -999;

    public AbacusItem(ZetaModule module) {
        super("abacus", module, new Item.Properties().m_41487_(1));
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.f_256869_, (ItemLike)this, (ItemLike)Items.f_151059_, (boolean)true);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos curr = AbacusItem.getBlockPos(stack);
        if (curr != null) {
            AbacusItem.setBlockPos(stack, null);
        } else {
            AbacusItem.setBlockPos(stack, context.m_8083_());
        }
        return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
    }

    public static void setBlockPos(ItemStack stack, BlockPos pos) {
        if (pos == null) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Y, (int)-999);
        } else {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_X, (int)pos.m_123341_());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Y, (int)pos.m_123342_());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Z, (int)pos.m_123343_());
        }
    }

    public static BlockPos getBlockPos(ItemStack stack) {
        int y = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Y, (int)-999);
        if (y == -999) {
            return null;
        }
        int x = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_X, (int)0);
        int z = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Z, (int)0);
        return new BlockPos(x, y, z);
    }

    public static int getCount(ItemStack stack, BlockPos target, Level world) {
        BlockPos pos = AbacusItem.getBlockPos(stack);
        if (pos != null && !world.m_46859_(target)) {
            return Mth.m_14045_((int)target.m_123333_((Vec3i)pos), (int)0, (int)MAX_COUNT);
        }
        return -1;
    }

    public static class Client {
        public static final ClampedItemPropertyFunction ITEM_PROPERTY_FUNCTION = (stack, level, entityIn, id) -> {
            int count = Client.getCount(stack, entityIn);
            if (count == -1) {
                return 1.0f;
            }
            return 0.01f * (float)count + 0.005f;
        };

        public static int getCount(ItemStack stack, LivingEntity entityIn) {
            HitResult result;
            int count = -1;
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (entityIn == player && player != null && (result = mc.f_91077_) instanceof BlockHitResult) {
                BlockPos target = ((BlockHitResult)result).m_82425_();
                count = AbacusItem.getCount(stack, target, player.m_9236_());
            }
            return count;
        }
    }
}

