/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.widget;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.layout.editor.widget.AbstractLayoutEditorWidget;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import de.keksuccino.fancymenu.util.rendering.ui.UIComponent;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLayoutEditorWidgetBuilder<T extends AbstractLayoutEditorWidget> {
    public static final File WIDGET_SETTINGS_DIR = FileUtils.createDirectory(new File(FancyMenu.MOD_DIR, "/layout_editor/widgets"));
    private static final LayoutEditorScreen DUMMY_LAYOUT_EDITOR = new LayoutEditorScreen(Layout.buildUniversal());
    private final String identifier;

    public AbstractLayoutEditorWidgetBuilder(@NotNull String identifier) {
        if (!CharacterFilter.buildOnlyLowercaseFileNameFilter().isAllowedText(identifier)) {
            throw new RuntimeException("Invalid characters in identifier! Only characters [a-z], [0-9], [-] and [_] are supported. No spaces!");
        }
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public abstract void applySettings(@NotNull LayoutEditorScreen var1, @NotNull WidgetSettings var2, @NotNull T var3);

    @Nullable
    public AbstractLayoutEditorWidget buildWithSettingsInternal(@NotNull LayoutEditorScreen editor) {
        try {
            String visible;
            String expanded;
            AbstractLayoutEditorWidget.SnappingSide s;
            String snappingSide;
            String innerHeight;
            String innerWidth;
            String offsetY;
            WidgetSettings settings = this.readSettingsInternal();
            T widget = this.buildDefaultInstance(Objects.requireNonNull(editor));
            this.applySettings(editor, Objects.requireNonNull(settings), (AbstractLayoutEditorWidget)Objects.requireNonNull(widget));
            String offsetX = settings.getValue("offset_x");
            if (offsetX != null && MathUtils.isFloat((String)offsetX)) {
                ((AbstractLayoutEditorWidget)widget).setUnscaledWidgetOffsetX(Float.parseFloat(offsetX), true);
            }
            if ((offsetY = settings.getValue("offset_y")) != null && MathUtils.isFloat((String)offsetY)) {
                ((AbstractLayoutEditorWidget)widget).setUnscaledWidgetOffsetY(Float.parseFloat(offsetY), true);
            }
            if ((innerWidth = settings.getValue("inner_width")) != null && MathUtils.isFloat((String)innerWidth)) {
                ((AbstractLayoutEditorWidget)widget).setBodyWidth(Float.parseFloat(innerWidth));
            }
            if ((innerHeight = settings.getValue("inner_height")) != null && MathUtils.isFloat((String)innerHeight)) {
                ((AbstractLayoutEditorWidget)widget).setBodyHeight(Float.parseFloat(innerHeight));
            }
            if ((snappingSide = settings.getValue("snapping_side")) != null && (s = AbstractLayoutEditorWidget.SnappingSide.getByName(snappingSide)) != null) {
                ((AbstractLayoutEditorWidget)widget).snappingSide = s;
            }
            if ((expanded = settings.getValue("expanded")) != null) {
                if (expanded.equals("true")) {
                    ((AbstractLayoutEditorWidget)widget).setExpanded(true);
                } else if (expanded.equals("false")) {
                    ((AbstractLayoutEditorWidget)widget).setExpanded(false);
                }
            }
            if ((visible = settings.getValue("visible")) != null) {
                if (visible.equals("true")) {
                    ((UIComponent)widget).setVisible(true);
                } else if (visible.equals("false")) {
                    ((UIComponent)widget).setVisible(false);
                }
            }
            return widget;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @NotNull
    public abstract T buildDefaultInstance(@NotNull LayoutEditorScreen var1);

    public abstract void writeSettings(@NotNull WidgetSettings var1, @NotNull T var2);

    public void writeSettingsInternal(@NotNull AbstractLayoutEditorWidget widgetInstance) {
        try {
            WidgetSettings settings = new WidgetSettings();
            settings.putProperty("offset_x", "" + widgetInstance.getUnscaledWidgetOffsetX());
            settings.putProperty("offset_y", "" + widgetInstance.getUnscaledWidgetOffsetY());
            settings.putProperty("inner_width", "" + widgetInstance.getBodyWidth());
            settings.putProperty("inner_height", "" + widgetInstance.getBodyHeight());
            settings.putProperty("snapping_side", widgetInstance.snappingSide.name);
            settings.putProperty("expanded", "" + widgetInstance.isExpanded());
            settings.putProperty("visible", "" + widgetInstance.isVisible());
            this.writeSettings(settings, widgetInstance);
            PropertyContainerSet set = new PropertyContainerSet("layout_editor_widget_settings");
            set.putContainer(settings);
            PropertiesParser.serializeSetToFile(set, this.getSettingsFile().getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Nullable
    public WidgetSettings readSettingsInternal() {
        try {
            List<PropertyContainer> containers;
            PropertyContainerSet set;
            File savedSettingsFile = this.getSettingsFile();
            if (!savedSettingsFile.isFile()) {
                this.writeSettingsInternal((AbstractLayoutEditorWidget)Objects.requireNonNull(this.buildDefaultInstance(DUMMY_LAYOUT_EDITOR)));
            }
            if ((set = PropertiesParser.deserializeSetFromFile(savedSettingsFile.getAbsolutePath())) != null && !(containers = set.getContainersOfType("settings")).isEmpty()) {
                return WidgetSettings.convertContainerToSettings(containers.get(0));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public File getSettingsFile() {
        return new File(WIDGET_SETTINGS_DIR, "/" + this.getIdentifier() + ".lewidget");
    }

    public static class WidgetSettings
    extends PropertyContainer {
        public WidgetSettings() {
            super("settings");
        }

        @NotNull
        public static WidgetSettings convertContainerToSettings(@NotNull PropertyContainer container) {
            WidgetSettings settings = new WidgetSettings();
            for (Map.Entry<String, String> m : container.getProperties().entrySet()) {
                settings.putProperty(m.getKey(), m.getValue());
            }
            return settings;
        }
    }
}

