/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.file;

import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.file.type.types.AudioFileType;
import de.keksuccino.fancymenu.util.file.type.types.FileTypes;
import de.keksuccino.fancymenu.util.file.type.types.ImageFileType;
import de.keksuccino.fancymenu.util.file.type.types.TextFileType;
import de.keksuccino.fancymenu.util.file.type.types.VideoFileType;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import java.io.File;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface FileFilter {
    public static final FileFilter RESOURCE_NAME_FILTER = file -> {
        String name = GameDirectoryUtils.getPathWithoutGameDirectory(file.getAbsolutePath()).replace("/", "").replace("\\", "");
        return CharacterFilter.buildResourceNameFilter().isAllowedText(name);
    };
    public static final FileFilter IMAGE_FILE_FILTER = file -> {
        for (ImageFileType type : FileTypes.getAllImageFileTypes()) {
            if (!type.isFileTypeLocal(file)) continue;
            return true;
        }
        return false;
    };
    public static final FileFilter AUDIO_FILE_FILTER = file -> {
        for (AudioFileType type : FileTypes.getAllAudioFileTypes()) {
            if (!type.isFileTypeLocal(file)) continue;
            return true;
        }
        return false;
    };
    public static final FileFilter VIDEO_FILE_FILTER = file -> {
        for (VideoFileType type : FileTypes.getAllVideoFileTypes()) {
            if (!type.isFileTypeLocal(file)) continue;
            return true;
        }
        return false;
    };
    public static final FileFilter TEXT_FILE_FILTER = file -> {
        for (TextFileType type : FileTypes.getAllTextFileTypes()) {
            if (!type.isFileTypeLocal(file)) continue;
            return true;
        }
        return false;
    };

    public boolean checkFile(@NotNull File var1);
}

