/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.computercraft.peripheral.ability;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IOwnerAbility;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 4*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u00014B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\bH$J\b\u0010 \u001a\u00020\bH\u0004J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0004J\u0010\u0010$\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\bH&J\u001c\u0010%\u001a\u00020\"2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'H\u0016J\u0016\u0010*\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u0014J\u0013\u0010,\u001a\u00020\u00142\b\u0010-\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010.\u001a\u00020\bH\u0016J\u000e\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\bJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\bH\u0007R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0012\u0010\r\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0012\u0010\u0011\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\nR\u0011\u0010\u0018\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\nR\u001c\u0010\u0005\u001a\u00028\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u0006\u00a8\u00065"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/FuelAbility;", "T", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "Lsite/siredvin/peripheralium/api/peripheral/IOwnerAbility;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "owner", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;)V", "fuelConsumptionMultiply", "", "getFuelConsumptionMultiply", "()I", "fuelConsumptionRate", "getFuelConsumptionRate", "fuelCount", "getFuelCount", "fuelLevel", "getFuelLevel", "fuelMaxCount", "getFuelMaxCount", "isFuelConsumptionDisable", "", "()Z", "maxFuelConsumptionRate", "getMaxFuelConsumptionRate", "maxFuelLevel", "getMaxFuelLevel", "getOwner", "()Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "setOwner", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "_consumeFuel", "count", "_getFuelConsumptionRate", "_setFuelConsumptionRate", "", "raw_rate", "addFuel", "collectConfiguration", "data", "", "", "", "consumeFuel", "simulate", "equals", "other", "hashCode", "reduceCooldownAccordingToConsumptionRate", "cooldown", "setFuelConsumptionRate", "Ldan200/computercraft/api/lua/MethodResult;", "rate", "Companion", "peripheralium-forge-1.20.1"})
public abstract class FuelAbility<T extends IPeripheralOwner>
implements IOwnerAbility,
IPeripheralPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private T owner;
    @NotNull
    protected static final String FUEL_CONSUMING_RATE_SETTING = "FUEL_CONSUMING_RATE";
    protected static final int DEFAULT_FUEL_CONSUMING_RATE = 1;

    public FuelAbility(@NotNull T owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        this.owner = owner;
    }

    @NotNull
    protected final T getOwner() {
        return this.owner;
    }

    protected final void setOwner(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.owner = t;
    }

    protected abstract boolean _consumeFuel(int var1);

    protected abstract int getMaxFuelConsumptionRate();

    protected final int _getFuelConsumptionRate() {
        CompoundTag settings = this.owner.getDataStorage();
        int rate = settings.m_128451_(FUEL_CONSUMING_RATE_SETTING);
        if (rate == 0) {
            this._setFuelConsumptionRate(1);
            return 1;
        }
        return rate;
    }

    protected final void _setFuelConsumptionRate(int raw_rate) {
        int maxFuelRate;
        int rate = raw_rate;
        if (rate < 1) {
            rate = 1;
        }
        if (rate > (maxFuelRate = this.getMaxFuelConsumptionRate())) {
            rate = maxFuelRate;
        }
        this.owner.getDataStorage().m_128405_(FUEL_CONSUMING_RATE_SETTING, rate);
    }

    public abstract boolean isFuelConsumptionDisable();

    public abstract int getFuelCount();

    public abstract int getFuelMaxCount();

    public abstract void addFuel(int var1);

    public final int getFuelConsumptionMultiply() {
        return (int)Math.pow(2.0, this._getFuelConsumptionRate() - 1);
    }

    public final int reduceCooldownAccordingToConsumptionRate(int cooldown) {
        return cooldown / this._getFuelConsumptionRate();
    }

    public final boolean consumeFuel(int count, boolean simulate) {
        if (this.isFuelConsumptionDisable()) {
            return true;
        }
        int realCount = count * this.getFuelConsumptionMultiply();
        return simulate ? this.getFuelLevel() >= realCount : this._consumeFuel(realCount);
    }

    @LuaFunction(mainThread=true)
    public final int getFuelLevel() {
        return this.getFuelCount();
    }

    @LuaFunction(mainThread=true)
    public final int getMaxFuelLevel() {
        return this.getFuelMaxCount();
    }

    @LuaFunction(mainThread=true)
    public final int getFuelConsumptionRate() {
        return this._getFuelConsumptionRate();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult setFuelConsumptionRate(int rate) {
        if (rate < 1) {
            Object[] objectArray = new Object[]{null, "Too small fuel consumption rate"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Too small fuel consumption rate\")");
            return methodResult;
        }
        if (rate > this.getMaxFuelConsumptionRate()) {
            Object[] objectArray = new Object[]{null, "Too big fuel consumption rate"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Too big fuel consumption rate\")");
            return methodResult;
        }
        this._setFuelConsumptionRate(rate);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @Override
    public void collectConfiguration(@NotNull Map<String, Object> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        data.put("maxFuelConsumptionRate", this.getMaxFuelConsumptionRate());
        data.put("isFuelConsumptionDisable", this.isFuelConsumptionDisable());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FuelAbility)) {
            return false;
        }
        if (this.getMaxFuelConsumptionRate() != ((FuelAbility)other).getMaxFuelConsumptionRate()) {
            return false;
        }
        if (this.isFuelConsumptionDisable() != ((FuelAbility)other).isFuelConsumptionDisable()) {
            return false;
        }
        if (this.getFuelCount() != ((FuelAbility)other).getFuelCount()) {
            return false;
        }
        return this.getFuelMaxCount() == ((FuelAbility)other).getFuelMaxCount();
    }

    public int hashCode() {
        int result = this.getMaxFuelConsumptionRate();
        result = 31 * result + Boolean.hashCode(this.isFuelConsumptionDisable());
        result = 31 * result + this.getFuelCount();
        result = 31 * result + this.getFuelMaxCount();
        return result;
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods(this, server);
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }

    @Override
    @Nullable
    public String getAdditionalType() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalType(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/FuelAbility$Companion;", "", "()V", "DEFAULT_FUEL_CONSUMING_RATE", "", "FUEL_CONSUMING_RATE_SETTING", "", "peripheralium-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

