/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.computercraft.peripheral.ability;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.computercraft.peripheral.ability.FuelAbility;
import site.siredvin.peripheralium.computercraft.peripheral.owner.PocketPeripheralOwner;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0013\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/PocketFuelAbility;", "Lsite/siredvin/peripheralium/computercraft/peripheral/ability/FuelAbility;", "Lsite/siredvin/peripheralium/computercraft/peripheral/owner/PocketPeripheralOwner;", "owner", "foodFuelPrice", "", "maxFuelConsumptionRate", "(Lsite/siredvin/peripheralium/computercraft/peripheral/owner/PocketPeripheralOwner;II)V", "fuelConsumptionBuffer", "fuelCount", "getFuelCount", "()I", "fuelMaxCount", "getFuelMaxCount", "isFuelConsumptionDisable", "", "()Z", "getMaxFuelConsumptionRate", "_consumeFuel", "count", "addFuel", "", "correctBuffer", "foodData", "Lnet/minecraft/world/food/FoodData;", "equals", "other", "", "hashCode", "Companion", "peripheralium-forge-1.20.1"})
public final class PocketFuelAbility
extends FuelAbility<PocketPeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int foodFuelPrice;
    private final int maxFuelConsumptionRate;
    private int fuelConsumptionBuffer;
    public static final int MAX_FOOD_LEVEL = 20;

    public PocketFuelAbility(@NotNull PocketPeripheralOwner owner, int foodFuelPrice, int maxFuelConsumptionRate) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super((IPeripheralOwner)owner);
        this.foodFuelPrice = foodFuelPrice;
        this.maxFuelConsumptionRate = maxFuelConsumptionRate;
    }

    @Override
    protected int getMaxFuelConsumptionRate() {
        return this.maxFuelConsumptionRate;
    }

    private final void correctBuffer(FoodData foodData) {
        if (this.fuelConsumptionBuffer > this.foodFuelPrice) {
            int foodToConsume = this.fuelConsumptionBuffer / this.foodFuelPrice;
            foodData.m_38705_(Math.max(foodData.m_38702_() - foodToConsume, 0));
            this.fuelConsumptionBuffer %= this.foodFuelPrice;
        }
    }

    @Override
    protected boolean _consumeFuel(int count) {
        Player player = ((PocketPeripheralOwner)this.getOwner()).getOwner();
        Object object = player != null ? player.m_36324_() : null;
        if (object == null) {
            return false;
        }
        FoodData foodData = object;
        if (this.getFuelCount() < count) {
            return false;
        }
        this.fuelConsumptionBuffer += count;
        this.correctBuffer(foodData);
        return true;
    }

    @Override
    public boolean isFuelConsumptionDisable() {
        Player player = ((PocketPeripheralOwner)this.getOwner()).getOwner();
        return player != null ? player.m_7500_() : true;
    }

    @Override
    public int getFuelCount() {
        Player player = ((PocketPeripheralOwner)this.getOwner()).getOwner();
        return (player != null && (player = player.m_36324_()) != null ? player.m_38702_() : 0) * this.foodFuelPrice - this.fuelConsumptionBuffer;
    }

    @Override
    public int getFuelMaxCount() {
        return ((PocketPeripheralOwner)this.getOwner()).getOwner() != null ? 20 * this.foodFuelPrice : 0;
    }

    @Override
    public void addFuel(int count) {
        int leftFuel;
        Player player = ((PocketPeripheralOwner)this.getOwner()).getOwner();
        Object object = player != null ? player.m_36324_() : null;
        if (object == null) {
            return;
        }
        FoodData foodData = object;
        int foodToAdd = count / this.foodFuelPrice;
        if (foodToAdd > 0) {
            foodData.m_38705_(Math.min(20, foodData.m_38702_() + foodToAdd));
        }
        if ((leftFuel = count % this.foodFuelPrice) > 0) {
            this.fuelConsumptionBuffer -= leftFuel;
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PocketFuelAbility)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (this.foodFuelPrice != ((PocketFuelAbility)other).foodFuelPrice) {
            return false;
        }
        if (this.getMaxFuelConsumptionRate() != ((PocketFuelAbility)other).getMaxFuelConsumptionRate()) {
            return false;
        }
        return this.fuelConsumptionBuffer == ((PocketFuelAbility)other).fuelConsumptionBuffer;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.foodFuelPrice;
        result = 31 * result + this.getMaxFuelConsumptionRate();
        result = 31 * result + this.fuelConsumptionBuffer;
        return result;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/PocketFuelAbility$Companion;", "", "()V", "MAX_FOOD_LEVEL", "", "peripheralium-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

