/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.computercraft.peripheral.owner;

import dan200.computercraft.api.lua.LuaException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.blockentities.IOwnedBlockEntity;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.api.peripheral.IPeripheralTileEntity;
import site.siredvin.peripheralium.computercraft.peripheral.owner.BasePeripheralOwner;
import site.siredvin.peripheralium.ext.BlockPosExtKt;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.ItemStorageExtractor;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;
import site.siredvin.peripheralium.util.DataStorageUtil;
import site.siredvin.peripheralium.util.world.FakePlayerProviderEntity;
import site.siredvin.peripheralium.util.world.FakePlayerProxy;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010,\u001a\u00020-H\u0016J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u00104\u001a\u00020-H\u0016J\u0018\u00105\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)H\u0016J9\u00108\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u00012\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002H\u00010:2\b\u0010<\u001a\u0004\u0018\u00010\u000e2\u0006\u0010=\u001a\u00020/H\u0016\u00a2\u0006\u0002\u0010>R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006?"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/owner/EntityProxyPeripheralOwner;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralTileEntity;", "Lsite/siredvin/peripheralium/computercraft/peripheral/owner/BasePeripheralOwner;", "tileEntity", "entity", "Lnet/minecraft/world/entity/Entity;", "(Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/entity/Entity;)V", "dataStorage", "Lnet/minecraft/nbt/CompoundTag;", "getDataStorage", "()Lnet/minecraft/nbt/CompoundTag;", "facing", "Lnet/minecraft/core/Direction;", "getFacing", "()Lnet/minecraft/core/Direction;", "level", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "owner", "Lnet/minecraft/world/entity/player/Player;", "getOwner", "()Lnet/minecraft/world/entity/player/Player;", "pos", "Lnet/minecraft/core/BlockPos;", "getPos", "()Lnet/minecraft/core/BlockPos;", "storage", "Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "getStorage", "()Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "storage$delegate", "Lkotlin/Lazy;", "targetRepresentation", "", "getTargetRepresentation", "()Ljava/lang/Object;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "toolInMainHand", "Lnet/minecraft/world/item/ItemStack;", "getToolInMainHand", "()Lnet/minecraft/world/item/ItemStack;", "destroyUpgrade", "", "equals", "", "other", "hashCode", "", "isMovementPossible", "markDataStorageDirty", "move", "storeItem", "stored", "withPlayer", "function", "Lkotlin/Function1;", "Lsite/siredvin/peripheralium/util/world/FakePlayerProxy;", "overwrittenDirection", "skipInventory", "(Lkotlin/jvm/functions/Function1;Lnet/minecraft/core/Direction;Z)Ljava/lang/Object;", "peripheralium-forge-1.20.1"})
public final class EntityProxyPeripheralOwner<T extends BlockEntity>
extends BasePeripheralOwner {
    @NotNull
    private final T tileEntity;
    @NotNull
    private final Entity entity;
    @NotNull
    private final Lazy storage$delegate;

    public EntityProxyPeripheralOwner(@NotNull T tileEntity, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(tileEntity, (String)"tileEntity");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.tileEntity = tileEntity;
        this.entity = entity;
        this.storage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SlottedItemStorage>(this){
            final /* synthetic */ EntityProxyPeripheralOwner<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SlottedItemStorage invoke() {
                Level level = EntityProxyPeripheralOwner.access$getEntity$p(this.this$0).m_9236_();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"entity.level()");
                ItemStorage itemStorage = ItemStorageExtractor.INSTANCE.extractStorage(level, EntityProxyPeripheralOwner.access$getEntity$p(this.this$0));
                return itemStorage instanceof SlottedItemStorage ? (SlottedItemStorage)itemStorage : null;
            }
        }));
    }

    @Override
    @NotNull
    public Level getLevel() {
        Level level = this.entity.m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"entity.level()");
        return level;
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        BlockPos blockPos = this.entity.m_20183_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"entity.blockPosition()");
        return blockPos;
    }

    @Override
    @NotNull
    public Direction getFacing() {
        Direction direction = Direction.m_122364_((double)this.entity.m_146908_());
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"fromYRot(entity.yRot.toDouble())");
        return direction;
    }

    @Override
    @Nullable
    public Player getOwner() {
        T t = this.tileEntity;
        IOwnedBlockEntity iOwnedBlockEntity = t instanceof IOwnedBlockEntity ? (IOwnedBlockEntity)t : null;
        return iOwnedBlockEntity != null ? iOwnedBlockEntity.getPlayer() : null;
    }

    @Override
    @NotNull
    public CompoundTag getDataStorage() {
        return DataStorageUtil.INSTANCE.getDataStorage((IPeripheralTileEntity)this.tileEntity);
    }

    @Override
    @Nullable
    public SlottedItemStorage getStorage() {
        Lazy lazy = this.storage$delegate;
        return (SlottedItemStorage)lazy.getValue();
    }

    @Override
    public void markDataStorageDirty() {
        this.tileEntity.m_6596_();
    }

    @Override
    public <T> T withPlayer(@NotNull Function1<? super FakePlayerProxy, ? extends T> function, @Nullable Direction overwrittenDirection, boolean skipInventory) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        if (!(this.tileEntity instanceof IOwnedBlockEntity)) {
            throw new IllegalArgumentException("Cannot perform player logic without owned block entity");
        }
        Player player = ((IOwnedBlockEntity)this.tileEntity).getPlayer();
        ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        if (serverPlayer == null) {
            throw new LuaException("Cannot correctly find player");
        }
        ServerPlayer player2 = serverPlayer;
        return (T)FakePlayerProviderEntity.INSTANCE.withPlayer(this.entity, player2, arg_0 -> EntityProxyPeripheralOwner.withPlayer$lambda$0(function, arg_0), overwrittenDirection, skipInventory);
    }

    @Override
    @NotNull
    public ItemStack getToolInMainHand() {
        Entity entity = this.entity;
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        Object object = livingEntity != null ? livingEntity.m_21120_(InteractionHand.MAIN_HAND) : null;
        if (object == null) {
            ItemStack itemStack = ItemStack.f_41583_;
            object = itemStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        }
        return object;
    }

    @Override
    @NotNull
    public ItemStack storeItem(@NotNull ItemStack stored) {
        Intrinsics.checkNotNullParameter((Object)stored, (String)"stored");
        if (this.getStorage() == null) {
            return stored;
        }
        SlottedItemStorage slottedItemStorage = this.getStorage();
        Intrinsics.checkNotNull((Object)slottedItemStorage);
        return slottedItemStorage.storeItem(stored);
    }

    @Override
    public void destroyUpgrade() {
        this.getLevel().m_7471_(this.tileEntity.m_58899_(), false);
    }

    @Override
    public boolean isMovementPossible(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return (Boolean)IPeripheralOwner.DefaultImpls.withPlayer$default(this, (Function1)new Function1<FakePlayerProxy, Boolean>(level, pos){
            final /* synthetic */ Level $level;
            final /* synthetic */ BlockPos $pos;
            {
                this.$level = $level;
                this.$pos = $pos;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FakePlayerProxy fakePlayerProxy) {
                Intrinsics.checkNotNullParameter((Object)fakePlayerProxy, (String)"<anonymous parameter 0>");
                if (this.$level.m_151570_(this.$pos)) {
                    return false;
                }
                if (!this.$level.m_46739_(this.$pos)) {
                    return false;
                }
                if (!this.$level.m_46749_(this.$pos)) {
                    return false;
                }
                return this.$level.m_6857_().m_61937_(this.$pos);
            }
        }, null, false, 6, null);
    }

    @Override
    public boolean move(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.entity.m_20219_(BlockPosExtKt.toVec3(pos));
        return true;
    }

    @Override
    public int hashCode() {
        int result = this.tileEntity.hashCode();
        result = 31 * result + this.entity.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EntityProxyPeripheralOwner)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tileEntity, ((EntityProxyPeripheralOwner)other).tileEntity)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.entity, (Object)((EntityProxyPeripheralOwner)other).entity);
    }

    @Override
    @NotNull
    public Object getTargetRepresentation() {
        return this.entity;
    }

    private static final Object withPlayer$lambda$0(Function1 $tmp0, FakePlayerProxy p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return $tmp0.invoke((Object)p0);
    }

    public static final /* synthetic */ Entity access$getEntity$p(EntityProxyPeripheralOwner $this) {
        return $this.entity;
    }
}

