/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.data.blocks;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.data.language.ModInformationHolder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000bJ>\u0010\f\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000b2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010\u0015\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000bJ*\u0010\u0016\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000bJ\u0006\u0010\u0017\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lsite/siredvin/peripheralium/data/blocks/LootTableHelper;", "", "informationHolder", "Lsite/siredvin/peripheralium/data/language/ModInformationHolder;", "(Lsite/siredvin/peripheralium/data/language/ModInformationHolder;)V", "registeredBlocks", "", "Lnet/minecraft/world/level/block/Block;", "computedDrop", "", "wrapper", "Ljava/util/function/Supplier;", "dropBlock", "consumer", "Ljava/util/function/BiConsumer;", "Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/world/level/storage/loot/LootTable$Builder;", "drop", "Lnet/minecraft/world/level/storage/loot/entries/LootPoolEntryContainer$Builder;", "condition", "Lnet/minecraft/world/level/storage/loot/predicates/LootItemCondition$Builder;", "dropNamedBlock", "dropSelf", "validate", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nLootTableHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LootTableHelper.kt\nsite/siredvin/peripheralium/data/blocks/LootTableHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1855#2,2:65\n*S KotlinDebug\n*F\n+ 1 LootTableHelper.kt\nsite/siredvin/peripheralium/data/blocks/LootTableHelper\n*L\n57#1:65,2\n*E\n"})
public final class LootTableHelper {
    @NotNull
    private final ModInformationHolder informationHolder;
    @NotNull
    private final Set<Block> registeredBlocks;

    public LootTableHelper(@NotNull ModInformationHolder informationHolder) {
        Intrinsics.checkNotNullParameter((Object)informationHolder, (String)"informationHolder");
        this.informationHolder = informationHolder;
        this.registeredBlocks = new LinkedHashSet();
    }

    public final void dropSelf(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> consumer, @NotNull Supplier<? extends Block> wrapper) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter(wrapper, (String)"wrapper");
        LootPoolSingletonContainer.Builder builder = LootItem.m_79579_((ItemLike)((ItemLike)wrapper.get()));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"lootTableItem(wrapper.get())");
        LootPoolEntryContainer.Builder builder2 = (LootPoolEntryContainer.Builder)builder;
        LootItemCondition.Builder builder3 = ExplosionCondition.m_81661_();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"survivesExplosion()");
        this.dropBlock(consumer, wrapper, builder2, builder3);
    }

    public final void dropNamedBlock(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> consumer, @NotNull Supplier<? extends Block> wrapper) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter(wrapper, (String)"wrapper");
        LootPoolSingletonContainer.Builder builder = LootItem.m_79579_((ItemLike)((ItemLike)wrapper.get())).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"lootTableItem(wrapper.ge\u2026NameSource.BLOCK_ENTITY))");
        LootPoolEntryContainer.Builder builder2 = (LootPoolEntryContainer.Builder)builder;
        LootItemCondition.Builder builder3 = ExplosionCondition.m_81661_();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"survivesExplosion()");
        this.dropBlock(consumer, wrapper, builder2, builder3);
    }

    public final void dropBlock(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> consumer, @NotNull Supplier<? extends Block> wrapper, @NotNull LootPoolEntryContainer.Builder<?> drop, @NotNull LootItemCondition.Builder condition) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter(wrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter(drop, (String)"drop");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Block block = wrapper.get();
        consumer.accept(block.m_60589_(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(drop).m_79080_(condition)));
        this.registeredBlocks.add(block);
    }

    public final void computedDrop(@NotNull Supplier<? extends Block> wrapper) {
        Intrinsics.checkNotNullParameter(wrapper, (String)"wrapper");
        this.registeredBlocks.add(wrapper.get());
    }

    public final void validate() {
        Iterable $this$forEach$iv = this.informationHolder.getBlocks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Supplier it = (Supplier)element$iv;
            boolean bl = false;
            if (this.registeredBlocks.contains(it.get())) continue;
            throw new Exception(((Block)it.get()).m_7705_() + " doesn't have registered drop");
        }
    }
}

