/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.data.blocks;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.xplat.XplatRegistries;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0002\u001a\u00020\u0011H\u0016JV\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0002\u001a\u00020\u00112\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u00162\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u0002H\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lsite/siredvin/peripheralium/data/blocks/ModelProvider;", "Lnet/minecraft/data/DataProvider;", "output", "Lnet/minecraft/data/PackOutput;", "blocks", "Ljava/util/function/Consumer;", "Lnet/minecraft/data/models/BlockModelGenerators;", "items", "Lnet/minecraft/data/models/ItemModelGenerators;", "(Lnet/minecraft/data/PackOutput;Ljava/util/function/Consumer;Ljava/util/function/Consumer;)V", "blockStatePath", "Lnet/minecraft/data/PackOutput$PathProvider;", "modelPath", "getName", "", "run", "Ljava/util/concurrent/CompletableFuture;", "Lnet/minecraft/data/CachedOutput;", "saveCollection", "", "T", "futures", "", "", "Ljava/util/function/Supplier;", "Lcom/google/gson/JsonElement;", "getLocation", "Ljava/util/function/Function;", "Ljava/nio/file/Path;", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nModelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelProvider.kt\nsite/siredvin/peripheralium/data/blocks/ModelProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class ModelProvider
implements DataProvider {
    @NotNull
    private final Consumer<BlockModelGenerators> blocks;
    @NotNull
    private final Consumer<ItemModelGenerators> items;
    @NotNull
    private final PackOutput.PathProvider blockStatePath;
    @NotNull
    private final PackOutput.PathProvider modelPath;

    public ModelProvider(@NotNull PackOutput output, @NotNull Consumer<BlockModelGenerators> blocks, @NotNull Consumer<ItemModelGenerators> items) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.blocks = blocks;
        this.items = items;
        PackOutput.PathProvider pathProvider = output.m_245269_(PackOutput.Target.RESOURCE_PACK, "blockstates");
        Intrinsics.checkNotNullExpressionValue((Object)pathProvider, (String)"output.createPathProvide\u2026URCE_PACK, \"blockstates\")");
        this.blockStatePath = pathProvider;
        PackOutput.PathProvider pathProvider2 = output.m_245269_(PackOutput.Target.RESOURCE_PACK, "models");
        Intrinsics.checkNotNullExpressionValue((Object)pathProvider2, (String)"output.createPathProvide\u2026.RESOURCE_PACK, \"models\")");
        this.modelPath = pathProvider2;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Map blockStates = new HashMap();
        Consumer<BlockStateGenerator> addBlockState = arg_0 -> ModelProvider.run$lambda$1(blockStates, arg_0);
        Map models = new HashMap();
        BiConsumer<ResourceLocation, Supplier> addModel = (arg_0, arg_1) -> ModelProvider.run$lambda$3(models, arg_0, arg_1);
        Set explicitItems = new HashSet();
        this.blocks.accept(new BlockModelGenerators(addBlockState, addModel, arg_0 -> ModelProvider.run$lambda$4(explicitItems, arg_0)));
        this.items.accept(new ItemModelGenerators(addModel));
        for (Block block : XplatRegistries.INSTANCE.getBLOCKS()) {
            ResourceLocation model;
            Item item;
            if (!blockStates.containsKey(block) || (item = (Item)Item.f_41373_.get(block)) == null || explicitItems.contains(item) || models.containsKey(model = ModelLocationUtils.m_125571_((Item)item))) continue;
            Intrinsics.checkNotNullExpressionValue((Object)model, (String)"model");
            models.put(model, new DelegatedModel(ModelLocationUtils.m_125576_((Block)block)));
        }
        List futures = new ArrayList();
        this.saveCollection(output, futures, blockStates, arg_0 -> ModelProvider.run$lambda$5(this, arg_0));
        this.saveCollection(output, futures, models, arg_0 -> ((PackOutput.PathProvider)this.modelPath).m_245731_(arg_0));
        CompletableFuture completableFuture = Util.m_143840_((List)futures);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"sequenceFailFast(futures)");
        return completableFuture;
    }

    private final <T> void saveCollection(CachedOutput output, List<CompletableFuture<?>> futures, Map<T, ? extends Supplier<JsonElement>> items, Function<T, Path> getLocation) {
        for (Map.Entry<T, Supplier<JsonElement>> entry : items.entrySet()) {
            Path path;
            T key = entry.getKey();
            Supplier<JsonElement> value = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)getLocation.apply(key), (String)"getLocation.apply(key)");
            CompletableFuture completableFuture = DataProvider.m_253162_((CachedOutput)output, (JsonElement)value.get(), (Path)path);
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"saveStable(output, value.get(), path)");
            futures.add(completableFuture);
        }
    }

    @NotNull
    public String m_6055_() {
        return "Block State Definitions";
    }

    private static final void run$lambda$1(Map $blockStates, BlockStateGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)$blockStates, (String)"$blockStates");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Block block = generator.m_6968_();
        if (!(!$blockStates.containsKey(block))) {
            boolean bl = false;
            String string = "Duplicate blockstate definition for " + block;
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"block");
        $blockStates.put(block, generator);
    }

    private static final void run$lambda$3(Map $models, ResourceLocation id, Supplier contents) {
        Intrinsics.checkNotNullParameter((Object)$models, (String)"$models");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        if (!(!$models.containsKey(id))) {
            boolean bl = false;
            String string = "Duplicate model definition for " + id;
            throw new IllegalStateException(string.toString());
        }
        $models.put(id, contents);
    }

    private static final void run$lambda$4(Set $explicitItems, Item e) {
        Intrinsics.checkNotNullParameter((Object)$explicitItems, (String)"$explicitItems");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $explicitItems.add(e);
    }

    private static final Path run$lambda$5(ModelProvider this$0, Block it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.blockStatePath.m_245731_(XplatRegistries.INSTANCE.getBLOCKS().getKey(it));
    }
}

