/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.data.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.xplat.XplatRegistries;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0010J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\fJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\fJ\u0014\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u001c\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lsite/siredvin/peripheralium/data/blocks/TweakedShapedRecipeBuilder;", "", "_result", "Lnet/minecraft/world/item/Item;", "count", "", "(Lnet/minecraft/world/item/Item;I)V", "get_result", "()Lnet/minecraft/world/item/Item;", "getCount", "()I", "group", "", "key", "", "", "Lnet/minecraft/world/item/crafting/Ingredient;", "result", "getResult", "rows", "", "define", "character", "tagKey", "Lnet/minecraft/tags/TagKey;", "ingredient", "itemLike", "Lnet/minecraft/world/level/ItemLike;", "ensureValid", "", "resourceLocation", "Lnet/minecraft/resources/ResourceLocation;", "string", "pattern", "save", "consumer", "Ljava/util/function/Consumer;", "Lnet/minecraft/data/recipes/FinishedRecipe;", "Companion", "Result", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nTweakedShapedRecipeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TweakedShapedRecipeBuilder.kt\nsite/siredvin/peripheralium/data/blocks/TweakedShapedRecipeBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class TweakedShapedRecipeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Item _result;
    private final int count;
    @NotNull
    private final List<String> rows;
    @NotNull
    private final Map<Character, Ingredient> key;
    @Nullable
    private String group;

    public TweakedShapedRecipeBuilder(@NotNull Item _result, int count) {
        Intrinsics.checkNotNullParameter((Object)_result, (String)"_result");
        this._result = _result;
        this.count = count;
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList()");
        this.rows = arrayList;
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)linkedHashMap, (String)"newLinkedHashMap()");
        this.key = linkedHashMap;
    }

    @NotNull
    public final Item get_result() {
        return this._result;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public final TweakedShapedRecipeBuilder define(char character, @NotNull TagKey<Item> tagKey) {
        Intrinsics.checkNotNullParameter(tagKey, (String)"tagKey");
        Ingredient ingredient = Ingredient.m_204132_(tagKey);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(tagKey)");
        return this.define(character, ingredient);
    }

    @NotNull
    public final TweakedShapedRecipeBuilder define(char character, @NotNull ItemLike itemLike) {
        Intrinsics.checkNotNullParameter((Object)itemLike, (String)"itemLike");
        ItemLike[] itemLikeArray = new ItemLike[]{itemLike};
        Ingredient ingredient = Ingredient.m_43929_((ItemLike[])itemLikeArray);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(itemLike)");
        return this.define(character, ingredient);
    }

    @NotNull
    public final TweakedShapedRecipeBuilder define(char character, @NotNull Ingredient ingredient) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        if (this.key.containsKey(Character.valueOf(character))) {
            throw new IllegalArgumentException("Symbol '" + character + "' is already defined!");
        }
        if (character == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        Character c = Character.valueOf(character);
        this.key.put(c, ingredient);
        return this;
    }

    @NotNull
    public final TweakedShapedRecipeBuilder pattern(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (!((Collection)this.rows).isEmpty() && string.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(string);
        return this;
    }

    @NotNull
    public final TweakedShapedRecipeBuilder group(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.group = string;
        return this;
    }

    @NotNull
    public final Item getResult() {
        return this._result;
    }

    public final void save(@NotNull Consumer<FinishedRecipe> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.save(consumer, XplatRegistries.INSTANCE.getITEMS().getKey(this.getResult()));
    }

    public final void save(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation resourceLocation) {
        String string;
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        this.ensureValid(resourceLocation);
        Item var10004 = this.getResult();
        int var10005 = this.count;
        if (this.group == null) {
            string = "";
        } else {
            String string2 = this.group;
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        String var10006 = string;
        List<String> var10007 = this.rows;
        Map<Character, Ingredient> var10008 = this.key;
        consumer.accept(new Result(resourceLocation, var10004, var10005, var10006, var10007, var10008));
    }

    private final void ensureValid(ResourceLocation resourceLocation) {
        if (!(!((Collection)this.rows).isEmpty())) {
            boolean $i$a$-check-TweakedShapedRecipeBuilder$ensureValid$52 = false;
            String $i$a$-check-TweakedShapedRecipeBuilder$ensureValid$52 = "No pattern is defined for shaped recipe " + resourceLocation + "!";
            throw new IllegalStateException($i$a$-check-TweakedShapedRecipeBuilder$ensureValid$52.toString());
        }
        HashSet hashSet = Sets.newHashSet((Iterable)this.key.keySet());
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(key.keys)");
        Set set = hashSet;
        set.remove(Character.valueOf(' '));
        Iterator<String> var3 = this.rows.iterator();
        while (var3.hasNext()) {
            String string;
            Intrinsics.checkNotNull((Object)var3.next(), (String)"null cannot be cast to non-null type kotlin.String");
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char element = string.charAt(i);
                if (!(this.key.containsKey(Character.valueOf(element)) || element == ' ')) {
                    boolean bl = false;
                    String string2 = "Pattern in recipe " + resourceLocation + " uses undefined symbol '" + element + "'";
                    throw new IllegalStateException(string2.toString());
                }
                set.remove(Character.valueOf(element));
            }
        }
        if (!set.isEmpty()) {
            boolean $i$a$-check-TweakedShapedRecipeBuilder$ensureValid$62 = false;
            String $i$a$-check-TweakedShapedRecipeBuilder$ensureValid$62 = "Ingredients are defined but not used in pattern for recipe " + resourceLocation;
            throw new IllegalStateException($i$a$-check-TweakedShapedRecipeBuilder$ensureValid$62.toString());
        }
        if (!(this.rows.size() != 1 || this.rows.get(0).length() != 1)) {
            boolean bl = false;
            String string = "Shaped recipe " + resourceLocation + " only takes in a single item - should it be a shapeless recipe instead?";
            throw new IllegalStateException(string.toString());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lsite/siredvin/peripheralium/data/blocks/TweakedShapedRecipeBuilder$Companion;", "", "()V", "shaped", "Lsite/siredvin/peripheralium/data/blocks/TweakedShapedRecipeBuilder;", "itemLike", "Lnet/minecraft/world/level/ItemLike;", "i", "", "peripheralium-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TweakedShapedRecipeBuilder shaped(@NotNull ItemLike itemLike) {
            Intrinsics.checkNotNullParameter((Object)itemLike, (String)"itemLike");
            return this.shaped(itemLike, 1);
        }

        @NotNull
        public final TweakedShapedRecipeBuilder shaped(@NotNull ItemLike itemLike, int i) {
            Intrinsics.checkNotNullParameter((Object)itemLike, (String)"itemLike");
            Item item = itemLike.m_5456_();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"itemLike.asItem()");
            return new TweakedShapedRecipeBuilder(item, i);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lsite/siredvin/peripheralium/data/blocks/TweakedShapedRecipeBuilder$Result;", "Lnet/minecraft/data/recipes/FinishedRecipe;", "id", "Lnet/minecraft/resources/ResourceLocation;", "result", "Lnet/minecraft/world/item/Item;", "count", "", "group", "", "pattern", "", "key", "", "", "Lnet/minecraft/world/item/crafting/Ingredient;", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/world/item/Item;ILjava/lang/String;Ljava/util/List;Ljava/util/Map;)V", "getAdvancementId", "getId", "getType", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "serializeAdvancement", "Lcom/google/gson/JsonObject;", "serializeRecipeData", "", "jsonObject", "peripheralium-forge-1.20.1"})
    private static final class Result
    implements FinishedRecipe {
        @NotNull
        private final ResourceLocation id;
        @NotNull
        private final Item result;
        private final int count;
        @NotNull
        private final String group;
        @NotNull
        private final List<String> pattern;
        @NotNull
        private final Map<Character, Ingredient> key;

        public Result(@NotNull ResourceLocation id, @NotNull Item result, int count, @NotNull String group, @NotNull List<String> pattern, @NotNull Map<Character, ? extends Ingredient> key) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(key, (String)"key");
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
        }

        public void m_7917_(@NotNull JsonObject jsonObject) {
            Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
            if (((CharSequence)this.group).length() > 0) {
                jsonObject.addProperty("group", this.group);
            }
            JsonArray jsonArray = new JsonArray();
            Iterator<String> var3 = this.pattern.iterator();
            while (var3.hasNext()) {
                String string;
                Intrinsics.checkNotNull((Object)var3.next(), (String)"null cannot be cast to non-null type kotlin.String");
                jsonArray.add(string);
            }
            jsonObject.add("pattern", (JsonElement)jsonArray);
            JsonObject jsonObject2 = new JsonObject();
            Iterator<Map.Entry<Character, Ingredient>> var7 = this.key.entrySet().iterator();
            while (var7.hasNext()) {
                Map.Entry<Character, Ingredient> entry;
                Intrinsics.checkNotNull(var7.next(), (String)"null cannot be cast to non-null type kotlin.collections.Map.Entry<*, *>");
                Character key1 = entry.getKey();
                Ingredient value = entry.getValue();
                String string = String.valueOf(key1);
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type net.minecraft.world.item.crafting.Ingredient");
                jsonObject2.add(string, value.m_43942_());
            }
            jsonObject.add("key", (JsonElement)jsonObject2);
            JsonObject jsonObject3 = new JsonObject();
            jsonObject3.addProperty("item", XplatRegistries.INSTANCE.getITEMS().getKey(this.result).toString());
            if (this.count > 1) {
                jsonObject3.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)jsonObject3);
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            RecipeSerializer recipeSerializer = RecipeSerializer.f_44076_;
            Intrinsics.checkNotNullExpressionValue((Object)recipeSerializer, (String)"SHAPED_RECIPE");
            return recipeSerializer;
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

