/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.data.language;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.data.language.ExtensionsKt;
import site.siredvin.peripheralium.data.language.LanguageProvider;
import site.siredvin.peripheralium.data.language.ModInformationHolder;
import site.siredvin.peripheralium.data.language.TextRecord;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00052\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0005J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00052\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0005J\b\u0010\u001c\u001a\u00020\u0011H&J\u0016\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 H\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\u0014\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lsite/siredvin/peripheralium/data/language/LanguageProvider;", "Lnet/minecraft/data/DataProvider;", "output", "Lnet/minecraft/data/PackOutput;", "modID", "", "locale", "informationHolder", "Lsite/siredvin/peripheralium/data/language/ModInformationHolder;", "textRecords", "", "Lsite/siredvin/peripheralium/data/language/TextRecord;", "(Lnet/minecraft/data/PackOutput;Ljava/lang/String;Ljava/lang/String;Lsite/siredvin/peripheralium/data/language/ModInformationHolder;[Lsite/siredvin/peripheralium/data/language/TextRecord;)V", "[Lsite/siredvin/peripheralium/data/language/TextRecord;", "translations", "", "add", "", "id", "text", "item", "Lnet/minecraft/world/item/Item;", "tooltip", "block", "Lnet/minecraft/world/level/block/Block;", "record", "addPocket", "Lnet/minecraft/resources/ResourceLocation;", "addTranslations", "addTurtle", "addUpgrades", "getExpectedKeys", "Ljava/util/stream/Stream;", "getName", "run", "Ljava/util/concurrent/CompletableFuture;", "cachedOutput", "Lnet/minecraft/data/CachedOutput;", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nLanguageProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageProvider.kt\nsite/siredvin/peripheralium/data/language/LanguageProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n11065#2:91\n11400#2,3:92\n1#3:95\n*S KotlinDebug\n*F\n+ 1 LanguageProvider.kt\nsite/siredvin/peripheralium/data/language/LanguageProvider\n*L\n45#1:91\n45#1:92,3\n*E\n"})
public abstract class LanguageProvider
implements DataProvider {
    @NotNull
    private final PackOutput output;
    @NotNull
    private final String modID;
    @NotNull
    private final String locale;
    @NotNull
    private final ModInformationHolder informationHolder;
    @NotNull
    private final TextRecord[] textRecords;
    @NotNull
    private final Map<String, String> translations;

    public LanguageProvider(@NotNull PackOutput output, @NotNull String modID, @NotNull String locale, @NotNull ModInformationHolder informationHolder, TextRecord ... textRecords) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)modID, (String)"modID");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)informationHolder, (String)"informationHolder");
        Intrinsics.checkNotNullParameter((Object)textRecords, (String)"textRecords");
        this.output = output;
        this.modID = modID;
        this.locale = locale;
        this.informationHolder = informationHolder;
        this.textRecords = textRecords;
        this.translations = new LinkedHashMap();
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cachedOutput) {
        Intrinsics.checkNotNullParameter((Object)cachedOutput, (String)"cachedOutput");
        this.addTranslations();
        this.getExpectedKeys().forEach(arg_0 -> LanguageProvider.run$lambda$0((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ LanguageProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(String x) {
                if (!LanguageProvider.access$getTranslations$p(this.this$0).containsKey(x)) {
                    boolean bl = false;
                    String string = "No translation for " + x;
                    throw new IllegalStateException(string.toString());
                }
            }
        }, arg_0));
        JsonObject json = new JsonObject();
        for (Map.Entry<String, String> entry : this.translations.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            json.addProperty(key, value);
        }
        CompletableFuture completableFuture = DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)((JsonElement)json), (Path)this.output.m_245114_().resolve("assets/" + this.modID + "/lang/" + this.locale + ".json"));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"saveStable(\n            \u2026$locale.json\"),\n        )");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Stream<String> getExpectedKeys() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Stream[] streamArray = new Stream[6];
        streamArray[0] = this.informationHolder.getBlocks().stream().map(arg_0 -> LanguageProvider.getExpectedKeys$lambda$1(getExpectedKeys.1.INSTANCE, arg_0));
        streamArray[1] = this.informationHolder.getItems().stream().map(arg_0 -> LanguageProvider.getExpectedKeys$lambda$2(getExpectedKeys.2.INSTANCE, arg_0));
        streamArray[2] = this.informationHolder.getCustomStats().stream().map(arg_0 -> LanguageProvider.getExpectedKeys$lambda$3(getExpectedKeys.3.INSTANCE, arg_0));
        streamArray[3] = this.informationHolder.getTurtleSerializers().stream().map(arg_0 -> LanguageProvider.getExpectedKeys$lambda$4(getExpectedKeys.4.INSTANCE, arg_0));
        streamArray[4] = this.informationHolder.getPocketSerializers().stream().map(arg_0 -> LanguageProvider.getExpectedKeys$lambda$5(getExpectedKeys.5.INSTANCE, arg_0));
        TextRecord[] textRecordArray = this.textRecords;
        int n = 5;
        Stream[] streamArray2 = streamArray;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n2; ++i) {
            void it;
            void item$iv$iv;
            void var10_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTextID());
        }
        collection = (List)destination$iv$iv;
        streamArray2[n] = collection.stream();
        Stream<String> stream = Stream.of(streamArray).flatMap(arg_0 -> LanguageProvider.getExpectedKeys$lambda$7(getExpectedKeys.7.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"of(\n            informat\u2026\n        ).flatMap { it }");
        return stream;
    }

    public abstract void addTranslations();

    public final void add(@NotNull String id, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!(!this.translations.containsKey(id))) {
            boolean bl = false;
            String string = "Duplicate translation " + id;
            throw new IllegalArgumentException(string.toString());
        }
        this.translations.put(id, text);
    }

    public final void add(@NotNull Item item, @NotNull String text, @Nullable String tooltip) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = item.m_5524_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.descriptionId");
        this.add(string, text);
        if (tooltip != null) {
            this.add(item.m_5524_() + ".tooltip", tooltip);
        }
    }

    public static /* synthetic */ void add$default(LanguageProvider languageProvider, Item item, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        languageProvider.add(item, string, string2);
    }

    public final void add(@NotNull Block block, @NotNull String text, @Nullable String tooltip) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = block.m_7705_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"block.descriptionId");
        this.add(string, text);
        if (tooltip != null) {
            this.add(block.m_7705_() + ".tooltip", tooltip);
        }
    }

    public static /* synthetic */ void add$default(LanguageProvider languageProvider, Block block, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        languageProvider.add(block, string, string2);
    }

    public final void add(@NotNull TextRecord record, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.add(record.getTextID(), text);
    }

    public final void addPocket(@NotNull ResourceLocation id, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.add(ExtensionsKt.toPocketTranslationKey(id), text);
    }

    public final void addTurtle(@NotNull ResourceLocation id, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.add(ExtensionsKt.toTurtleTranslationKey(id), text);
    }

    public final void addUpgrades(@NotNull ResourceLocation id, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.addPocket(id, text);
        this.addTurtle(id, text);
    }

    @NotNull
    public String m_6055_() {
        return "Language" + this.locale;
    }

    private static final void run$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final String getExpectedKeys$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String getExpectedKeys$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String getExpectedKeys$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String getExpectedKeys$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String getExpectedKeys$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Stream getExpectedKeys$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getTranslations$p(LanguageProvider $this) {
        return $this.translations;
    }
}

