/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.extra.dsl.rml1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.extra.dsl.rml1.ArgumentParsingException;
import site.siredvin.peripheralium.extra.dsl.rml1.IncorrectInstructionException;
import site.siredvin.peripheralium.extra.dsl.rml1.LexemeDoesNotExistsException;
import site.siredvin.peripheralium.extra.dsl.rml1.RMLLexeme;
import site.siredvin.peripheralium.extra.dsl.rml1.RenderInstruction;
import site.siredvin.peripheralium.extra.dsl.rml1.Rotation;
import site.siredvin.peripheralium.extra.dsl.rml1.Scale;
import site.siredvin.peripheralium.extra.dsl.rml1.Translate;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\bJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lsite/siredvin/peripheralium/extra/dsl/rml1/RMLParser;", "", "()V", "lexemes", "", "", "Lsite/siredvin/peripheralium/extra/dsl/rml1/RMLLexeme;", "addLexeme", "", "lexeme", "injectDefault", "parse", "", "Lsite/siredvin/peripheralium/extra/dsl/rml1/RenderInstruction;", "line", "Companion", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nToolkit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Toolkit.kt\nsite/siredvin/peripheralium/extra/dsl/rml1/RMLParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1549#2:59\n1620#2,3:60\n*S KotlinDebug\n*F\n+ 1 Toolkit.kt\nsite/siredvin/peripheralium/extra/dsl/rml1/RMLParser\n*L\n38#1:59\n38#1:60,3\n*E\n"})
public final class RMLParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, RMLLexeme> lexemes = new LinkedHashMap();
    @NotNull
    public static final String INSTRUCTION_SEPARATOR = ";";
    @NotNull
    private static final Regex GROUPING_REGEX = new Regex("([\\w\\W_]+)\\((.*)\\)");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RenderInstruction> parse(@NotNull String line) throws ArgumentParsingException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String[] stringArray = new String[]{INSTRUCTION_SEPARATOR};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RMLLexeme lexemeParser;
            MatchResult parsedGroup;
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (Regex.find$default((Regex)GROUPING_REGEX, (CharSequence)((CharSequence)it), (int)0, (int)2, null) == null) {
                throw new IncorrectInstructionException("Instruction " + (String)it + " isn't correctly defined");
            }
            String lexemeName = (String)parsedGroup.getGroupValues().get(1);
            String arguments = (String)parsedGroup.getGroupValues().get(2);
            if (this.lexemes.get(lexemeName) == null) {
                throw new LexemeDoesNotExistsException("Instruction " + lexemeName + " doesn't exists");
            }
            collection.add(lexemeParser.build(arguments));
        }
        return (List)destination$iv$iv;
    }

    public final void addLexeme(@NotNull RMLLexeme lexeme) {
        Intrinsics.checkNotNullParameter((Object)lexeme, (String)"lexeme");
        this.lexemes.put(lexeme.getName(), lexeme);
    }

    public final void injectDefault() {
        this.addLexeme(Translate.Companion);
        this.addLexeme(Rotation.Companion);
        this.addLexeme(Scale.Companion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lsite/siredvin/peripheralium/extra/dsl/rml1/RMLParser$Companion;", "", "()V", "GROUPING_REGEX", "Lkotlin/text/Regex;", "getGROUPING_REGEX", "()Lkotlin/text/Regex;", "INSTRUCTION_SEPARATOR", "", "peripheralium-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getGROUPING_REGEX() {
            return GROUPING_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

